/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Message;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoEquality;
import dev.cel.runtime.ProtoMessageRuntimeHelpers;
import dev.cel.runtime.RuntimeEquality;
import java.util.Objects;

@Immutable
@Internal
public final class ProtoMessageRuntimeEquality
extends RuntimeEquality {
    private final ProtoEquality protoEquality;

    @Internal
    public static ProtoMessageRuntimeEquality create(DynamicProto dynamicProto, CelOptions celOptions) {
        return new ProtoMessageRuntimeEquality(dynamicProto, celOptions);
    }

    @Override
    public boolean objectEquals(Object x, Object y) {
        if (this.celOptions.disableCelStandardEquality()) {
            return Objects.equals(x, y);
        }
        if (x == y) {
            return true;
        }
        if (this.celOptions.enableProtoDifferencerEquality()) {
            x = this.runtimeHelpers.adaptValue(x);
            y = this.runtimeHelpers.adaptValue(y);
            if (x instanceof Message) {
                if (!(y instanceof Message)) {
                    return false;
                }
                return this.protoEquality.equals((Message)x, (Message)y);
            }
        }
        return super.objectEquals(x, y);
    }

    private ProtoMessageRuntimeEquality(DynamicProto dynamicProto, CelOptions celOptions) {
        super(ProtoMessageRuntimeHelpers.create(dynamicProto, celOptions), celOptions);
        this.protoEquality = new ProtoEquality(dynamicProto);
    }
}

