/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.MessageLite;
import dev.cel.runtime.FunctionOverload;
import java.util.List;
import java.util.Map;

@Immutable
interface ResolvedOverload {
    public String getOverloadId();

    public List<Class<?>> getParameterTypes();

    public FunctionOverload getDefinition();

    default public boolean canHandle(Object[] arguments) {
        List<Class<?>> parameterTypes = this.getParameterTypes();
        if (parameterTypes.size() != arguments.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Class<?> paramType = parameterTypes.get(i);
            Object arg = arguments[i];
            if (!(arg == null ? paramType != Object.class && !MessageLite.class.isAssignableFrom(paramType) && !Map.class.isAssignableFrom(paramType) : !paramType.isAssignableFrom(arg.getClass()))) continue;
            return false;
        }
        return true;
    }
}

