/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.MessageLiteOrBuilder;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.ComparisonFunctions;
import dev.cel.runtime.RuntimeHelpers;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
@Internal
public class RuntimeEquality {
    protected final RuntimeHelpers runtimeHelpers;
    protected final CelOptions celOptions;

    public static RuntimeEquality create(RuntimeHelpers runtimeHelper, CelOptions celOptions) {
        return new RuntimeEquality(runtimeHelper, celOptions);
    }

    public <A> boolean inList(List<A> list, A value) {
        if (list.contains(value)) {
            return true;
        }
        if (value instanceof Number) {
            for (A elem : list) {
                if (!this.objectEquals(elem, value)) continue;
                return true;
            }
        }
        return false;
    }

    public <A, B> B indexMap(Map<A, B> map, A index) {
        Optional<Object> value = this.findInMap(map, index);
        if (value.isPresent()) {
            return (B)value.get();
        }
        throw new CelRuntimeException(new IndexOutOfBoundsException(index.toString()), CelErrorCode.ATTRIBUTE_NOT_FOUND);
    }

    public <A, B> boolean inMap(Map<A, B> map, A key) {
        return this.findInMap(map, key).isPresent();
    }

    public Optional<Object> findInMap(Map<?, ?> map, Object index) {
        Object v;
        if (this.celOptions.disableCelStandardEquality()) {
            return Optional.ofNullable(map.get(index));
        }
        if (index instanceof MessageLiteOrBuilder) {
            index = this.runtimeHelpers.adaptProtoToValue((MessageLiteOrBuilder)index);
        }
        if ((v = map.get(index)) != null) {
            return Optional.of(v);
        }
        if (index instanceof Long) {
            return RuntimeEquality.longToUnsignedLossless((Long)index).map(map::get);
        }
        if (index instanceof UnsignedLong) {
            return RuntimeEquality.unsignedToLongLossless((UnsignedLong)index).map(map::get);
        }
        if (index instanceof Number) {
            Number numberIndex = (Number)index;
            Optional<Object> indexValue = RuntimeHelpers.doubleToLongLossless(numberIndex).map(map::get);
            if (indexValue.isPresent()) {
                return indexValue;
            }
            return RuntimeEquality.doubleToUnsignedLossless(numberIndex).map(map::get);
        }
        return Optional.empty();
    }

    public boolean objectEquals(Object x, Object y) {
        if (this.celOptions.disableCelStandardEquality()) {
            return Objects.equals(x, y);
        }
        if (x == y) {
            return true;
        }
        x = this.runtimeHelpers.adaptValue(x);
        y = this.runtimeHelpers.adaptValue(y);
        if (x instanceof Number) {
            if (!(y instanceof Number)) {
                return false;
            }
            return ComparisonFunctions.numericEquals((Number)x, (Number)y);
        }
        if (this.celOptions.enableProtoDifferencerEquality() && x instanceof MessageLiteOrBuilder) {
            if (!(y instanceof MessageLiteOrBuilder)) {
                return false;
            }
            throw new UnsupportedOperationException("Proto Differencer equality is not supported for MessageLite.");
        }
        if (x instanceof Iterable) {
            if (!(y instanceof Iterable)) {
                return false;
            }
            Iterable xIter = (Iterable)x;
            Iterable yIter = (Iterable)y;
            Iterator yElems = yIter.iterator();
            IllegalArgumentException e = null;
            for (Object xElem : xIter) {
                if (!yElems.hasNext()) {
                    return false;
                }
                try {
                    if (this.objectEquals(xElem, yElems.next())) continue;
                    return false;
                }
                catch (IllegalArgumentException iae) {
                    e = iae;
                }
            }
            if (yElems.hasNext()) {
                return false;
            }
            if (e != null) {
                throw e;
            }
            return true;
        }
        if (x instanceof Map) {
            if (!(y instanceof Map)) {
                return false;
            }
            Map xMap = (Map)x;
            Map yMap = (Map)y;
            if (xMap.size() != yMap.size()) {
                return false;
            }
            IllegalArgumentException e = null;
            Set entrySet = xMap.entrySet();
            for (Map.Entry xEntry : entrySet) {
                Optional<Object> yVal = this.findInMap(yMap, xEntry.getKey());
                if (!yVal.isPresent()) {
                    return false;
                }
                try {
                    if (this.objectEquals(xEntry.getValue(), yVal.get())) continue;
                    return false;
                }
                catch (IllegalArgumentException iae) {
                    e = iae;
                }
            }
            if (e != null) {
                throw e;
            }
            return true;
        }
        return Objects.equals(x, y);
    }

    private static Optional<UnsignedLong> doubleToUnsignedLossless(Number v) {
        Optional<UnsignedLong> conv = RuntimeHelpers.doubleToUnsignedChecked(v.doubleValue());
        return conv.map(ul -> (double)ul.longValue() == v.doubleValue() ? ul : null);
    }

    private static Optional<UnsignedLong> longToUnsignedLossless(long v) {
        if (v >= 0L) {
            return Optional.of(UnsignedLong.valueOf(v));
        }
        return Optional.empty();
    }

    private static Optional<Long> unsignedToLongLossless(UnsignedLong v) {
        if (v.compareTo(UnsignedLong.valueOf(Long.MAX_VALUE)) <= 0) {
            return Optional.of(v.longValue());
        }
        return Optional.empty();
    }

    RuntimeEquality(RuntimeHelpers runtimeHelpers, CelOptions celOptions) {
        this.runtimeHelpers = runtimeHelpers;
        this.celOptions = celOptions;
    }
}

