/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedLong;
import com.google.common.primitives.UnsignedLongs;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Duration;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.NullValue;
import com.google.re2j.Pattern;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.Converter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.threeten.extra.AmountFormats;

@Immutable
@Internal
public class RuntimeHelpers {
    private static final java.time.Duration DURATION_MAX = java.time.Duration.ofDays(3652500L);
    private static final java.time.Duration DURATION_MIN = DURATION_MAX.negated();
    static final Converter<Integer, Long> INT32_TO_INT64 = Integer::longValue;
    static final Converter<Float, Double> FLOAT_TO_DOUBLE = Float::doubleValue;
    static final Converter<Long, Integer> INT64_TO_INT32 = Ints::checkedCast;
    static final Converter<Double, Float> DOUBLE_TO_FLOAT = Double::floatValue;

    public static RuntimeHelpers create() {
        return new RuntimeHelpers();
    }

    public static Duration createDurationFromString(String d) {
        try {
            java.time.Duration dv = AmountFormats.parseUnitBasedDuration(d);
            Preconditions.checkArgument(dv.compareTo(DURATION_MAX) <= 0 && dv.compareTo(DURATION_MIN) >= 0, "invalid duration range");
            return Duration.newBuilder().setSeconds(dv.getSeconds()).setNanos(dv.getNano()).build();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("invalid duration format", e);
        }
    }

    public static boolean matches(String string, String regexp, CelOptions celOptions) {
        Pattern pattern = Pattern.compile(regexp);
        int maxProgramSize = celOptions.maxRegexProgramSize();
        if (maxProgramSize >= 0 && pattern.programSize() > maxProgramSize) {
            throw new IllegalArgumentException(String.format("Regex pattern exceeds allowed program size. Allowed: %d, Provided: %d", maxProgramSize, pattern.programSize()));
        }
        if (!celOptions.enableRegexPartialMatch()) {
            return pattern.matcher(string).matches();
        }
        return pattern.matcher(string).find();
    }

    public static <E> List<E> concat(List<E> first, List<E> second) {
        ArrayList<E> result = new ArrayList<E>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static <A> A indexList(List<A> list, Number index) {
        if (index instanceof Double) {
            return (A)RuntimeHelpers.doubleToLongLossless(index.doubleValue()).map(v -> RuntimeHelpers.indexList(list, v)).orElseThrow(() -> new CelRuntimeException(new IndexOutOfBoundsException("Index out of bounds: " + index.doubleValue()), CelErrorCode.INDEX_OUT_OF_BOUNDS));
        }
        int castIndex = Ints.checkedCast(index.longValue());
        if (castIndex < 0 || castIndex >= list.size()) {
            throw new CelRuntimeException(new IndexOutOfBoundsException("Index out of bounds: " + castIndex), CelErrorCode.INDEX_OUT_OF_BOUNDS);
        }
        return list.get(castIndex);
    }

    public static long int64Add(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.addExact(x, y);
        }
        return x + y;
    }

    public static long int64Divide(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap() && x == Long.MIN_VALUE && y == -1L) {
            throw new ArithmeticException("most negative number wraps");
        }
        return x / y;
    }

    public static long int64Multiply(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.multiplyExact(x, y);
        }
        return x * y;
    }

    public static long int64Negate(long x, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.negateExact(x);
        }
        return -x;
    }

    public static long int64Subtract(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.subtractExact(x, y);
        }
        return x - y;
    }

    public static long uint64Add(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            if (x < 0L && y < 0L) {
                throw new ArithmeticException("range overflow on unsigned addition");
            }
            long z = x + y;
            if ((x < 0L || y < 0L) && z >= 0L) {
                throw new ArithmeticException("range overflow on unsigned addition");
            }
            return z;
        }
        return x + y;
    }

    public static UnsignedLong uint64Add(UnsignedLong x, UnsignedLong y) {
        if (x.compareTo(UnsignedLong.MAX_VALUE.minus(y)) > 0) {
            throw new ArithmeticException("range overflow on unsigned addition");
        }
        return x.plus(y);
    }

    public static int uint64CompareTo(long x, long y, CelOptions celOptions) {
        return celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? UnsignedLongs.compare(x, y) : UnsignedLong.valueOf(x).compareTo(UnsignedLong.valueOf(y));
    }

    static int uint64CompareTo(long x, long y) {
        return RuntimeHelpers.uint64CompareTo(x, y, CelOptions.LEGACY);
    }

    public static int uint64CompareTo(UnsignedLong x, UnsignedLong y) {
        return x.compareTo(y);
    }

    public static long uint64Divide(long x, long y, CelOptions celOptions) {
        try {
            return celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? UnsignedLongs.divide(x, y) : UnsignedLong.valueOf(x).dividedBy(UnsignedLong.valueOf(y)).longValue();
        }
        catch (ArithmeticException e) {
            throw new CelRuntimeException(e, CelErrorCode.DIVIDE_BY_ZERO);
        }
    }

    static long uint64Divide(long x, long y) {
        return RuntimeHelpers.uint64Divide(x, y, CelOptions.LEGACY);
    }

    public static UnsignedLong uint64Divide(UnsignedLong x, UnsignedLong y) {
        if (y.equals(UnsignedLong.ZERO)) {
            throw new CelRuntimeException(new ArithmeticException("/ by zero"), CelErrorCode.DIVIDE_BY_ZERO);
        }
        return x.dividedBy(y);
    }

    public static long uint64Mod(long x, long y, CelOptions celOptions) {
        try {
            return celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? UnsignedLongs.remainder(x, y) : UnsignedLong.valueOf(x).mod(UnsignedLong.valueOf(y)).longValue();
        }
        catch (ArithmeticException e) {
            throw new CelRuntimeException(e, CelErrorCode.DIVIDE_BY_ZERO);
        }
    }

    public static UnsignedLong uint64Mod(UnsignedLong x, UnsignedLong y) {
        if (y.equals(UnsignedLong.ZERO)) {
            throw new CelRuntimeException(new ArithmeticException("/ by zero"), CelErrorCode.DIVIDE_BY_ZERO);
        }
        return x.mod(y);
    }

    static long uint64Mod(long x, long y) {
        return RuntimeHelpers.uint64Mod(x, y, CelOptions.LEGACY);
    }

    public static long uint64Multiply(long x, long y, CelOptions celOptions) {
        long z;
        long l = z = celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? x * y : UnsignedLong.valueOf(x).times(UnsignedLong.valueOf(y)).longValue();
        if (celOptions.errorOnIntWrap() && y != 0L && Long.divideUnsigned(z, y) != x) {
            throw new ArithmeticException("multiply out of unsigned integer range");
        }
        return z;
    }

    static long uint64Multiply(long x, long y) {
        return RuntimeHelpers.uint64Multiply(x, y, CelOptions.LEGACY);
    }

    public static UnsignedLong uint64Multiply(UnsignedLong x, UnsignedLong y) {
        if (!y.equals(UnsignedLong.ZERO) && x.compareTo(UnsignedLong.MAX_VALUE.dividedBy(y)) > 0) {
            throw new ArithmeticException("multiply out of unsigned integer range");
        }
        return x.times(y);
    }

    public static long uint64Subtract(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap() && (x < 0L && y < 0L && x < y || x >= 0L && y >= 0L && x < y || x >= 0L && y < 0L)) {
            throw new ArithmeticException("unsigned subtraction underflow");
        }
        return x - y;
    }

    public static UnsignedLong uint64Subtract(UnsignedLong x, UnsignedLong y) {
        if (x.compareTo(y) < 0) {
            throw new ArithmeticException("unsigned subtraction underflow");
        }
        return x.minus(y);
    }

    static <A> Converter<A, A> identity() {
        return value -> value;
    }

    public Object adaptValue(Object value) {
        if (value == null) {
            return NullValue.NULL_VALUE;
        }
        if (value instanceof Number) {
            return RuntimeHelpers.maybeAdaptPrimitive(value);
        }
        if (value instanceof MessageLiteOrBuilder) {
            return this.adaptProtoToValue((MessageLiteOrBuilder)value);
        }
        return value;
    }

    static Object maybeAdaptPrimitive(Object value) {
        if (value instanceof Optional) {
            Optional optionalVal = (Optional)value;
            if (!optionalVal.isPresent()) {
                return optionalVal;
            }
            return Optional.of(RuntimeHelpers.maybeAdaptPrimitive(optionalVal.get()));
        }
        if (value instanceof Float) {
            return FLOAT_TO_DOUBLE.convert((Float)value);
        }
        if (value instanceof Integer) {
            return INT32_TO_INT64.convert((Integer)value);
        }
        return value;
    }

    Object adaptProtoToValue(MessageLiteOrBuilder obj) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public static Optional<UnsignedLong> doubleToUnsignedChecked(double v) {
        if (v < 0.0 || Math.getExponent(v) >= 64) {
            return Optional.empty();
        }
        if (v >= Math.scalb(1.0, 63)) {
            v -= Math.scalb(1.0, 64);
        }
        return Optional.of(UnsignedLong.fromLongBits((long)v));
    }

    public static Optional<Long> doubleToLongChecked(double v) {
        int exp = Math.getExponent(v);
        if (exp >= 63 && v != Math.scalb(-1.0, 63)) {
            return Optional.empty();
        }
        return Optional.of((long)v);
    }

    static Optional<Long> doubleToLongLossless(Number v) {
        Optional<Long> conv = RuntimeHelpers.doubleToLongChecked(v.doubleValue());
        return conv.map(l -> l.doubleValue() == v.doubleValue() ? l : null);
    }

    RuntimeHelpers() {
    }
}

