/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.common.annotations.Internal;
import dev.cel.runtime.CelAttribute;
import dev.cel.runtime.CelAttributeResolver;
import dev.cel.runtime.CelUnknownSet;
import dev.cel.runtime.DefaultInterpreter;
import dev.cel.runtime.GlobalResolver;
import dev.cel.runtime.InterpreterUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Internal
public class RuntimeUnknownResolver {
    private static final CelAttributeResolver DEFAULT_RESOLVER = new NullAttributeResolver();
    private final GlobalResolver resolver;
    private final CelAttributeResolver attributeResolver;
    private final boolean attributeTrackingEnabled;

    private RuntimeUnknownResolver(GlobalResolver resolver, CelAttributeResolver attributeResolver, boolean attributeTrackingEnabled) {
        this.resolver = resolver;
        this.attributeResolver = attributeResolver;
        this.attributeTrackingEnabled = attributeTrackingEnabled;
    }

    public static RuntimeUnknownResolver fromResolver(GlobalResolver resolver) {
        return new RuntimeUnknownResolver(resolver, DEFAULT_RESOLVER, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    Optional<CelUnknownSet> maybePartialUnknown(CelAttribute attribute) {
        return this.attributeResolver.maybePartialUnknown(attribute);
    }

    DefaultInterpreter.IntermediateResult resolveSimpleName(String name, Long exprId) {
        Optional<Object> result;
        CelAttribute attr = CelAttribute.EMPTY;
        if (this.attributeTrackingEnabled && (result = this.attributeResolver.resolve(attr = CelAttribute.fromQualifiedIdentifier(name))).isPresent()) {
            return DefaultInterpreter.IntermediateResult.create(attr, result.get());
        }
        result = this.resolver.resolve(name);
        return DefaultInterpreter.IntermediateResult.create(attr, InterpreterUtil.valueOrUnknown(result, exprId));
    }

    void cacheLazilyEvaluatedResult(String name, DefaultInterpreter.IntermediateResult result) {
    }

    Optional<Object> resolveAttribute(CelAttribute attr) {
        return this.attributeResolver.resolve(attr);
    }

    ScopedResolver withScope(Map<String, DefaultInterpreter.IntermediateResult> vars) {
        return new ScopedResolver(this, vars);
    }

    public static class Builder {
        private CelAttributeResolver attributeResolver;
        private GlobalResolver resolver = GlobalResolver.EMPTY;

        private Builder() {
            this.attributeResolver = DEFAULT_RESOLVER;
        }

        @CanIgnoreReturnValue
        public Builder setResolver(GlobalResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAttributeResolver(CelAttributeResolver resolver) {
            this.attributeResolver = resolver;
            return this;
        }

        public RuntimeUnknownResolver build() {
            return new RuntimeUnknownResolver(this.resolver, this.attributeResolver, true);
        }
    }

    static final class ScopedResolver
    extends RuntimeUnknownResolver {
        private final RuntimeUnknownResolver parent;
        private final Map<String, DefaultInterpreter.IntermediateResult> shadowedVars;
        private final Map<String, DefaultInterpreter.IntermediateResult> lazyEvalResultCache;

        private ScopedResolver(RuntimeUnknownResolver parent, Map<String, DefaultInterpreter.IntermediateResult> shadowedVars) {
            super(parent.resolver, parent.attributeResolver, parent.attributeTrackingEnabled);
            this.parent = parent;
            this.shadowedVars = shadowedVars;
            this.lazyEvalResultCache = new HashMap<String, DefaultInterpreter.IntermediateResult>();
        }

        @Override
        DefaultInterpreter.IntermediateResult resolveSimpleName(String name, Long exprId) {
            DefaultInterpreter.IntermediateResult result = this.lazyEvalResultCache.get(name);
            if (result != null) {
                return result;
            }
            result = this.shadowedVars.get(name);
            if (result != null) {
                return result;
            }
            return this.parent.resolveSimpleName(name, exprId);
        }

        @Override
        void cacheLazilyEvaluatedResult(String name, DefaultInterpreter.IntermediateResult result) {
            this.lazyEvalResultCache.put(name, result);
        }
    }

    private static final class NullAttributeResolver
    implements CelAttributeResolver {
        private NullAttributeResolver() {
        }

        @Override
        public Optional<Object> resolve(CelAttribute attr) {
            return Optional.empty();
        }

        @Override
        public Optional<CelUnknownSet> maybePartialUnknown(CelAttribute attr) {
            return Optional.empty();
        }
    }
}

