/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.Timestamp;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.StructType;
import dev.cel.common.types.StructTypeReference;
import dev.cel.common.types.TypeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Immutable
class TypeResolver {
    @VisibleForTesting
    static final TypeType RUNTIME_TYPE_TYPE = TypeType.create(SimpleType.DYN);
    private static final ImmutableMap<Class<?>, TypeType> COMMON_TYPES = ImmutableMap.builder().put(Boolean.class, TypeType.create(SimpleType.BOOL)).put(Double.class, TypeType.create(SimpleType.DOUBLE)).put(Long.class, TypeType.create(SimpleType.INT)).put(UnsignedLong.class, TypeType.create(SimpleType.UINT)).put(String.class, TypeType.create(SimpleType.STRING)).put(NullValue.class, TypeType.create(SimpleType.NULL_TYPE)).put(Duration.class, TypeType.create(SimpleType.DURATION)).put(Timestamp.class, TypeType.create(SimpleType.TIMESTAMP)).put(ArrayList.class, TypeType.create(ListType.create(SimpleType.DYN))).put(HashMap.class, TypeType.create(MapType.create(SimpleType.DYN, SimpleType.DYN))).put(Optional.class, TypeType.create(OptionalType.create(SimpleType.DYN))).buildOrThrow();
    private static final ImmutableMap<Class<?>, TypeType> EXTENDABLE_TYPES = ImmutableMap.builder().put(Collection.class, TypeType.create(ListType.create(SimpleType.DYN))).put(ByteString.class, TypeType.create(SimpleType.BYTES)).put(Map.class, TypeType.create(MapType.create(SimpleType.DYN, SimpleType.DYN))).buildOrThrow();

    static TypeResolver create() {
        return new TypeResolver();
    }

    TypeType adaptType(CelType typeCheckedType) {
        Preconditions.checkNotNull(typeCheckedType);
        switch (typeCheckedType.kind()) {
            case TYPE: {
                CelType typeOfType = ((TypeType)typeCheckedType).type();
                switch (typeOfType.kind()) {
                    case STRUCT: {
                        return TypeType.create(TypeResolver.adaptStructType((StructType)typeOfType));
                    }
                }
                return (TypeType)typeCheckedType;
            }
            case UNSPECIFIED: {
                throw new IllegalArgumentException("Unsupported CelType kind: " + (Object)((Object)typeCheckedType.kind()));
            }
        }
        return TypeType.create(typeCheckedType);
    }

    Optional<TypeType> resolveWellKnownObjectType(Object obj) {
        if (obj instanceof TypeType) {
            return Optional.of(RUNTIME_TYPE_TYPE);
        }
        Class<?> currentClass = obj.getClass();
        TypeType commonType = COMMON_TYPES.get(currentClass);
        if (commonType != null) {
            return Optional.of(commonType);
        }
        if (ImmutableList.class.isAssignableFrom(currentClass)) {
            return Optional.of(TypeType.create(ListType.create(SimpleType.DYN)));
        }
        if (ImmutableMap.class.isAssignableFrom(currentClass)) {
            return Optional.of(TypeType.create(MapType.create(SimpleType.DYN, SimpleType.DYN)));
        }
        return Optional.empty();
    }

    TypeType resolveObjectType(Object obj, CelType typeCheckedType) {
        Preconditions.checkNotNull(obj);
        Optional<TypeType> wellKnownTypeType = this.resolveWellKnownObjectType(obj);
        if (wellKnownTypeType.isPresent()) {
            return wellKnownTypeType.get();
        }
        if (obj instanceof MessageLiteOrBuilder) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        for (Class<?> currentClass = obj.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            TypeType runtimeType = EXTENDABLE_TYPES.get(currentClass);
            if (runtimeType != null) {
                return runtimeType;
            }
            for (Class<?> interfaceClass : currentClass.getInterfaces()) {
                runtimeType = EXTENDABLE_TYPES.get(interfaceClass);
                if (runtimeType == null) continue;
                return runtimeType;
            }
        }
        return (TypeType)typeCheckedType;
    }

    private static CelType adaptStructType(StructType typeOfType) {
        String structName = typeOfType.name();
        CelType newTypeOfType = structName.equals(SimpleType.DURATION.name()) ? SimpleType.DURATION : (structName.equals(SimpleType.TIMESTAMP.name()) ? SimpleType.TIMESTAMP : StructTypeReference.create(typeOfType.name()));
        return newTypeOfType;
    }

    TypeResolver() {
    }
}

