/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.ArithmeticHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;
import java.util.List;

public final class AddOperator
extends CelStandardFunction {
    private static final AddOperator ALL_OVERLOADS = AddOperator.create(AddOverload.values());

    public static AddOperator create() {
        return ALL_OVERLOADS;
    }

    public static AddOperator create(AddOverload ... overloads) {
        return AddOperator.create(Arrays.asList(overloads));
    }

    public static AddOperator create(Iterable<AddOverload> overloads) {
        return new AddOperator(ImmutableSet.copyOf(overloads));
    }

    private AddOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum AddOverload implements CelStandardOverload
    {
        ADD_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Add(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
            }
        })),
        ADD_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("add_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> {
                    try {
                        return RuntimeHelpers.uint64Add(x, y);
                    }
                    catch (ArithmeticException e) {
                        throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
                    }
                });
            }
            return CelFunctionBinding.from("add_uint64", Long.class, Long.class, (x, y) -> {
                try {
                    return RuntimeHelpers.uint64Add(x, y, celOptions);
                }
                catch (ArithmeticException e) {
                    throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
                }
            });
        }),
        ADD_BYTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_bytes", ByteString.class, ByteString.class, ByteString::concat)),
        ADD_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_double", Double.class, Double.class, Double::sum)),
        ADD_DURATION_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_duration_duration", Duration.class, Duration.class, ProtoTimeUtils::add)),
        ADD_TIMESTAMP_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_timestamp_duration", Timestamp.class, Duration.class, ProtoTimeUtils::add)),
        ADD_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_string", String.class, String.class, (x, y) -> x + y)),
        ADD_DURATION_TIMESTAMP((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_duration_timestamp", Duration.class, Timestamp.class, (x, y) -> ProtoTimeUtils.add(y, x))),
        ADD_LIST((celOptions, runtimeEquality) -> CelFunctionBinding.from("add_list", List.class, List.class, RuntimeHelpers::concat));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private AddOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

