/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.internal.SafeStringFormatter;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class BoolFunction
extends CelStandardFunction {
    private static final BoolFunction ALL_OVERLOADS = BoolFunction.create(BoolOverload.values());

    public static BoolFunction create() {
        return ALL_OVERLOADS;
    }

    public static BoolFunction create(BoolOverload ... overloads) {
        return BoolFunction.create(Arrays.asList(overloads));
    }

    public static BoolFunction create(Iterable<BoolOverload> overloads) {
        return new BoolFunction(ImmutableSet.copyOf(overloads));
    }

    private BoolFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum BoolOverload implements CelStandardOverload
    {
        BOOL_TO_BOOL((celOptions, runtimeEquality) -> CelFunctionBinding.from("bool_to_bool", Boolean.class, x -> x)),
        STRING_TO_BOOL((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_to_bool", String.class, str -> {
            switch (str) {
                case "true": 
                case "TRUE": 
                case "True": 
                case "t": 
                case "1": {
                    return true;
                }
                case "false": 
                case "FALSE": 
                case "False": 
                case "f": 
                case "0": {
                    return false;
                }
            }
            throw new CelRuntimeException(new IllegalArgumentException(SafeStringFormatter.format("Type conversion error from 'string' to 'bool': [%s]", str)), CelErrorCode.BAD_FORMAT);
        }));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private BoolOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

