/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.protobuf.Timestamp;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelRuntimeException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Locale;

final class DateTimeHelpers {
    static final String UTC = "UTC";

    static LocalDateTime newLocalDateTime(Timestamp ts, String tz) {
        return Instant.ofEpochSecond(ts.getSeconds(), ts.getNanos()).atZone(DateTimeHelpers.timeZone(tz)).toLocalDateTime();
    }

    private static ZoneId timeZone(String tz) {
        try {
            return ZoneId.of(tz);
        }
        catch (DateTimeException e) {
            try {
                int ind = tz.indexOf(":");
                if (ind == -1) {
                    throw new CelRuntimeException(e, CelErrorCode.BAD_FORMAT);
                }
                int hourOffset = Integer.parseInt(tz.substring(0, ind));
                int minOffset = Integer.parseInt(tz.substring(ind + 1));
                String formattedOffset = (hourOffset < 0 ? "-" : "+") + String.format(Locale.getDefault(), "%02d:%02d", Math.abs(hourOffset), minOffset);
                return ZoneId.of(formattedOffset);
            }
            catch (DateTimeException e2) {
                throw new CelRuntimeException(e2, CelErrorCode.BAD_FORMAT);
            }
        }
    }

    private DateTimeHelpers() {
    }
}

