/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.ArithmeticHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class DivideOperator
extends CelStandardFunction {
    private static final DivideOperator ALL_OVERLOADS = DivideOperator.create(DivideOverload.values());

    public static DivideOperator create() {
        return ALL_OVERLOADS;
    }

    public static DivideOperator create(DivideOverload ... overloads) {
        return DivideOperator.create(Arrays.asList(overloads));
    }

    public static DivideOperator create(Iterable<DivideOverload> overloads) {
        return new DivideOperator(ImmutableSet.copyOf(overloads));
    }

    private DivideOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum DivideOverload implements CelStandardOverload
    {
        DIVIDE_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("divide_double", Double.class, Double.class, (x, y) -> x / y)),
        DIVIDE_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("divide_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Divide(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
            }
        })),
        DIVIDE_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("divide_uint64", UnsignedLong.class, UnsignedLong.class, RuntimeHelpers::uint64Divide);
            }
            return CelFunctionBinding.from("divide_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64Divide(x, y, celOptions));
        });

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private DivideOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

