/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class DurationFunction
extends CelStandardFunction {
    private static final DurationFunction ALL_OVERLOADS = DurationFunction.create(DurationOverload.values());

    public static DurationFunction create() {
        return ALL_OVERLOADS;
    }

    public static DurationFunction create(DurationOverload ... overloads) {
        return DurationFunction.create(Arrays.asList(overloads));
    }

    public static DurationFunction create(Iterable<DurationOverload> overloads) {
        return new DurationFunction(ImmutableSet.copyOf(overloads));
    }

    private DurationFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum DurationOverload implements CelStandardOverload
    {
        DURATION_TO_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("duration_to_duration", Duration.class, x -> x)),
        STRING_TO_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_to_duration", String.class, d -> {
            try {
                return RuntimeHelpers.createDurationFromString(d);
            }
            catch (IllegalArgumentException e) {
                throw new CelRuntimeException(e, CelErrorCode.BAD_FORMAT);
            }
        }));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private DurationOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

