/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class DynFunction
extends CelStandardFunction {
    private static final DynFunction ALL_OVERLOADS = DynFunction.create(DynOverload.values());

    public static DynFunction create() {
        return ALL_OVERLOADS;
    }

    public static DynFunction create(DynOverload ... overloads) {
        return DynFunction.create(Arrays.asList(overloads));
    }

    public static DynFunction create(Iterable<DynOverload> overloads) {
        return new DynFunction(ImmutableSet.copyOf(overloads));
    }

    private DynFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum DynOverload implements CelStandardOverload
    {
        TO_DYN((celOptions, runtimeEquality) -> CelFunctionBinding.from("to_dyn", Object.class, arg -> arg));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private DynOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

