/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetDateFunction
extends CelStandardFunction {
    private static final GetDateFunction ALL_OVERLOADS = GetDateFunction.create(GetDateOverload.values());

    public static GetDateFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetDateFunction create(GetDateOverload ... overloads) {
        return GetDateFunction.create(Arrays.asList(overloads));
    }

    public static GetDateFunction create(Iterable<GetDateOverload> overloads) {
        return new GetDateFunction(ImmutableSet.copyOf(overloads));
    }

    private GetDateFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetDateOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_DAY_OF_MONTH_1_BASED((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_month_1_based", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getDayOfMonth())),
        TIMESTAMP_TO_DAY_OF_MONTH_1_BASED_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_month_1_based_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getDayOfMonth()));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetDateOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

