/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetDayOfMonthFunction
extends CelStandardFunction {
    private static final GetDayOfMonthFunction ALL_OVERLOADS = GetDayOfMonthFunction.create(GetDayOfMonthOverload.values());

    public static GetDayOfMonthFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetDayOfMonthFunction create(GetDayOfMonthOverload ... overloads) {
        return GetDayOfMonthFunction.create(Arrays.asList(overloads));
    }

    public static GetDayOfMonthFunction create(Iterable<GetDayOfMonthOverload> overloads) {
        return new GetDayOfMonthFunction(ImmutableSet.copyOf(overloads));
    }

    private GetDayOfMonthFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetDayOfMonthOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_DAY_OF_MONTH((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_month", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getDayOfMonth() - 1L)),
        TIMESTAMP_TO_DAY_OF_MONTH_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_month_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getDayOfMonth() - 1L));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetDayOfMonthOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

