/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.time.DayOfWeek;
import java.util.Arrays;

public final class GetDayOfWeekFunction
extends CelStandardFunction {
    private static final GetDayOfWeekFunction ALL_OVERLOADS = GetDayOfWeekFunction.create(GetDayOfWeekOverload.values());

    public static GetDayOfWeekFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetDayOfWeekFunction create(GetDayOfWeekOverload ... overloads) {
        return GetDayOfWeekFunction.create(Arrays.asList(overloads));
    }

    public static GetDayOfWeekFunction create(Iterable<GetDayOfWeekOverload> overloads) {
        return new GetDayOfWeekFunction(ImmutableSet.copyOf(overloads));
    }

    private GetDayOfWeekFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetDayOfWeekOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_DAY_OF_WEEK((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_week", Timestamp.class, ts -> {
            DayOfWeek dayOfWeek = DateTimeHelpers.newLocalDateTime(ts, "UTC").getDayOfWeek();
            return (long)dayOfWeek.getValue() % 7L;
        })),
        TIMESTAMP_TO_DAY_OF_WEEK_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_week_with_tz", Timestamp.class, String.class, (ts, tz) -> {
            DayOfWeek dayOfWeek = DateTimeHelpers.newLocalDateTime(ts, tz).getDayOfWeek();
            return (long)dayOfWeek.getValue() % 7L;
        }));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetDayOfWeekOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

