/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetDayOfYearFunction
extends CelStandardFunction {
    private static final GetDayOfYearFunction ALL_OVERLOADS = GetDayOfYearFunction.create(GetDayOfYearOverload.values());

    public static GetDayOfYearFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetDayOfYearFunction create(GetDayOfYearOverload ... overloads) {
        return GetDayOfYearFunction.create(Arrays.asList(overloads));
    }

    public static GetDayOfYearFunction create(Iterable<GetDayOfYearOverload> overloads) {
        return new GetDayOfYearFunction(ImmutableSet.copyOf(overloads));
    }

    private GetDayOfYearFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetDayOfYearOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_DAY_OF_YEAR((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_year", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getDayOfYear() - 1L)),
        TIMESTAMP_TO_DAY_OF_YEAR_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_day_of_year_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getDayOfYear() - 1L));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetDayOfYearOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

