/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetHoursFunction
extends CelStandardFunction {
    private static final GetHoursFunction ALL_OVERLOADS = GetHoursFunction.create(GetHoursOverload.values());

    public static GetHoursFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetHoursFunction create(GetHoursOverload ... overloads) {
        return GetHoursFunction.create(Arrays.asList(overloads));
    }

    public static GetHoursFunction create(Iterable<GetHoursOverload> overloads) {
        return new GetHoursFunction(ImmutableSet.copyOf(overloads));
    }

    private GetHoursFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetHoursOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_HOURS((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_hours", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getHour())),
        TIMESTAMP_TO_HOURS_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_hours_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getHour())),
        DURATION_TO_HOURS((celOptions, runtimeEquality) -> CelFunctionBinding.from("duration_to_hours", Duration.class, ProtoTimeUtils::toHours));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetHoursOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

