/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetMonthFunction
extends CelStandardFunction {
    private static final GetMonthFunction ALL_OVERLOADS = GetMonthFunction.create(GetMonthOverload.values());

    public static GetMonthFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetMonthFunction create(GetMonthOverload ... overloads) {
        return GetMonthFunction.create(Arrays.asList(overloads));
    }

    public static GetMonthFunction create(Iterable<GetMonthOverload> overloads) {
        return new GetMonthFunction(ImmutableSet.copyOf(overloads));
    }

    private GetMonthFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetMonthOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_MONTH((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_month", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getMonthValue() - 1L)),
        TIMESTAMP_TO_MONTH_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_month_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getMonthValue() - 1L));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetMonthOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

