/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class IndexOperator
extends CelStandardFunction {
    private static final IndexOperator ALL_OVERLOADS = IndexOperator.create(IndexOverload.values());

    public static IndexOperator create() {
        return ALL_OVERLOADS;
    }

    public static IndexOperator create(IndexOverload ... overloads) {
        return IndexOperator.create(Arrays.asList(overloads));
    }

    public static IndexOperator create(Iterable<IndexOverload> overloads) {
        return new IndexOperator(ImmutableSet.copyOf(overloads));
    }

    private IndexOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum IndexOverload implements CelStandardOverload
    {
        INDEX_LIST((celOptions, runtimeEquality) -> CelFunctionBinding.from("index_list", List.class, Number.class, RuntimeHelpers::indexList)),
        INDEX_MAP((celOptions, runtimeEquality) -> CelFunctionBinding.from("index_map", Map.class, Object.class, runtimeEquality::indexMap));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private IndexOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

