/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.internal.ComparisonFunctions;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class LessOperator
extends CelStandardFunction {
    private static final LessOperator ALL_OVERLOADS = LessOperator.create(LessOverload.values());

    public static LessOperator create() {
        return ALL_OVERLOADS;
    }

    public static LessOperator create(LessOverload ... overloads) {
        return LessOperator.create(Arrays.asList(overloads));
    }

    public static LessOperator create(Iterable<LessOverload> overloads) {
        return new LessOperator(ImmutableSet.copyOf(overloads));
    }

    private LessOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum LessOverload implements CelStandardOverload
    {
        LESS_BOOL((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_bool", Boolean.class, Boolean.class, (x, y) -> x == false && y != false)),
        LESS_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_int64", Long.class, Long.class, (x, y) -> x < y)),
        LESS_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("less_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y) < 0);
            }
            return CelFunctionBinding.from("less_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y, celOptions) < 0);
        }),
        LESS_BYTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_bytes", ByteString.class, ByteString.class, (x, y) -> ByteString.unsignedLexicographicalComparator().compare((ByteString)x, (ByteString)y) < 0)),
        LESS_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_double", Double.class, Double.class, (x, y) -> x < y)),
        LESS_DOUBLE_UINT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_double_uint64", Double.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareDoubleUint(x, y) == -1)),
        LESS_INT64_UINT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_int64_uint64", Long.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareIntUint(x, y) == -1)),
        LESS_UINT64_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_uint64_int64", UnsignedLong.class, Long.class, (x, y) -> ComparisonFunctions.compareUintInt(x, y) == -1)),
        LESS_INT64_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_int64_double", Long.class, Double.class, (x, y) -> ComparisonFunctions.compareIntDouble(x, y) == -1)),
        LESS_DOUBLE_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_double_int64", Double.class, Long.class, (x, y) -> ComparisonFunctions.compareDoubleInt(x, y) == -1)),
        LESS_UINT64_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_uint64_double", UnsignedLong.class, Double.class, (x, y) -> ComparisonFunctions.compareUintDouble(x, y) == -1)),
        LESS_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_duration", Duration.class, Duration.class, (x, y) -> ProtoTimeUtils.compare(x, y) < 0)),
        LESS_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_string", String.class, String.class, (x, y) -> x.compareTo((String)y) < 0)),
        LESS_TIMESTAMP((celOptions, runtimeEquality) -> CelFunctionBinding.from("less_timestamp", Timestamp.class, Timestamp.class, (x, y) -> ProtoTimeUtils.compare(x, y) < 0));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private LessOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

