/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class MatchesFunction
extends CelStandardFunction {
    private static final MatchesFunction ALL_OVERLOADS = MatchesFunction.create(MatchesOverload.values());

    public static MatchesFunction create() {
        return ALL_OVERLOADS;
    }

    public static MatchesFunction create(MatchesOverload ... overloads) {
        return MatchesFunction.create(Arrays.asList(overloads));
    }

    public static MatchesFunction create(Iterable<MatchesOverload> overloads) {
        return new MatchesFunction(ImmutableSet.copyOf(overloads));
    }

    private MatchesFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum MatchesOverload implements CelStandardOverload
    {
        MATCHES((celOptions, runtimeEquality) -> CelFunctionBinding.from("matches", String.class, String.class, (string, regexp) -> {
            try {
                return RuntimeHelpers.matches(string, regexp, celOptions);
            }
            catch (RuntimeException e) {
                throw new CelRuntimeException(e, CelErrorCode.INVALID_ARGUMENT);
            }
        })),
        MATCHES_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("matches_string", String.class, String.class, (string, regexp) -> {
            try {
                return RuntimeHelpers.matches(string, regexp, celOptions);
            }
            catch (RuntimeException e) {
                throw new CelRuntimeException(e, CelErrorCode.INVALID_ARGUMENT);
            }
        }));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private MatchesOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

