/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class NotEqualsOperator
extends CelStandardFunction {
    private static final NotEqualsOperator ALL_OVERLOADS = NotEqualsOperator.create(NotEqualsOverload.values());

    public static NotEqualsOperator create() {
        return ALL_OVERLOADS;
    }

    public static NotEqualsOperator create(NotEqualsOverload ... overloads) {
        return NotEqualsOperator.create(Arrays.asList(overloads));
    }

    public static NotEqualsOperator create(Iterable<NotEqualsOverload> overloads) {
        return new NotEqualsOperator(ImmutableSet.copyOf(overloads));
    }

    private NotEqualsOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum NotEqualsOverload implements CelStandardOverload
    {
        NOT_EQUALS((celOptions, runtimeEquality) -> CelFunctionBinding.from("not_equals", Object.class, Object.class, (x, y) -> !runtimeEquality.objectEquals(x, y)));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private NotEqualsOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

