/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class StringFunction
extends CelStandardFunction {
    private static final StringFunction ALL_OVERLOADS = StringFunction.create(StringOverload.values());

    public static StringFunction create() {
        return ALL_OVERLOADS;
    }

    public static StringFunction create(StringOverload ... overloads) {
        return StringFunction.create(Arrays.asList(overloads));
    }

    public static StringFunction create(Iterable<StringOverload> overloads) {
        return new StringFunction(ImmutableSet.copyOf(overloads));
    }

    private StringFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum StringOverload implements CelStandardOverload
    {
        STRING_TO_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_to_string", String.class, x -> x)),
        INT64_TO_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("int64_to_string", Long.class, Object::toString)),
        DOUBLE_TO_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("double_to_string", Double.class, Object::toString)),
        BOOL_TO_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("bool_to_string", Boolean.class, Object::toString)),
        BYTES_TO_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("bytes_to_string", ByteString.class, byteStr -> {
            if (!byteStr.isValidUtf8()) {
                throw new CelRuntimeException(new IllegalArgumentException("invalid UTF-8 in bytes, cannot convert to string"), CelErrorCode.BAD_FORMAT);
            }
            return byteStr.toStringUtf8();
        })),
        TIMESTAMP_TO_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_string", Timestamp.class, ProtoTimeUtils::toString)),
        DURATION_TO_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("duration_to_string", Duration.class, ProtoTimeUtils::toString)),
        UINT64_TO_STRING((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("uint64_to_string", UnsignedLong.class, UnsignedLong::toString);
            }
            return CelFunctionBinding.from("uint64_to_string", Long.class, UnsignedLongs::toString);
        });

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private StringOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

