/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.text.ParseException;
import java.util.Arrays;

public final class TimestampFunction
extends CelStandardFunction {
    private static final TimestampFunction ALL_OVERLOADS = TimestampFunction.create(TimestampOverload.values());

    public static TimestampFunction create() {
        return ALL_OVERLOADS;
    }

    public static TimestampFunction create(TimestampOverload ... overloads) {
        return TimestampFunction.create(Arrays.asList(overloads));
    }

    public static TimestampFunction create(Iterable<TimestampOverload> overloads) {
        return new TimestampFunction(ImmutableSet.copyOf(overloads));
    }

    private TimestampFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum TimestampOverload implements CelStandardOverload
    {
        STRING_TO_TIMESTAMP((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_to_timestamp", String.class, ts -> {
            try {
                return ProtoTimeUtils.parse(ts);
            }
            catch (ParseException e) {
                throw new CelRuntimeException(e, CelErrorCode.BAD_FORMAT);
            }
        })),
        TIMESTAMP_TO_TIMESTAMP((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_timestamp", Timestamp.class, x -> x)),
        INT64_TO_TIMESTAMP((celOptions, runtimeEquality) -> CelFunctionBinding.from("int64_to_timestamp", Long.class, ProtoTimeUtils::fromSecondsToTimestamp));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private TimestampOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

