/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.validator.validators;

import com.google.common.base.Preconditions;
import dev.cel.bundle.Cel;
import dev.cel.common.navigation.CelNavigableAst;
import dev.cel.validator.CelAstValidator;

public final class AstDepthLimitValidator
implements CelAstValidator {
    static final int DEFAULT_DEPTH_LIMIT = 50;
    public static final AstDepthLimitValidator DEFAULT = AstDepthLimitValidator.newInstance(50);
    private final int maxDepth;

    public static AstDepthLimitValidator newInstance(int maxDepth) {
        Preconditions.checkArgument(maxDepth > 0);
        return new AstDepthLimitValidator(maxDepth);
    }

    @Override
    public void validate(CelNavigableAst navigableAst, Cel cel, CelAstValidator.IssuesFactory issuesFactory) {
        if (navigableAst.getRoot().height() >= this.maxDepth) {
            issuesFactory.addError(navigableAst.getRoot().id(), String.format("AST's depth exceeds the configured limit: %s.", this.maxDepth));
        }
    }

    private AstDepthLimitValidator(int maxDepth) {
        this.maxDepth = maxDepth;
    }
}

