/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.validator.validators;

import com.google.common.collect.ImmutableList;
import dev.cel.bundle.Cel;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.navigation.CelNavigableAst;
import dev.cel.validator.CelAstValidator;
import java.util.AbstractCollection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class RegexLiteralValidator
implements CelAstValidator {
    public static final RegexLiteralValidator INSTANCE = new RegexLiteralValidator();

    @Override
    public void validate(CelNavigableAst navigableAst, Cel cel, CelAstValidator.IssuesFactory issuesFactory) {
        navigableAst.getRoot().allNodes().filter(node -> ((CelExpr)node.expr()).callOrDefault().function().equals("matches")).filter(node -> ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2)).contains(((AbstractCollection)((Object)((CelExpr)node.expr()).call().args())).size())).map(node -> ((CelExpr)node.expr()).call()).forEach(matchesCallExpr -> {
            CelExpr regexArg;
            CelExpr celExpr = regexArg = matchesCallExpr.target().isPresent() ? (CelExpr)matchesCallExpr.args().get(0) : (CelExpr)matchesCallExpr.args().get(1);
            if (!regexArg.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
                return;
            }
            String regexPattern = regexArg.constant().stringValue();
            try {
                Pattern.compile(regexPattern);
            }
            catch (PatternSyntaxException e) {
                issuesFactory.addError(regexArg.id(), "Regex validation failed. Reason: " + e.getMessage());
            }
        });
    }

    private RegexLiteralValidator() {
    }
}

