/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import com.squareup.wire.schema.internal.parser.OptionElement;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSimpleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.entur.schema2proto.generateproto.Schema2ProtoConfiguration;
import no.entur.schema2proto.generateproto.SchemaParser;
import no.entur.schema2proto.generateproto.TypeRegistry;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationRuleFactory {
    public static final String PROTOVALIDATE_FIELD_NAME = "buf.validate.field";
    private static final String RULE_STRING_PATTERN = "string.pattern";
    private final SchemaParser schemaParser;
    private Schema2ProtoConfiguration configuration;
    private final Set<String> basicTypes;
    private Map<String, List<OptionElement>> defaultValidationRulesForBasicTypes;
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationRuleFactory.class);

    public ValidationRuleFactory(Schema2ProtoConfiguration configuration, SchemaParser schemaParser) {
        this.configuration = configuration;
        this.schemaParser = schemaParser;
        this.basicTypes = TypeRegistry.getBasicTypes();
        this.defaultValidationRulesForBasicTypes = new HashMap<String, List<OptionElement>>();
        this.defaultValidationRulesForBasicTypes.putAll(this.getValidationRuleForBasicTypes());
    }

    public List<OptionElement> getValidationRule(XSParticle parentParticle) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        return validationRules;
    }

    public List<OptionElement> getValidationRule(XSAttributeDecl attributeDecl) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        if (this.configuration.includeValidationRules) {
            // empty if block
        }
        return validationRules;
    }

    public List<OptionElement> getValidationRule(XSSimpleType simpleType2) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        if (this.configuration.includeValidationRules) {
            String typeName = simpleType2.getName();
            if (typeName != null && this.basicTypes.contains(typeName)) {
                validationRules.addAll(this.getValidationRuleForBasicType(typeName));
            } else if (simpleType2.isRestriction()) {
                XSRestrictionSimpleType restriction = simpleType2.asRestriction();
                Collection<? extends XSFacet> declaredFacets = restriction.getDeclaredFacets();
                String baseType = this.schemaParser.findFieldType(simpleType2);
                if ("string".equals(baseType)) {
                    this.addOptionForString(validationRules, declaredFacets);
                }
            } else {
                LOGGER.warn("During validation rules extraction; Found anonymous simpleType that is not a restriction: {}", (Object)simpleType2);
            }
        }
        return validationRules;
    }

    private void addOptionForString(List<OptionElement> validationRules, Collection<? extends XSFacet> declaredFacets) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        block10: for (XSFacet xSFacet : declaredFacets) {
            switch (xSFacet.getName()) {
                case "pattern": {
                    parameters.put("pattern", StringUtils.replace(xSFacet.getValue().value, "\\", "\\\\"));
                    continue block10;
                }
                case "minLength": {
                    parameters.put("min_len", Integer.parseInt(xSFacet.getValue().value));
                    continue block10;
                }
                case "maxLength": {
                    parameters.put("max_len", Integer.parseInt(xSFacet.getValue().value));
                    continue block10;
                }
            }
            LOGGER.warn("Unhandled facet {}", (Object)xSFacet.getName());
        }
        OptionElement option = new OptionElement("string", OptionElement.Kind.MAP, parameters, false);
        OptionElement optionElement = new OptionElement(PROTOVALIDATE_FIELD_NAME, OptionElement.Kind.OPTION, option, true);
        validationRules.add(optionElement);
    }

    private List<OptionElement> getValidationRuleForBasicType(String name) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        List<OptionElement> validationRulesForType = this.defaultValidationRulesForBasicTypes.get(name);
        if (validationRulesForType != null) {
            validationRules.addAll(validationRulesForType);
        }
        return validationRules;
    }

    public Map<String, List<OptionElement>> getValidationRuleForBasicTypes() {
        HashMap<String, List<OptionElement>> typeToValidationRule = new HashMap<String, List<OptionElement>>();
        typeToValidationRule.put("gYearMonth", this.createOptionElements(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{4}-[0-9]{2}"));
        typeToValidationRule.put("gYear", this.createOptionElements(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{4}"));
        typeToValidationRule.put("gMonthDay", this.createOptionElements(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{4}-[0-9]{2}"));
        typeToValidationRule.put("gDay", this.createOptionElements(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{2}"));
        typeToValidationRule.put("gMonth", this.createOptionElements(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{2}"));
        typeToValidationRule.put("language", this.createOptionElements(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*"));
        typeToValidationRule.put("nonPositiveInteger", this.createOptionElements("sint32.lte", OptionElement.Kind.NUMBER, 0));
        typeToValidationRule.put("negativeInteger", this.createOptionElements("sint32.lt", OptionElement.Kind.NUMBER, 0));
        typeToValidationRule.put("nonNegativeInteger", this.createOptionElements("uint32.gte", OptionElement.Kind.NUMBER, 0));
        typeToValidationRule.put("positiveInteger", this.createOptionElements("uint32.gt", OptionElement.Kind.NUMBER, 0));
        return typeToValidationRule;
    }

    private List<OptionElement> createOptionElements(String name, OptionElement.Kind kind, Object value) {
        ArrayList<OptionElement> elements = new ArrayList<OptionElement>();
        OptionElement option = new OptionElement(name, kind, value, false);
        elements.add(new OptionElement(PROTOVALIDATE_FIELD_NAME, OptionElement.Kind.OPTION, option, true));
        return elements;
    }
}

