/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.AmbiguousOptionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.Util;

public class DefaultParser
implements CommandLineParser {
    protected CommandLine cmd;
    protected Options options;
    protected boolean stopAtNonOption;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List expectedOpts;
    private final boolean allowPartialMatching;
    private final Boolean stripLeadingAndTrailingQuotes;
    private final Consumer<Option> deprecatedHandler;

    public static Builder builder() {
        return new Builder();
    }

    static int indexOfEqual(String token) {
        return token.indexOf(61);
    }

    public DefaultParser() {
        this.allowPartialMatching = true;
        this.stripLeadingAndTrailingQuotes = null;
        this.deprecatedHandler = CommandLine.Builder.DEPRECATED_HANDLER;
    }

    public DefaultParser(boolean allowPartialMatching) {
        this.allowPartialMatching = allowPartialMatching;
        this.stripLeadingAndTrailingQuotes = null;
        this.deprecatedHandler = CommandLine.Builder.DEPRECATED_HANDLER;
    }

    private DefaultParser(boolean allowPartialMatching, Boolean stripLeadingAndTrailingQuotes, Consumer<Option> deprecatedHandler) {
        this.allowPartialMatching = allowPartialMatching;
        this.stripLeadingAndTrailingQuotes = stripLeadingAndTrailingQuotes;
        this.deprecatedHandler = deprecatedHandler;
    }

    private void checkRequiredArgs() throws ParseException {
        if (this.currentOption != null && this.currentOption.requiresArg()) {
            if (this.isJavaProperty(this.currentOption.getKey()) && this.currentOption.getValuesList().size() == 1) {
                return;
            }
            throw new MissingArgumentException(this.currentOption);
        }
    }

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private String getLongPrefix(String token) {
        String t2 = Util.stripLeadingHyphens(token);
        String opt = null;
        for (int i = t2.length() - 2; i > 1; --i) {
            String prefix = t2.substring(0, i);
            if (!this.options.hasLongOption(prefix)) continue;
            opt = prefix;
            break;
        }
        return opt;
    }

    private List<String> getMatchingLongOptions(String token) {
        if (this.allowPartialMatching) {
            return this.options.getMatchingOptions(token);
        }
        ArrayList<String> matches = new ArrayList<String>(1);
        if (this.options.hasLongOption(token)) {
            matches.add(this.options.getOption(token).getLongOpt());
        }
        return matches;
    }

    protected void handleConcatenatedOptions(String token) throws ParseException {
        for (int i = 1; i < token.length(); ++i) {
            String ch = String.valueOf(token.charAt(i));
            if (!this.options.hasOption(ch)) {
                this.handleUnknownToken(this.stopAtNonOption && i > 1 ? token.substring(i) : token);
                break;
            }
            this.handleOption(this.options.getOption(ch));
            if (this.currentOption == null || token.length() == i + 1) continue;
            this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(token.substring(i + 1)));
            break;
        }
    }

    private void handleLongOption(String token) throws ParseException {
        if (DefaultParser.indexOfEqual(token) == -1) {
            this.handleLongOptionWithoutEqual(token);
        } else {
            this.handleLongOptionWithEqual(token);
        }
    }

    private void handleLongOptionWithEqual(String token) throws ParseException {
        int pos = DefaultParser.indexOfEqual(token);
        String value = token.substring(pos + 1);
        String opt = token.substring(0, pos);
        List<String> matchingOpts = this.getMatchingLongOptions(opt);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(opt)) {
                throw new AmbiguousOptionException(opt, matchingOpts);
            }
            String key = this.options.hasLongOption(opt) ? opt : matchingOpts.get(0);
            Option option = this.options.getOption(key);
            if (option.acceptsArg()) {
                this.handleOption(option);
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(value));
                this.currentOption = null;
            } else {
                this.handleUnknownToken(this.currentToken);
            }
        }
    }

    private void handleLongOptionWithoutEqual(String token) throws ParseException {
        List<String> matchingOpts = this.getMatchingLongOptions(token);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(token)) {
                throw new AmbiguousOptionException(token, matchingOpts);
            }
            String key = this.options.hasLongOption(token) ? token : matchingOpts.get(0);
            this.handleOption(this.options.getOption(key));
        }
    }

    private void handleOption(Option option) throws ParseException {
        this.checkRequiredArgs();
        Option copy = (Option)option.clone();
        this.updateRequiredOptions(copy);
        this.cmd.addOption(copy);
        this.currentOption = copy.hasArg() ? copy : null;
    }

    private void handleProperties(Properties properties) throws ParseException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String option = e.nextElement().toString();
            Option opt = this.options.getOption(option);
            if (opt == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", option);
            }
            OptionGroup group2 = this.options.getOptionGroup(opt);
            boolean bl = selected = group2 != null && group2.isSelected();
            if (this.cmd.hasOption(option) || selected) continue;
            String value = properties.getProperty(option);
            if (opt.hasArg()) {
                if (Util.isEmpty(opt.getValues())) {
                    opt.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(value));
                }
            } else if (!"yes".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value)) continue;
            this.handleOption(opt);
            this.currentOption = null;
        }
    }

    private void handleShortAndLongOption(String hyphenToken) throws ParseException {
        String token = Util.stripLeadingHyphens(hyphenToken);
        int pos = DefaultParser.indexOfEqual(token);
        if (token.length() == 1) {
            if (this.options.hasShortOption(token)) {
                this.handleOption(this.options.getOption(token));
            } else {
                this.handleUnknownToken(hyphenToken);
            }
        } else if (pos == -1) {
            if (this.options.hasShortOption(token)) {
                this.handleOption(this.options.getOption(token));
            } else if (!this.getMatchingLongOptions(token).isEmpty()) {
                this.handleLongOptionWithoutEqual(hyphenToken);
            } else {
                String opt = this.getLongPrefix(token);
                if (opt != null && this.options.getOption(opt).acceptsArg()) {
                    this.handleOption(this.options.getOption(opt));
                    this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(token.substring(opt.length())));
                    this.currentOption = null;
                } else if (this.isJavaProperty(token)) {
                    this.handleOption(this.options.getOption(token.substring(0, 1)));
                    this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOff(token.substring(1)));
                    this.currentOption = null;
                } else {
                    this.handleConcatenatedOptions(hyphenToken);
                }
            }
        } else {
            String opt = token.substring(0, pos);
            String value = token.substring(pos + 1);
            if (opt.length() == 1) {
                Option option = this.options.getOption(opt);
                if (option != null && option.acceptsArg()) {
                    this.handleOption(option);
                    this.currentOption.processValue(value);
                    this.currentOption = null;
                } else {
                    this.handleUnknownToken(hyphenToken);
                }
            } else if (this.isJavaProperty(opt)) {
                this.handleOption(this.options.getOption(opt.substring(0, 1)));
                this.currentOption.processValue(opt.substring(1));
                this.currentOption.processValue(value);
                this.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(hyphenToken);
            }
        }
    }

    private void handleToken(String token) throws ParseException {
        if (token != null) {
            this.currentToken = token;
            if (this.skipParsing) {
                this.cmd.addArg(token);
            } else if ("--".equals(token)) {
                this.skipParsing = true;
            } else if (this.currentOption != null && this.currentOption.acceptsArg() && this.isArgument(token)) {
                this.currentOption.processValue(this.stripLeadingAndTrailingQuotesDefaultOn(token));
            } else if (token.startsWith("--")) {
                this.handleLongOption(token);
            } else if (token.startsWith("-") && !"-".equals(token)) {
                this.handleShortAndLongOption(token);
            } else {
                this.handleUnknownToken(token);
            }
            if (this.currentOption != null && !this.currentOption.acceptsArg()) {
                this.currentOption = null;
            }
        }
    }

    private void handleUnknownToken(String token) throws ParseException {
        if (token.startsWith("-") && token.length() > 1 && !this.stopAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + token, token);
        }
        this.cmd.addArg(token);
        if (this.stopAtNonOption) {
            this.skipParsing = true;
        }
    }

    private boolean isArgument(String token) {
        return !this.isOption(token) || this.isNegativeNumber(token);
    }

    private boolean isJavaProperty(String token) {
        String opt = token.isEmpty() ? null : token.substring(0, 1);
        Option option = this.options.getOption(opt);
        return option != null && (option.getArgs() >= 2 || option.getArgs() == -2);
    }

    private boolean isLongOption(String token) {
        String t2;
        if (token == null || !token.startsWith("-") || token.length() == 1) {
            return false;
        }
        int pos = DefaultParser.indexOfEqual(token);
        String string = t2 = pos == -1 ? token : token.substring(0, pos);
        if (!this.getMatchingLongOptions(t2).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token) != null && !token.startsWith("--");
    }

    private boolean isNegativeNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOption(String token) {
        return this.isLongOption(token) || this.isShortOption(token);
    }

    private boolean isShortOption(String token) {
        String optName;
        if (token == null || !token.startsWith("-") || token.length() == 1) {
            return false;
        }
        int pos = DefaultParser.indexOfEqual(token);
        String string = optName = pos == -1 ? token.substring(1) : token.substring(1, pos);
        if (this.options.hasShortOption(optName)) {
            return true;
        }
        return !optName.isEmpty() && this.options.hasShortOption(String.valueOf(optName.charAt(0)));
    }

    @Override
    public CommandLine parse(Options options, String[] arguments) throws ParseException {
        return this.parse(options, arguments, null);
    }

    @Override
    public CommandLine parse(Options options, String[] arguments, boolean stopAtNonOption) throws ParseException {
        return this.parse(options, arguments, null, stopAtNonOption);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties) throws ParseException {
        return this.parse(options, arguments, properties, false);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties, boolean stopAtNonOption) throws ParseException {
        this.options = options;
        this.stopAtNonOption = stopAtNonOption;
        this.skipParsing = false;
        this.currentOption = null;
        this.expectedOpts = new ArrayList(options.getRequiredOptions());
        for (OptionGroup group2 : options.getOptionGroups()) {
            group2.setSelected(null);
        }
        this.cmd = CommandLine.builder().setDeprecatedHandler(this.deprecatedHandler).build();
        if (arguments != null) {
            for (String argument : arguments) {
                this.handleToken(argument);
            }
        }
        this.checkRequiredArgs();
        this.handleProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    private String stripLeadingAndTrailingQuotesDefaultOff(String token) {
        if (this.stripLeadingAndTrailingQuotes != null && this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(token);
        }
        return token;
    }

    private String stripLeadingAndTrailingQuotesDefaultOn(String token) {
        if (this.stripLeadingAndTrailingQuotes == null || this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(token);
        }
        return token;
    }

    private void updateRequiredOptions(Option option) throws AlreadySelectedException {
        if (option.isRequired()) {
            this.expectedOpts.remove(option.getKey());
        }
        if (this.options.getOptionGroup(option) != null) {
            OptionGroup group2 = this.options.getOptionGroup(option);
            if (group2.isRequired()) {
                this.expectedOpts.remove(group2);
            }
            group2.setSelected(option);
        }
    }

    public static final class Builder {
        private boolean allowPartialMatching = true;
        private Consumer<Option> deprecatedHandler = CommandLine.Builder.DEPRECATED_HANDLER;
        private Boolean stripLeadingAndTrailingQuotes;

        private Builder() {
        }

        public DefaultParser build() {
            return new DefaultParser(this.allowPartialMatching, this.stripLeadingAndTrailingQuotes, this.deprecatedHandler);
        }

        public Builder setAllowPartialMatching(boolean allowPartialMatching) {
            this.allowPartialMatching = allowPartialMatching;
            return this;
        }

        public Builder setDeprecatedHandler(Consumer<Option> deprecatedHandler) {
            this.deprecatedHandler = deprecatedHandler;
            return this;
        }

        public Builder setStripLeadingAndTrailingQuotes(Boolean stripLeadingAndTrailingQuotes) {
            this.stripLeadingAndTrailingQuotes = stripLeadingAndTrailingQuotes;
            return this;
        }
    }
}

