/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceHelper {
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceHelper.class);
    private static Map<String, String> namespaceToPackageNames = new HashMap<String, String>();

    public static String xmlNamespaceToProtoPackage(String namespace, String forceProtoPackage) {
        String packageName;
        if (forceProtoPackage != null) {
            packageName = forceProtoPackage.toLowerCase();
        } else if (StringUtils.trimToNull(namespace) == null) {
            packageName = null;
        } else {
            packageName = namespaceToPackageNames.get(namespace);
            if (packageName == null) {
                try {
                    packageName = NamespaceHelper.convertAsUrl(namespace);
                }
                catch (MalformedURLException e) {
                    packageName = NamespaceHelper.convertAsBrokenUrl(namespace);
                    LOGGER.warn("Unable to create decent package name from XML namespace {}, falling back to {} ", namespace, packageName, e);
                }
                packageName = StringUtils.trimToNull(packageName).toLowerCase();
                namespaceToPackageNames.put(namespace, packageName);
            }
        }
        return packageName;
    }

    @NotNull
    private static String convertAsBrokenUrl(String namespace) {
        if (namespace.contains("://")) {
            namespace = namespace.substring(namespace.indexOf("://") + 3);
        }
        if ((namespace = namespace.replace("/", ".").replace("-", ".")).startsWith(".")) {
            namespace = namespace.substring(1);
        }
        if (namespace.endsWith(".")) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        return namespace;
    }

    private static String convertAsUrl(String namespace) throws MalformedURLException {
        String[] pathparts;
        URL url = new URL(namespace);
        String host = url.getHost();
        String[] hostparts = StringUtils.split(host, ".");
        StringBuilder packageBuilder = new StringBuilder();
        for (int i = hostparts.length; i > 0; --i) {
            String hostpart = hostparts[i - 1];
            hostpart = NamespaceHelper.escapePart(hostpart);
            packageBuilder.append(hostpart);
            packageBuilder.append(".");
        }
        String path = url.getPath();
        for (String pathpart : pathparts = StringUtils.split(path, "/")) {
            pathpart = NamespaceHelper.escapePart(pathpart);
            packageBuilder.append(pathpart);
            packageBuilder.append(".");
        }
        return StringUtils.removeEnd(packageBuilder.toString(), ".");
    }

    private static String escapePart(String pathpart) {
        String escapedPart = StringUtils.replaceEach(pathpart, new String[]{".", "-", ":"}, new String[]{"_", "_", "_"});
        if (Character.isDigit(escapedPart.charAt(0))) {
            escapedPart = "_" + escapedPart;
        }
        return escapedPart;
    }

    public static String xmlNamespaceToProtoFieldPackagename(String namespace, String forceProtoPackage) {
        String packageName = null;
        packageName = XML_SCHEMA_NAMESPACE.equals(namespace) ? null : (forceProtoPackage != null ? forceProtoPackage : NamespaceHelper.xmlNamespaceToProtoPackage(namespace, forceProtoPackage));
        if (packageName != null) {
            packageName = StringUtils.lowerCase(packageName);
        }
        return packageName;
    }
}

