/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.entur.schema2proto.InvalidConfigurationException;
import no.entur.schema2proto.generateproto.BackwardsCompatibilityCheckException;
import no.entur.schema2proto.generateproto.ConversionException;
import no.entur.schema2proto.generateproto.InvalidXSDException;
import no.entur.schema2proto.generateproto.LocalType;
import no.entur.schema2proto.generateproto.Schema2ProtoConfiguration;
import no.entur.schema2proto.generateproto.TypeAndNameMapper;
import no.entur.schema2proto.generateproto.TypeRegistry;
import no.entur.schema2proto.generateproto.compatibility.ProtolockBackwardsCompatibilityChecker;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoSerializer {
    public static final String UNDERSCORE = "_";
    public static final String VALIDATION_PROTO_IMPORT = "validate/validate.proto";
    public static final String XSDOPTIONS_PROTO_IMPORT = "xsd/xsd.proto";
    public static final String DASH = "-";
    public static final String[] PACKABLE_SCALAR_TYPES = new String[]{"int32", "int64", "uint32", "uint64", "sint32", "sint64", "bool"};
    public static final Set<String> PACKABLE_SCALAR_TYPES_SET = new HashSet<String>(Arrays.asList(PACKABLE_SCALAR_TYPES));
    private Schema2ProtoConfiguration configuration;
    private TypeAndNameMapper typeAndFieldNameMapper;
    private Set<String> basicTypes = new HashSet<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoSerializer.class);
    private ProtolockBackwardsCompatibilityChecker backwardsCompatibilityChecker;

    public ProtoSerializer(Schema2ProtoConfiguration configuration, TypeAndNameMapper marshaller) throws InvalidConfigurationException {
        this.configuration = configuration;
        this.typeAndFieldNameMapper = marshaller;
        this.basicTypes.addAll(TypeRegistry.getBasicTypes());
        if (configuration.outputDirectory != null) {
            if (!configuration.outputDirectory.mkdirs() && !configuration.outputDirectory.exists()) {
                throw new InvalidConfigurationException("Could not create outputDirectory", null);
            }
            LOGGER.info("Writing proto files to {}", (Object)configuration.outputDirectory.getAbsolutePath());
        }
        this.backwardsCompatibilityChecker = new ProtolockBackwardsCompatibilityChecker();
        if (configuration.protoLockFile != null) {
            try {
                this.backwardsCompatibilityChecker.init(configuration.protoLockFile);
            }
            catch (FileNotFoundException e) {
                throw new InvalidConfigurationException("Could not find proto.lock file, check configuration");
            }
        }
    }

    public void serialize(Map<String, ProtoFile> packageToProtoFileMap, List<LocalType> localTypes) throws InvalidXSDException, IOException {
        this.replaceGeneratedTypePlaceholder(packageToProtoFileMap, "GeneratedTypePlaceholder", "Type");
        this.sortTypesInProtofile(packageToProtoFileMap);
        this.moveReusedLocalTypesToGlobal(packageToProtoFileMap, localTypes);
        this.removeUnwantedFields(packageToProtoFileMap);
        this.uppercaseMessageNames(packageToProtoFileMap);
        this.addConfigurationSpecifiedOptions(packageToProtoFileMap);
        this.computeFilenames(packageToProtoFileMap);
        this.translateTypes(packageToProtoFileMap);
        this.replaceTypes(packageToProtoFileMap);
        this.computeLocalImports(packageToProtoFileMap);
        this.addConfigurationSpecifiedImports(packageToProtoFileMap);
        this.resolveRecursiveImports(packageToProtoFileMap);
        this.handleFieldNameCaseInsensitives(packageToProtoFileMap);
        this.translateFieldNames(packageToProtoFileMap);
        this.moveFieldPackageNameToFieldTypeName(packageToProtoFileMap);
        this.addLeadingPeriodToElementType(packageToProtoFileMap);
        this.underscoreFieldNames(packageToProtoFileMap);
        this.escapeReservedJavaKeywords(packageToProtoFileMap);
        this.updateEnumValues(packageToProtoFileMap);
        this.addPackedOptionToRepeatedFields(packageToProtoFileMap, true);
        boolean possibleIncompatibilitiesDetected = false;
        if (this.configuration.protoLockFile != null) {
            possibleIncompatibilitiesDetected = this.resolveBackwardIncompatibilities(packageToProtoFileMap);
        }
        this.sortFieldsByTag(packageToProtoFileMap);
        ArrayList<File> writtenProtoFiles = new ArrayList<File>();
        if (this.configuration.outputFilename != null) {
            if (packageToProtoFileMap.size() > 1) {
                LOGGER.error("Source schema contains multiple namespaces but specifies a single output file");
                throw new InvalidXSDException();
            }
            ProtoFile protoFile = packageToProtoFileMap.entrySet().iterator().next().getValue();
            File destFolder = this.createPackageFolderStructure(this.configuration.outputDirectory, protoFile.packageName());
            File outputFile = new File(destFolder, this.configuration.outputFilename.toLowerCase());
            try (FileWriter writer = new FileWriter(outputFile);){
                writer.write(protoFile.toSchema());
            }
            writtenProtoFiles.add(outputFile);
        } else {
            for (Map.Entry<String, ProtoFile> entry : packageToProtoFileMap.entrySet()) {
                ProtoFile protoFile = entry.getValue();
                File destFolder = this.createPackageFolderStructure(this.configuration.outputDirectory, protoFile.packageName());
                File outputFile = new File(destFolder, protoFile.location().getPath().toLowerCase());
                try (FileWriter writer = new FileWriter(outputFile);){
                    writer.write(protoFile.toSchema());
                }
                writtenProtoFiles.add(outputFile);
            }
        }
        this.parseWrittenFiles();
        if (possibleIncompatibilitiesDetected && this.configuration.failIfRemovedFields) {
            throw new BackwardsCompatibilityCheckException("Possible backwards incompatibility detected. See previous log messages. Re-run with option failIfRemovedFields=false if this is ok");
        }
    }

    private void sortFieldsByTag(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                mt.nestedTypes().stream().filter(e -> e instanceof MessageType).forEach(z -> this.sortFieldsByTag((MessageType)z));
                this.sortFieldsByTag((MessageType)mt);
            });
        }
    }

    private void sortFieldsByTag(MessageType mt) {
        Collections.sort(mt.fields(), Comparator.comparingInt(e -> e.tag()));
        mt.oneOfs().forEach(oneOf -> Collections.sort(oneOf.fields(), Comparator.comparingInt(e -> e.tag())));
    }

    private boolean resolveBackwardIncompatibilities(Map<String, ProtoFile> packageToProtoFileMap) {
        AtomicBoolean possibleIncompatibilitiesDetected = new AtomicBoolean(false);
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                if (this.backwardsCompatibilityChecker.resolveBackwardIncompatibilities(file, (MessageType)mt)) {
                    possibleIncompatibilitiesDetected.set(true);
                }
            });
        }
        return possibleIncompatibilitiesDetected.get();
    }

    private void sortTypesInProtofile(Map<String, ProtoFile> packageToProtoFileMap) {
        packageToProtoFileMap.values().forEach(e -> e.types().sort(Comparator.comparing(x -> x.type().simpleName())));
    }

    private void addPackedOptionToRepeatedFields(Map<String, ProtoFile> packageToProtoFileMap, boolean b) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                this.messageTypes(mt.nestedTypes()).forEach(e -> this.addPackedOptionToRepeatedFields(packageToProtoFileMap, file, (MessageType)e, b));
                this.addPackedOptionToRepeatedFields(packageToProtoFileMap, file, (MessageType)mt, b);
            });
        }
    }

    private void addPackedOptionToRepeatedFields(Map<String, ProtoFile> packageToProtoFileMap, ProtoFile protoFile, MessageType mt, boolean packed) {
        mt.fields().stream().filter(e -> e.label() == Field.Label.REPEATED).filter(e -> this.isExposedToPackedBug(packageToProtoFileMap, protoFile, (Field)e)).forEach(e -> this.addPackedOption((Field)e, packed));
    }

    private void addPackedOption(Field f, boolean packed) {
        OptionElement packedOptionElement = new OptionElement("packed", OptionElement.Kind.BOOLEAN, packed, false);
        f.options().getOptionElements().add(packedOptionElement);
    }

    private boolean isExposedToPackedBug(Map<String, ProtoFile> packageToProtoFileMap, ProtoFile protoFile, Field elementType) {
        return PACKABLE_SCALAR_TYPES_SET.contains(elementType.getElementType()) || this.isEnum(elementType, protoFile, packageToProtoFileMap);
    }

    private boolean isEnum(Field elementType, ProtoFile protoFile, Map<String, ProtoFile> packageToProtoFileMap) {
        String packageName = elementType.packageName();
        if (packageName != null) {
            protoFile = packageToProtoFileMap.get(packageName);
        }
        return protoFile.types().stream().filter(e -> e instanceof EnumType).anyMatch(e -> ((EnumType)e).name().equals(elementType.getElementType()));
    }

    private void removeUnwantedFields(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                this.messageTypes(mt.nestedTypes()).forEach(e -> this.removeUnwantedFields(file, (MessageType)e));
                this.removeUnwantedFields(file, (MessageType)mt);
            });
        }
    }

    private void removeUnwantedFields(ProtoFile file, MessageType mt) {
        List<Field> fieldsToRemove = this.removeUnwantedFields(file.packageName(), mt.getName(), mt.fields());
        for (Field f : fieldsToRemove) {
            mt.removeDeclaredField(f);
            String documentation = StringUtils.trimToEmpty(mt.documentation());
            documentation = documentation + " NOTE: Removed field " + f;
            mt.updateDocumentation(documentation);
        }
        ArrayList<OneOf> oneOfsToRemove = new ArrayList<OneOf>();
        for (OneOf oneOf : mt.oneOfs()) {
            List<Field> oneOfFieldsToRemove = this.removeUnwantedFields(file.packageName(), mt.getName(), oneOf.fields());
            for (Field f : oneOfFieldsToRemove) {
                oneOf.fields().remove(f);
                String documentation = StringUtils.trimToEmpty(mt.documentation());
                documentation = documentation + " NOTE: Removed field " + f;
                oneOf.updateDocumentation(documentation);
            }
            if (!oneOf.fields().isEmpty()) continue;
            oneOfsToRemove.add(oneOf);
        }
        for (OneOf oneOfToRemove : oneOfsToRemove) {
            mt.removeOneOf(oneOfToRemove);
            String documentation = StringUtils.trimToEmpty(mt.documentation());
            documentation = documentation + " NOTE: Removed empty oneOf " + oneOfToRemove;
            mt.updateDocumentation(documentation);
        }
    }

    private List<Field> removeUnwantedFields(String packageName, String messageName, List<Field> fields) {
        ArrayList<Field> fieldsToRemove = new ArrayList<Field>();
        for (Field field : fields) {
            if (!this.typeAndFieldNameMapper.ignoreOutputField(packageName, messageName, field.name())) continue;
            fieldsToRemove.add(field);
        }
        return fieldsToRemove;
    }

    private File createPackageFolderStructure(File outputDirectory, String packageName) {
        String folderSubstructure = this.getPathFromPackageName(packageName);
        File dstFolder = new File(outputDirectory, folderSubstructure);
        dstFolder.mkdirs();
        return dstFolder;
    }

    @NotNull
    private String getPathFromPackageName(String packageName) {
        return packageName.replace('.', '/');
    }

    @NotNull
    private String getPackageFromPathName(String pathName) {
        return pathName.replace(".proto", "").replace('/', '.');
    }

    private void replaceGeneratedTypePlaceholder(Map<String, ProtoFile> packageToProtoFileMap, String generatedRandomTypeSuffix, String newTypeSuffix) {
        for (Map.Entry<String, ProtoFile> protoFile : packageToProtoFileMap.entrySet()) {
            this.replaceGeneratedTypePlaceholder(packageToProtoFileMap, generatedRandomTypeSuffix, newTypeSuffix, protoFile.getValue().types(), protoFile.getValue().packageName());
        }
    }

    private void replaceGeneratedTypePlaceholder(Map<String, ProtoFile> packageToProtoFileMap, String generatedRandomTypePlaceholder, String newTypeSuffix, List<Type> types, String packageName) {
        Set<String> usedNames = this.findExistingTypeNamesInProtoFile(types);
        for (Type type : types) {
            EnumType et;
            String messageName;
            this.replaceGeneratedTypePlaceholder(packageToProtoFileMap, generatedRandomTypePlaceholder, newTypeSuffix, type.nestedTypes(), packageName);
            if (type instanceof MessageType) {
                MessageType mt = (MessageType)type;
                this.replaceGeneratedTypePlaceholder(packageToProtoFileMap, generatedRandomTypePlaceholder, newTypeSuffix, packageName, usedNames, mt);
                continue;
            }
            if (!(type instanceof EnumType) || !(messageName = (et = (EnumType)type).name()).contains(generatedRandomTypePlaceholder)) continue;
            String newMessageName = messageName.replaceAll(generatedRandomTypePlaceholder, newTypeSuffix);
            if (!usedNames.contains(newMessageName)) {
                et.updateName(newMessageName);
                usedNames.add(newMessageName);
                this.updateTypeReferences(packageToProtoFileMap, packageName, messageName, newMessageName);
                continue;
            }
            LOGGER.warn("Cannot rename enum {} to {} as type already exist! Renaming ignored", (Object)messageName, (Object)newMessageName);
        }
    }

    private void replaceGeneratedTypePlaceholder(Map<String, ProtoFile> packageToProtoFileMap, String generatedRandomTypePlaceholder, String newTypeSuffix, String packageName, Set<String> usedNames, MessageType mt) {
        String messageName = mt.getName();
        if (messageName.contains(generatedRandomTypePlaceholder)) {
            String newMessageName = messageName.replaceAll(generatedRandomTypePlaceholder, newTypeSuffix);
            if (!usedNames.contains(newMessageName)) {
                mt.updateName(newMessageName);
                usedNames.add(newMessageName);
                this.updateTypeReferences(packageToProtoFileMap, packageName, messageName, newMessageName);
            } else {
                LOGGER.warn("Cannot rename message {} to {} as type already exist! Renaming ignored", (Object)messageName, (Object)newMessageName);
            }
        }
    }

    private void uppercaseMessageNames(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.uppercaseMessageNames(packageToProtoFileMap, file.types(), file.packageName());
        }
    }

    private void uppercaseMessageNames(Map<String, ProtoFile> packageToProtoFileMap, List<Type> types, String packageName) {
        Set<String> usedNames = this.findExistingTypeNamesInProtoFile(types);
        for (Type type : types) {
            String messageName;
            this.uppercaseMessageNames(packageToProtoFileMap, type.nestedTypes(), packageName);
            if (type instanceof MessageType) {
                MessageType mt = (MessageType)type;
                this.uppercaseMessageNames(packageToProtoFileMap, packageName, usedNames, mt);
                continue;
            }
            if (!(type instanceof EnumType)) continue;
            EnumType et = (EnumType)type;
            String newMessageName = messageName = et.name();
            try {
                newMessageName = this.getCaseFormatName(messageName).to(CaseFormat.UPPER_CAMEL, messageName);
            }
            catch (IllegalFormatException illegalFormatException) {
                // empty catch block
            }
            if (newMessageName.equals(messageName)) continue;
            if (!usedNames.contains(newMessageName)) {
                et.updateName(newMessageName);
                usedNames.add(newMessageName);
                this.updateTypeReferences(packageToProtoFileMap, packageName, messageName, newMessageName);
                continue;
            }
            LOGGER.warn("Cannot uppercase enum {} to {} as type already exist! Renaming ignored", (Object)messageName, (Object)newMessageName);
        }
    }

    private CaseFormat getCaseFormatName(String s2) throws IllegalFormatException {
        if (s2.contains(UNDERSCORE)) {
            if (s2.toUpperCase().equals(s2)) {
                return CaseFormat.UPPER_UNDERSCORE;
            }
            if (s2.toLowerCase().equals(s2)) {
                return CaseFormat.LOWER_UNDERSCORE;
            }
        } else if (s2.contains(DASH)) {
            if (s2.toLowerCase().equals(s2)) {
                return CaseFormat.LOWER_HYPHEN;
            }
        } else if (Character.isLowerCase(s2.charAt(0))) {
            if (s2.matches("([a-z]+[A-Z]+\\w+)+")) {
                return CaseFormat.LOWER_CAMEL;
            }
            if (s2.matches("[a-z]+")) {
                return CaseFormat.LOWER_UNDERSCORE;
            }
        } else {
            if (s2.matches("([A-Z]+[a-z]+\\w+)+")) {
                return CaseFormat.UPPER_CAMEL;
            }
            if (s2.matches("[A-Z]+")) {
                return CaseFormat.UPPER_UNDERSCORE;
            }
        }
        throw new IllegalArgumentException(String.format("Couldn't find the case format of the given string '%s'", s2));
    }

    private void uppercaseMessageNames(Map<String, ProtoFile> packageToProtoFileMap, String packageName, Set<String> usedNames, MessageType mt) {
        String messageName = mt.getName();
        if (!Character.isUpperCase(messageName.charAt(0))) {
            String newMessageName = StringUtils.capitalize(messageName);
            if (!usedNames.contains(newMessageName)) {
                mt.updateName(newMessageName);
                usedNames.add(newMessageName);
                this.updateTypeReferences(packageToProtoFileMap, packageName, messageName, newMessageName);
            } else {
                LOGGER.warn("Cannot uppercase message {} to {} as type already exist! Renaming ignored", (Object)messageName, (Object)newMessageName);
            }
        }
    }

    private void updateEnumValues(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            List<Type> types = file.types();
            this.updateEnumValues(types);
        }
    }

    private void updateEnumValues(List<Type> types) {
        for (Type t : types) {
            if (t instanceof EnumType) {
                EnumType e = (EnumType)t;
                this.updateEnum(e);
            }
            this.updateEnumValues(t.nestedTypes());
        }
    }

    private void updateEnum(EnumType e) {
        ArrayList<OptionElement> optionElementsUnspecified = new ArrayList<OptionElement>();
        String enumValuePrefix = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, e.name()) + UNDERSCORE;
        for (EnumConstant ec : e.constants()) {
            String enumValue = this.escapeEnumValue(ec.getName());
            if (enumValue.equalsIgnoreCase("UNSPECIFIED")) {
                enumValue = "UNSPECIFIED_ENUM_VALUE";
            }
            ec.updateName(enumValuePrefix + enumValue);
        }
        EnumConstant unspecified = new EnumConstant(new Location("", "", 0, 0), enumValuePrefix + "UNSPECIFIED", 0, "Default", new Options(Options.ENUM_VALUE_OPTIONS, optionElementsUnspecified));
        e.constants().add(0, unspecified);
    }

    private String escapeEnumValue(String name) {
        if (name.equals("")) {
            return name;
        }
        try {
            switch (name) {
                case "+": {
                    return "PLUS";
                }
                case "-": {
                    return "MINUS";
                }
            }
            String transformationBasis = name.replaceAll("[^a-zA-Z0-9]+", " ").trim();
            String[] parts = transformationBasis.split(" ");
            ArrayList<String> modifiedParts = new ArrayList<String>();
            for (String part : parts) {
                for (String s2 : StringUtils.splitByCharacterTypeCamelCase(part)) {
                    modifiedParts.add(s2);
                }
            }
            transformationBasis = StringUtils.join(modifiedParts, UNDERSCORE);
            return transformationBasis.toUpperCase();
        }
        catch (Exception e) {
            LOGGER.warn("Error escaping enum value {}, using original. May break proto file", (Object)name, (Object)e);
            return name;
        }
    }

    private void parseWrittenFiles() throws IOException {
        SchemaLoader schemaLoader = new SchemaLoader();
        try {
            if (this.configuration.includeValidationRules) {
                schemaLoader.addProto(VALIDATION_PROTO_IMPORT);
            }
            if (this.configuration.includeXsdOptions) {
                schemaLoader.addProto(XSDOPTIONS_PROTO_IMPORT);
            }
            for (String string : this.configuration.customImportLocations) {
                schemaLoader.addSource(new File(string).toPath());
            }
            schemaLoader.addSource(this.configuration.outputDirectory);
            for (Path path : schemaLoader.sources()) {
                LOGGER.debug("Linking proto from path {}", (Object)path);
            }
            for (String string : schemaLoader.protos()) {
                LOGGER.debug("Linking proto {}", (Object)string);
            }
            schemaLoader.load();
        }
        catch (IOException e) {
            throw new ConversionException("Parsing of written output failed, the proto files are not valid", e);
        }
    }

    private void computeFilenames(Map<String, ProtoFile> packageToProtoFileMap) {
        for (Map.Entry<String, ProtoFile> protoFile : packageToProtoFileMap.entrySet()) {
            ProtoFile file = protoFile.getValue();
            String filename = protoFile.getKey().replaceAll("\\.", UNDERSCORE) + ".proto";
            Location loc = new Location("", filename, 0, 0);
            file.setLocation(loc);
        }
    }

    private void addConfigurationSpecifiedOptions(Map<String, ProtoFile> packageToProtoFileMap) {
        for (Map.Entry<String, ProtoFile> protoFile : packageToProtoFileMap.entrySet()) {
            for (Map.Entry<String, Object> option : this.configuration.options.entrySet()) {
                OptionElement.Kind kind = null;
                kind = option.getValue() instanceof Boolean ? OptionElement.Kind.BOOLEAN : (option.getValue() instanceof Number ? OptionElement.Kind.NUMBER : OptionElement.Kind.STRING);
                OptionElement optionElement = new OptionElement(option.getKey(), kind, option.getValue(), false);
                protoFile.getValue().options().add(optionElement);
            }
        }
    }

    private void resolveRecursiveImports(Map<String, ProtoFile> packageToProtoFileMap) {
        HashMap<String, List<String>> imports = new HashMap<String, List<String>>();
        for (ProtoFile protoFile : packageToProtoFileMap.values()) {
            ArrayList<String> fileImports = new ArrayList<String>();
            fileImports.addAll(protoFile.imports());
            for (int i = 0; i < fileImports.size(); ++i) {
                fileImports.set(i, ((String)fileImports.get(i)).substring(((String)fileImports.get(i)).lastIndexOf(47) + 1));
            }
            imports.put(protoFile.toString(), fileImports);
        }
        for (Map.Entry entry : packageToProtoFileMap.entrySet()) {
            ProtoFile protoFile = (ProtoFile)entry.getValue();
            String filename = protoFile.location().getPath();
            if (!this.hasRecursiveImports(imports, filename, filename)) continue;
            LOGGER.error("File {} recursively imports itself.", (Object)filename);
        }
    }

    private boolean hasRecursiveImports(Map<String, List<String>> imports, String rootFilename, String filename) {
        if (imports.containsKey(filename)) {
            List<String> currentImports = imports.get(filename);
            if (currentImports.contains(rootFilename)) {
                return true;
            }
            for (String currImport : currentImports) {
                if (!this.hasRecursiveImports(imports, rootFilename, currImport)) continue;
                return true;
            }
        }
        return false;
    }

    private void addConfigurationSpecifiedImports(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            for (String customImport : this.configuration.customImports) {
                Type type;
                boolean customImportInUse = false;
                String importPackage = this.getPackageFromPathName(customImport);
                Iterator<Type> iterator2 = file.types().iterator();
                while (iterator2.hasNext() && !(customImportInUse = this.isCustomImportInUseInNestedTypes(importPackage, type = iterator2.next()))) {
                }
                if (!customImportInUse) continue;
                file.imports().add(customImport);
            }
            if (this.configuration.includeValidationRules) {
                file.imports().add(VALIDATION_PROTO_IMPORT);
            }
            if (!this.configuration.includeXsdOptions) continue;
            file.imports().add(XSDOPTIONS_PROTO_IMPORT);
        }
    }

    private boolean isCustomImportInUseInNestedTypes(String importPackage, Type type) {
        AtomicBoolean customImportInUse = new AtomicBoolean(false);
        if (type instanceof MessageType) {
            for (Field field : ((MessageType)type).fieldsAndOneOfFields()) {
                if (field.getElementType() == null || !field.getElementType().equalsIgnoreCase(importPackage)) continue;
                customImportInUse.set(true);
            }
            if (!customImportInUse.get()) {
                this.messageTypes(type.nestedTypes()).forEach(mt -> {
                    for (Field field : ((MessageType)type).fieldsAndOneOfFields()) {
                        if (field.getElementType() == null || !field.getElementType().equalsIgnoreCase(importPackage)) continue;
                        customImportInUse.set(true);
                    }
                    if (!customImportInUse.get()) {
                        customImportInUse.set(this.isCustomImportInUseInNestedTypes(importPackage, (Type)mt));
                    }
                });
            }
        }
        return customImportInUse.get();
    }

    private void computeLocalImports(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            TreeSet<String> imports = new TreeSet<String>(file.imports());
            this.messageTypes(file.types()).forEach(mt -> this.computeLocalImports(packageToProtoFileMap, file, (SortedSet<String>)imports, (MessageType)mt));
            file.imports().clear();
            file.imports().addAll(imports);
        }
    }

    private void computeLocalImports(Map<String, ProtoFile> packageToProtoFileMap, ProtoFile file, SortedSet<String> imports, MessageType messageType) {
        this.messageTypes(messageType.nestedTypes()).forEach(e -> this.computeLocalImports(packageToProtoFileMap, file, imports, (MessageType)e));
        for (Field field : messageType.fieldsAndOneOfFields()) {
            String packageName = StringUtils.trimToNull(field.packageName());
            if (file.packageName() != null && file.packageName().equals(packageName)) {
                field.clearPackageName();
                continue;
            }
            if (packageName == null) continue;
            ProtoFile fileToImport = packageToProtoFileMap.get(packageName);
            if (fileToImport != null) {
                imports.add(this.getPathFromPackageName(packageName) + "/" + fileToImport.location().getPath());
                continue;
            }
            LOGGER.error("Tried to create import for field packageName {}, but no such protofile exist", (Object)packageName);
        }
    }

    private void moveFieldPackageNameToFieldTypeName(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(this::moveFieldPackageNameToFieldTypeName);
        }
    }

    private void moveFieldPackageNameToFieldTypeName(MessageType messageType) {
        this.messageTypes(messageType.nestedTypes()).forEach(this::moveFieldPackageNameToFieldTypeName);
        ImmutableList<Field> fields = messageType.fieldsAndOneOfFields();
        for (Field field : fields) {
            String fieldPackageName = StringUtils.trimToNull(field.packageName());
            if (fieldPackageName == null) continue;
            field.clearPackageName();
            field.updateElementType(fieldPackageName + "." + field.getElementType());
        }
    }

    private void addLeadingPeriodToElementType(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                for (Field field : mt.fieldsAndOneOfFields()) {
                    String fieldElementType = StringUtils.trimToNull(field.getElementType());
                    if (fieldElementType == null || !fieldElementType.contains(".")) continue;
                    for (String pkg : packageToProtoFileMap.keySet()) {
                        if (fieldElementType.equals(pkg)) continue;
                        String rootFieldElementType = fieldElementType.split("\\.")[0];
                        if (!pkg.contains("." + rootFieldElementType + ".")) continue;
                        field.updateElementType("." + fieldElementType);
                    }
                }
            });
        }
    }

    private void translateTypes(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.translateTypes(packageToProtoFileMap, file.types(), file.packageName());
        }
    }

    private void translateTypes(Map<String, ProtoFile> packageToProtoFileMap, List<Type> types, String packageName) {
        if (!types.isEmpty()) {
            Set<String> usedNames = this.findExistingTypeNamesInProtoFile(types);
            for (Type type : types) {
                EnumType et;
                String newMessageName;
                String messageName;
                if (type instanceof MessageType) {
                    MessageType mt = (MessageType)type;
                    this.translateTypes(packageToProtoFileMap, type.nestedTypes(), packageName);
                    messageName = mt.getName();
                    newMessageName = this.typeAndFieldNameMapper.translateType(messageName);
                    if (!messageName.equals(newMessageName)) {
                        if (!usedNames.contains(newMessageName)) {
                            mt.updateName(newMessageName);
                            usedNames.add(newMessageName);
                            this.updateTypeReferences(packageToProtoFileMap, packageName, messageName, newMessageName);
                        } else {
                            LOGGER.warn("Cannot rename message {} to {} as type already exist! Renaming ignored", (Object)messageName, (Object)newMessageName);
                        }
                    }
                    this.translateTypes(mt.fieldsAndOneOfFields());
                    continue;
                }
                if (!(type instanceof EnumType) || (messageName = (et = (EnumType)type).name()).equals(newMessageName = this.typeAndFieldNameMapper.translateType(messageName))) continue;
                if (!usedNames.contains(newMessageName)) {
                    et.updateName(newMessageName);
                    usedNames.add(newMessageName);
                    this.updateTypeReferences(packageToProtoFileMap, packageName, messageName, newMessageName);
                    continue;
                }
                LOGGER.warn("Cannot rename enum {} to {} as type already exist! Renaming ignored", (Object)messageName, (Object)newMessageName);
            }
        }
    }

    private void translateTypes(List<Field> fields) {
        for (Field field : fields) {
            String newFieldType;
            if (field.packageName() != null || !this.basicTypes.contains(field.getElementType()) || (newFieldType = this.typeAndFieldNameMapper.translateType(field.getElementType())).equals(field.getElementType())) continue;
            LOGGER.debug("Replacing basicType {} with {}", (Object)field.getElementType(), (Object)newFieldType);
            field.updateElementType(newFieldType);
        }
    }

    private void replaceTypes(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.replaceTypes_(file.types());
        }
    }

    private void replaceTypes_(List<Type> types) {
        this.messageTypes(types).forEach(mt -> {
            this.replaceTypes_(mt.nestedTypes());
            this.replaceTypes(mt.fieldsAndOneOfFields());
        });
    }

    private void replaceTypes(List<Field> fields) {
        for (Field field : fields) {
            String newFieldType = this.typeAndFieldNameMapper.replaceType(field.getElementType());
            field.updateElementType(newFieldType);
        }
    }

    private void updateTypeReferences(Map<String, ProtoFile> packageToProtoFileMap, String packageNameOfType, String oldName, String newName) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.updateTypeReferences(packageNameOfType, oldName, newName, file.types(), file.packageName());
        }
    }

    private void updateTypeReferences(String packageNameOfType, String oldName, String newName, List<Type> types, String currentMessageTypePackage) {
        for (Type type : types) {
            this.updateTypeReferences(packageNameOfType, oldName, newName, type.nestedTypes(), currentMessageTypePackage);
            if (!(type instanceof MessageType)) continue;
            MessageType mt = (MessageType)type;
            this.updateTypeReferences(packageNameOfType, oldName, newName, mt, mt.fieldsAndOneOfFields(), currentMessageTypePackage);
        }
    }

    private void updateTypeReferences(String packageNameOfType, String oldName, String newName, MessageType mt, Collection<Field> fields, String currentMessageTypePackage) {
        for (Field field : fields) {
            String fieldType;
            if (!this.samePackage(field.packageName(), packageNameOfType) || !(fieldType = field.getElementType()).equals(oldName)) continue;
            field.updateElementType(newName);
            LOGGER.debug("Updating field {} in type {} to {}", oldName, mt.getName(), newName);
        }
        Options options = mt.options();
        ArrayList<OptionElement> listCopy = new ArrayList<OptionElement>(options.getOptionElements());
        listCopy.stream().filter(e -> e.getName().equals("xsd.base_type")).forEach(e -> {
            String packageAndType = (String)e.getValue();
            if (packageAndType.equals(".")) {
                String packageName = packageAndType.substring(0, packageAndType.lastIndexOf(46));
                String messageName = packageAndType.substring(packageName.hashCode() + 1);
                if (packageName.equals(packageAndType) && oldName.equals(messageName)) {
                    options.replaceOption("xsd.base_type", new OptionElement("xsd.base_type", OptionElement.Kind.STRING, packageName + "." + newName, true));
                }
            } else if (currentMessageTypePackage.equals(packageNameOfType) && packageAndType.equals(oldName)) {
                options.replaceOption("xsd.base_type", new OptionElement("xsd.base_type", OptionElement.Kind.STRING, newName, true));
            }
        });
    }

    private boolean samePackage(String packageNameOfFile, String packageNameOfReferencedTypeInField) {
        if (packageNameOfFile == null && packageNameOfReferencedTypeInField == null) {
            return true;
        }
        if (packageNameOfFile == null) {
            return false;
        }
        if (packageNameOfReferencedTypeInField == null) {
            return false;
        }
        return packageNameOfFile.equals(packageNameOfReferencedTypeInField);
    }

    private Set<String> findExistingTypeNamesInProtoFile(List<Type> types) {
        HashSet<String> existingTypeNames = new HashSet<String>();
        for (Type t : types) {
            if (t instanceof MessageType) {
                existingTypeNames.add(((MessageType)t).getName());
                continue;
            }
            if (!(t instanceof EnumType)) continue;
            existingTypeNames.add(((EnumType)t).name());
        }
        return existingTypeNames;
    }

    private void translateFieldNames(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                this.messageTypes(mt.nestedTypes()).forEach(e -> this.translateFieldNames(e.fieldsAndOneOfFields()));
                this.translateFieldNames(mt.fieldsAndOneOfFields());
            });
        }
    }

    private void translateFieldNames(List<Field> fields) {
        for (Field field : fields) {
            String fieldName = field.name();
            String newFieldName = this.typeAndFieldNameMapper.translateFieldName(fieldName);
            field.updateName(newFieldName);
        }
    }

    private void handleFieldNameCaseInsensitives(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                this.messageTypes(mt.nestedTypes()).forEach(e -> this.handleFieldNameCaseInsensitives(e.fieldsAndOneOfFields()));
                this.handleFieldNameCaseInsensitives(mt.fieldsAndOneOfFields());
            });
        }
    }

    private void handleFieldNameCaseInsensitives(List<Field> fields) {
        HashSet<String> fieldNamesUppercase = new HashSet<String>();
        for (Field field : fields) {
            String fieldName = field.name();
            boolean existedBefore = fieldNamesUppercase.add(fieldName.toUpperCase());
            if (existedBefore) continue;
            fieldName = fieldName + UNDERSCORE + "v";
            field.updateName(fieldName);
        }
    }

    private void underscoreFieldNames(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(this::underscoreFieldNames);
        }
    }

    private void underscoreFieldNames(MessageType mt) {
        this.messageTypes(mt.nestedTypes()).forEach(this::underscoreFieldNames);
        for (Field field : mt.fieldsAndOneOfFields()) {
            String fieldName = field.name();
            boolean startsWithUnderscore = fieldName.startsWith(UNDERSCORE);
            boolean endsWithUnderscore = fieldName.endsWith(UNDERSCORE);
            String strippedFieldName = StringUtils.removeEnd(StringUtils.removeStart(fieldName, UNDERSCORE), UNDERSCORE);
            String newFieldName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, strippedFieldName);
            newFieldName = StringUtils.remove(newFieldName, DASH);
            if (endsWithUnderscore) {
                newFieldName = newFieldName + "u";
            }
            if (startsWithUnderscore) {
                newFieldName = UNDERSCORE + newFieldName;
            }
            field.updateName(newFieldName);
        }
    }

    private void escapeReservedJavaKeywords(Map<String, ProtoFile> packageToProtoFileMap) {
        for (ProtoFile file : packageToProtoFileMap.values()) {
            this.messageTypes(file.types()).forEach(mt -> {
                this.messageTypes(mt.nestedTypes()).forEach(this::escapeReservedJavaKeywords);
                this.escapeReservedJavaKeywords((MessageType)mt);
            });
        }
    }

    private void escapeReservedJavaKeywords(MessageType mt) {
        for (Field field : mt.fieldsAndOneOfFields()) {
            String fieldName = field.name();
            String newFieldName = this.typeAndFieldNameMapper.escapeFieldName(fieldName);
            field.updateName(newFieldName);
        }
    }

    private void moveReusedLocalTypesToGlobal(Map<String, ProtoFile> packageToProtoFileMap, List<LocalType> localTypesAllPackages) {
        LOGGER.debug("Reorganizing embedded local types into global if reused");
        localTypesAllPackages.forEach(e -> LOGGER.debug("{} -> {}", (Object)e.enclosingType.getName(), (Object)e.localType.getName()));
        for (Map.Entry<String, ProtoFile> protoFileEntry : packageToProtoFileMap.entrySet()) {
            String currentPackageName = protoFileEntry.getKey();
            TreeMap<ComponentMessageWrapper, Integer> seenComplexTypesWithSameName = new TreeMap<ComponentMessageWrapper, Integer>(Comparator.comparing(o -> o.messageName));
            List<LocalType> localTypes = localTypesAllPackages.stream().filter(e -> e.targetPackage.equals(currentPackageName)).collect(Collectors.toList());
            localTypes.forEach(e -> {
                ComponentMessageWrapper wrapper = new ComponentMessageWrapper(e.xsComponent, e.enclosingComplexType, e.localType.getName());
                Integer count = (Integer)seenComplexTypesWithSameName.get(wrapper);
                if (count == null) {
                    seenComplexTypesWithSameName.put(wrapper, 1);
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    seenComplexTypesWithSameName.put(wrapper, count);
                }
            });
            seenComplexTypesWithSameName.forEach((key, value) -> LOGGER.debug("{} : {}", key, value));
            seenComplexTypesWithSameName.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).forEach(e -> {
                ComponentMessageWrapper currentComponent = (ComponentMessageWrapper)e.getKey();
                LOGGER.debug("ComplexType/name reused: {} / {} times", (Object)currentComponent, e.getValue());
                List<LocalType> usagesThisComponent = localTypes.stream().filter(x -> currentComponent.messageName.equals(x.localType.getName())).filter(x -> currentComponent.xsComponent == x.xsComponent).filter(x -> currentComponent.enclosingComplexType == x.enclosingComplexType).collect(Collectors.toList());
                LocalType first = (LocalType)usagesThisComponent.get(0);
                int numUniqueEnclosingTypes = usagesThisComponent.stream().map(u -> u.enclosingType.getName()).collect(Collectors.toSet()).size();
                if (numUniqueEnclosingTypes > 1) {
                    List usagesOtherComponentsSameTypeName = localTypes.stream().filter(x -> x.localType.getName().equals(currentComponent.messageName)).filter(x -> x.xsComponent != currentComponent.xsComponent).collect(Collectors.toList());
                    String packageName = first.targetPackage;
                    if (packageName == null) {
                        packageName = "default";
                    }
                    ProtoFile enclosingFile = (ProtoFile)packageToProtoFileMap.get(packageName);
                    String candidateName = currentComponent.messageName;
                    if (!usagesOtherComponentsSameTypeName.isEmpty()) {
                        Set enclosingTypes = usagesThisComponent.stream().map(k -> k.enclosingComplexType.getName()).collect(Collectors.toSet());
                        if (enclosingTypes.size() > 1) {
                            throw new IllegalArgumentException(String.format("Candidate enclosing types for %s are many - should be one %s. Cannot continue as conversion is not deterministic", first.localType.getName(), ToStringBuilder.reflectionToString(enclosingTypes.toArray(), ToStringStyle.SIMPLE_STYLE)));
                        }
                        candidateName = StringUtils.capitalize((String)enclosingTypes.iterator().next()) + UNDERSCORE + StringUtils.capitalize(first.localType.type().simpleName());
                        LOGGER.debug("Candidate name for inherited local type prefixed with enclosing type {}", (Object)candidateName);
                    } else {
                        LOGGER.debug("Candidate name for inherited local type {} is unique - keeping as is", (Object)candidateName);
                    }
                    Optional<Type> existingType = this.checkForExistingType(enclosingFile, candidateName);
                    if (!existingType.isPresent()) {
                        MessageType localToBecomeGlobal = first.localType;
                        localToBecomeGlobal.updateName(candidateName);
                        enclosingFile.types().add(localToBecomeGlobal);
                        usagesThisComponent.forEach(y -> {
                            y.enclosingType.nestedTypes().remove(y.localType);
                            String previousElementType = y.referencingField.getElementType();
                            y.referencingField.updateElementType(localToBecomeGlobal.getName());
                            LOGGER.debug("In type {} field {} of type {} have now been replaced with package global type {}", y.enclosingType.getName(), y.referencingField.name(), previousElementType, localToBecomeGlobal.getName());
                        });
                    } else {
                        LOGGER.warn("Could not extract local type {} from {} using new global name {} due to an existing type with this name. This is a limitation of the current code but can be fixed with a better naming scheme", currentComponent.messageName, first.enclosingType.getName(), candidateName);
                    }
                } else {
                    LOGGER.debug("Not extracting {} due to single enclosing type {}", (Object)first.localType.getName(), (Object)first.enclosingType.getName());
                }
            });
        }
    }

    @NotNull
    private Optional<Type> checkForExistingType(ProtoFile enclosingFile, String candidateName) {
        Optional<Type> existingType = Optional.empty();
        for (Type type : enclosingFile.types()) {
            if (!candidateName.equals(type.type().simpleName())) continue;
            existingType = Optional.of(type);
            break;
        }
        return existingType;
    }

    private Stream<MessageType> messageTypes(List<Type> types) {
        return types.stream().filter(t -> t instanceof MessageType).map(mt -> (MessageType)mt);
    }

    private static class ComponentMessageWrapper {
        XSComponent xsComponent;
        XSComplexType enclosingComplexType;
        String messageName;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentMessageWrapper that = (ComponentMessageWrapper)o;
            return Objects.equals(this.xsComponent, that.xsComponent) && Objects.equals(this.messageName, that.messageName) && Objects.equals(this.enclosingComplexType, that.enclosingComplexType);
        }

        public int hashCode() {
            return Objects.hash(this.xsComponent, this.messageName, this.enclosingComplexType);
        }

        public ComponentMessageWrapper(XSComponent xsComponent, XSComplexType enclosingComplexType, String messageName) {
            this.xsComponent = xsComponent;
            this.enclosingComplexType = enclosingComplexType;
            this.messageName = messageName;
        }

        public String toString() {
            return "ComponentMessageWrapper{xsComponent=" + this.xsComponent + ", enclosingComplexType=" + this.enclosingComplexType + ", messageName='" + this.messageName + '\'' + '}';
        }
    }
}

