/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto.compatibility;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Reserved;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import no.entur.schema2proto.generateproto.compatibility.protolock.ProtolockDefinition;
import no.entur.schema2proto.generateproto.compatibility.protolock.ProtolockDefinitions;
import no.entur.schema2proto.generateproto.compatibility.protolock.ProtolockField;
import no.entur.schema2proto.generateproto.compatibility.protolock.ProtolockFile;
import no.entur.schema2proto.generateproto.compatibility.protolock.ProtolockMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtolockBackwardsCompatibilityChecker {
    private ProtolockDefinitions definitions = null;
    private boolean failIfRemovedFieldsTriggered = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtolockBackwardsCompatibilityChecker.class);

    public void init(File protoLockFile) throws FileNotFoundException {
        Gson gson = new Gson();
        this.definitions = gson.fromJson((Reader)new FileReader(protoLockFile), ProtolockDefinitions.class);
    }

    public ProtolockDefinitions getDefinitions() {
        return this.definitions;
    }

    public SortedSet<ProtolockField> getFields(ProtolockMessage protolockMessage) {
        if (protolockMessage != null && protolockMessage.getFields() != null) {
            return new TreeSet<ProtolockField>(Arrays.stream(protolockMessage.getFields()).collect(Collectors.toSet()));
        }
        return new TreeSet<ProtolockField>();
    }

    private ProtolockMessage getProtolockMessage(ProtolockFile protolockFile, MessageType e) {
        if (protolockFile != null && protolockFile.getMessages() != null) {
            return Arrays.stream(protolockFile.getMessages()).filter(message -> message.getName().equals(e.getName())).findFirst().orElse(null);
        }
        return null;
    }

    private ProtolockMessage getNestedProtolockMessage(ProtolockMessage protolockMessage, MessageType nestedType) {
        if (protolockMessage != null && protolockMessage.getMessages() != null) {
            return Arrays.stream(protolockMessage.getMessages()).filter(subMessage -> subMessage.getName().equals(nestedType.getName())).findFirst().orElse(null);
        }
        return null;
    }

    private ProtolockFile getProtolockFile(ProtoFile file) {
        String fullPath = file.toString();
        if (!fullPath.contains("/")) {
            fullPath = file.packageName().replace(".", "/") + "/" + file.toString();
        }
        for (ProtolockDefinition def : this.definitions.getDefinitions()) {
            if (!def.getProtopath().replace(":/:", "/").equals(fullPath)) continue;
            return def.getFile();
        }
        LOGGER.warn("Could not find a matching entry in proto.lock for {}", (Object)file.name());
        return null;
    }

    public boolean resolveBackwardIncompatibilities(ProtoFile file, MessageType e) {
        ProtolockMessage protolockMessage;
        ProtolockFile protolockFile = this.getProtolockFile(file);
        if (protolockFile != null && (protolockMessage = this.getProtolockMessage(protolockFile, e)) != null) {
            this.copyReservations(protolockMessage, e);
            this.tryResolveFieldConflicts(file, e, protolockMessage);
        }
        return this.failIfRemovedFieldsTriggered;
    }

    private void copyReservations(ProtolockMessage protolockMessage, MessageType e) {
        String reservationDoc = "Reservation added by schema2proto";
        Location loc = new Location("", "", 0, 0);
        if (protolockMessage.getReservedIds() != null && protolockMessage.getReservedIds().length > 0) {
            e.addReserved(new Reserved(loc, reservationDoc, Lists.newArrayList(protolockMessage.getReservedIds())));
        }
        if (protolockMessage.getReservedNames() != null && protolockMessage.getReservedNames().length > 0) {
            e.addReserved(new Reserved(loc, reservationDoc, Lists.newArrayList(protolockMessage.getReservedNames())));
        }
        e.nestedTypes().stream().filter(z -> z instanceof MessageType).map(k -> (MessageType)k).forEach(nestedType -> {
            if (protolockMessage.getMessages() != null) {
                Arrays.stream(protolockMessage.getMessages()).forEach(nestedProtolockMessage -> {
                    if (nestedProtolockMessage.getName().equals(nestedType.getName())) {
                        this.copyReservations((ProtolockMessage)nestedProtolockMessage, (MessageType)nestedType);
                    }
                });
            }
        });
    }

    private void tryResolveFieldConflicts(ProtoFile file, MessageType protoMessage, ProtolockMessage protolockMessage) {
        SortedSet<ProtolockField> lockFields = Collections.unmodifiableSortedSet(this.getFields(protolockMessage));
        SortedSet<ProtolockField> xsdFields = Collections.unmodifiableSortedSet(new TreeSet(protoMessage.fieldsAndOneOfFields().stream().map(f -> new ProtolockField(f.tag(), f.name())).collect(Collectors.toSet())));
        TreeSet<ProtolockField> newFieldsInXsd = new TreeSet<ProtolockField>(xsdFields);
        newFieldsInXsd.removeAll(lockFields);
        TreeSet<ProtolockField> surplusLockFields = new TreeSet<ProtolockField>(lockFields);
        surplusLockFields.removeAll(xsdFields);
        if (newFieldsInXsd.isEmpty() && surplusLockFields.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No added or removed fields in proto {} {}", (Object)file.name(), (Object)protoMessage.getName());
            }
        } else if (newFieldsInXsd.isEmpty() && !surplusLockFields.isEmpty()) {
            surplusLockFields.stream().forEach(newField -> this.reserveField(file, protoMessage, (ProtolockField)newField));
        } else if (!newFieldsInXsd.isEmpty() && surplusLockFields.isEmpty()) {
            newFieldsInXsd.stream().forEach(newField -> LOGGER.debug("Added field in proto {} {} : {}", file.name(), protoMessage.getName(), newField));
        } else {
            BiMap<String, Integer> xsdFieldsNameToId = this.createBiMap(newFieldsInXsd);
            BiMap<Integer, String> xsdFieldsIdToName = xsdFieldsNameToId.inverse();
            BiMap<String, Integer> newFieldsInLockMapNameToId = this.createBiMap(surplusLockFields);
            BiMap<Integer, String> newFieldsInLockMapIdToName = newFieldsInLockMapNameToId.inverse();
            TreeSet overlappingNames = new TreeSet(xsdFieldsNameToId.keySet());
            overlappingNames.retainAll(newFieldsInLockMapNameToId.keySet());
            TreeSet overlappingIds = new TreeSet(xsdFieldsNameToId.values());
            overlappingIds.retainAll(newFieldsInLockMapNameToId.values());
            if (!overlappingIds.isEmpty() || !overlappingNames.isEmpty()) {
                String overlappingName;
                Integer originalFieldIdForNewName;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Incompatible changes in proto {} {} , overlapping ids={}, overlapping fieldnames={}", file.name(), protoMessage.getName(), overlappingIds, overlappingNames);
                }
                AtomicInteger nextAvailableFieldNum = this.findNextAvailableFieldNum(protoMessage, xsdFields);
                if (!overlappingIds.isEmpty()) {
                    int overlappingId = (Integer)overlappingIds.first();
                    String originalFieldNameUsingThisId = (String)newFieldsInLockMapIdToName.get(overlappingId);
                    if (originalFieldNameUsingThisId != null) {
                        String intrudingFieldName = (String)xsdFieldsIdToName.get(overlappingId);
                        Optional<Field> intrudingField = this.getField(protoMessage, intrudingFieldName);
                        Optional<Field> existingField = this.getField(protoMessage, originalFieldNameUsingThisId);
                        Integer idFromLockFile = (Integer)newFieldsInLockMapNameToId.get(intrudingFieldName);
                        this.updateFieldTag(nextAvailableFieldNum, overlappingId, intrudingField, existingField, idFromLockFile);
                    }
                } else if (!overlappingNames.isEmpty() && (originalFieldIdForNewName = (Integer)newFieldsInLockMapNameToId.get(overlappingName = (String)overlappingNames.first())) != null) {
                    Integer intrudingFieldId = (Integer)xsdFieldsNameToId.get(overlappingName);
                    Optional<Field> intrudingField = this.getField(protoMessage, intrudingFieldId);
                    Optional<Field> existingField = this.getField(protoMessage, originalFieldIdForNewName);
                    Integer idFromLockFile = (Integer)newFieldsInLockMapNameToId.get(overlappingName);
                    this.updateFieldTag(nextAvailableFieldNum, originalFieldIdForNewName, intrudingField, existingField, idFromLockFile);
                }
                this.tryResolveFieldConflicts(file, protoMessage, protolockMessage);
            } else {
                surplusLockFields.stream().forEach(newField -> {
                    this.reserveField(file, protoMessage, (ProtolockField)newField);
                    LOGGER.debug("Removed field in proto {}: {}, adding reserved section", (Object)file.name(), newField);
                });
            }
        }
        protoMessage.nestedTypes().stream().filter(type -> type instanceof MessageType).forEach(nestedProtoMessage -> {
            ProtolockMessage nestedProtolockMessage = this.getNestedProtolockMessage(protolockMessage, (MessageType)nestedProtoMessage);
            if (nestedProtolockMessage != null) {
                this.tryResolveFieldConflicts(file, (MessageType)nestedProtoMessage, nestedProtolockMessage);
            }
        });
    }

    private void updateFieldTag(AtomicInteger nextAvailableFieldNum, int overlappingId, Optional<Field> intrudingField, Optional<Field> existingField, Integer idFromLockFile) {
        intrudingField.ifPresent(x -> {
            if (idFromLockFile != null) {
                x.updateTag(idFromLockFile);
            } else {
                x.updateTag(nextAvailableFieldNum.get());
            }
        });
        existingField.ifPresent(x -> x.updateTag(overlappingId));
    }

    @NotNull
    private AtomicInteger findNextAvailableFieldNum(MessageType e, SortedSet<ProtolockField> xsdFields) {
        AtomicInteger nextAvailableFieldNum = new AtomicInteger(xsdFields.stream().max(Comparator.comparing(ProtolockField::getId)).orElse(new ProtolockField(0, null)).getId() + 1);
        while (e.getReserveds().stream().anyMatch(s2 -> s2.matchesTag(nextAvailableFieldNum.get()))) {
            nextAvailableFieldNum.incrementAndGet();
        }
        return nextAvailableFieldNum;
    }

    private BiMap<String, Integer> createBiMap(Set<ProtolockField> fields) {
        HashBiMap<String, Integer> fieldMap = HashBiMap.create();
        fields.stream().forEach(e -> fieldMap.put(e.getName(), e.getId()));
        return fieldMap;
    }

    private Optional<Field> getField(MessageType e, String intrudingFieldName) {
        return e.fieldsAndOneOfFields().stream().filter(z -> z.name().equals(intrudingFieldName)).findFirst();
    }

    private Optional<Field> getField(MessageType e, Integer intrudingFieldId) {
        return e.fieldsAndOneOfFields().stream().filter(z -> z.tag() == intrudingFieldId.intValue()).findFirst();
    }

    private void reserveField(ProtoFile file, MessageType e, ProtolockField newField) {
        String reservationDoc = "Reservation added by schema2proto";
        Location loc = new Location("", "", 0, 0);
        e.addReserved(new Reserved(loc, reservationDoc, Arrays.asList(newField.getName())));
        e.addReserved(new Reserved(loc, reservationDoc, Arrays.asList(newField.getId())));
        LOGGER.warn("Possible backwards incompatibility detected, must be checked manually! Removed field in proto {}, message {}, field {}, blocking field name and id for future use by adding 'reserved' statement", file.name(), e.getName(), newField);
        this.failIfRemovedFieldsTriggered = true;
    }
}

