/*-
 * #%L
 * schema2proto-lib
 * %%
 * Copyright (C) 2019 - 2020 Entur
 * %%
 * Licensed under the EUPL, Version 1.1 or – as soon they will be
 * approved by the European Commission - subsequent versions of the
 * EUPL (the "Licence");
 *
 * You may not use this work except in compliance with the Licence.
 * You may obtain a copy of the Licence at:
 *
 * http://ec.europa.eu/idabc/eupl5
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the Licence is distributed on an "AS IS" basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the Licence for the specific language governing permissions and
 * limitations under the Licence.
 * #L%
 */
package no.entur.schema2proto.compatibility.protolock;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

public class ProtolockField implements Comparable<ProtolockField> {
	private String name;
	private int id;

	public ProtolockField(int tag, String name) {
		this.id = tag;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public int getId() {
		return id;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		ProtolockField that = (ProtolockField) o;
		return id == that.id && Objects.equals(name, that.name);
	}

	@Override
	public int hashCode() {
		return Objects.hash(name, id);
	}

	@Override
	public String toString() {
		return "ProtolockField{" + "name='" + name + '\'' + ", id=" + id + '}';
	}

	@Override
	public int compareTo(@NotNull ProtolockField protolockField) {
		if (id == protolockField.id) {
			return name.compareTo(protolockField.name);
		} else {
			return Integer.compare(id, protolockField.id);
		}
	}
}
