/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.NamespaceIdentifier;
import de.slub.urn.RFC;
import de.slub.urn.URNSyntaxError;
import java.util.regex.Pattern;

public final class NID_RFC8141
extends NamespaceIdentifier {
    private static final Pattern allowedNID = Pattern.compile("^[0-9a-z][0-9a-z-]{0,30}[0-9a-z]$", 2);
    private static final Pattern formalExclusionNID = Pattern.compile("^([a-z]{2}-{1,2}|X-).*", 2);
    private static final Pattern informalNID = Pattern.compile("^(urn-[1-9][0-9]*).*", 2);

    public NID_RFC8141(String nid) throws URNSyntaxError {
        super(nid);
    }

    public NID_RFC8141(NamespaceIdentifier instanceForCopying) {
        super(instanceForCopying);
    }

    public boolean isFormal() {
        return !formalExclusionNID.matcher(this.toString()).matches() && !this.isInformal();
    }

    public boolean isInformal() {
        return informalNID.matcher(this.toString()).matches();
    }

    @Override
    public RFC supportedRFC() {
        return RFC.RFC_8141;
    }

    @Override
    protected String validateNamespaceIdentifier(String nid) {
        if (nid.length() < 2) {
            return String.format("Namespace Identifier '%s' is too short.", nid);
        }
        if (!allowedNID.matcher(nid).matches()) {
            return String.format("Not allowed characters in Namespace Identifier '%s'", nid);
        }
        return null;
    }
}

