/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.NID_RFC8141;
import de.slub.urn.NSS_RFC8141;
import de.slub.urn.NamespaceIdentifier;
import de.slub.urn.NamespaceSpecificString;
import de.slub.urn.RFC;
import de.slub.urn.RQF_RFC8141;
import de.slub.urn.URN;

public final class URN_8141
extends URN {
    protected final RFC supportedRfc = RFC.RFC_8141;
    private final NID_RFC8141 namespaceIdentifier;
    private final NSS_RFC8141 namespaceSpecificString;
    private final RQF_RFC8141 rqfComponents;

    URN_8141(NID_RFC8141 namespaceIdentifier, NSS_RFC8141 namespaceSpecificString, RQF_RFC8141 rqfComponents) {
        URN_8141.assertNotNull(namespaceIdentifier, "Namespace identifier cannot be null");
        URN_8141.assertNotNull(namespaceSpecificString, "Namespace specific string cannot be null");
        URN_8141.assertNotNull(rqfComponents, "Resolution-Query-Fragment component cannot be null");
        this.namespaceIdentifier = namespaceIdentifier;
        this.namespaceSpecificString = namespaceSpecificString;
        this.rqfComponents = rqfComponents;
    }

    public RQF_RFC8141 getRQFComponents() {
        return this.rqfComponents;
    }

    public String toString() {
        return String.format("%s:%s:%s%s", "urn", this.namespaceIdentifier, this.namespaceSpecificString, this.rqfComponents);
    }

    @Override
    public NamespaceIdentifier namespaceIdentifier() {
        return this.namespaceIdentifier;
    }

    @Override
    public NamespaceSpecificString namespaceSpecificString() {
        return this.namespaceSpecificString;
    }

    @Override
    public RFC supportedRFC() {
        return this.supportedRfc;
    }

    private static void assertNotNull(Object o, String message) {
        if (o == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

