/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.compatibility;

import com.google.common.collect.BiMap;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import no.entur.schema2proto.compatibility.ConflictResolverHelper;
import no.entur.schema2proto.compatibility.protolock.ProtolockField;
import no.entur.schema2proto.compatibility.protolock.ProtolockMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConflictChecker {
    private final Logger LOGGER = LoggerFactory.getLogger(FieldConflictChecker.class);
    private boolean failIfRemovedFieldsTriggered;

    public boolean tryResolveFieldConflicts(ProtoFile file, MessageType protoMessage, ProtolockMessage protolockMessage) {
        SortedSet<ProtolockField> lockFields = Collections.unmodifiableSortedSet(this.getFields(protolockMessage));
        SortedSet<ProtolockField> xsdFields = Collections.unmodifiableSortedSet(new TreeSet(protoMessage.fieldsAndOneOfFields().stream().map(f -> new ProtolockField(f.tag(), f.name())).collect(Collectors.toSet())));
        TreeSet newFieldsInXsd = new TreeSet(xsdFields);
        newFieldsInXsd.removeAll(lockFields);
        TreeSet<ProtolockField> surplusLockFields = new TreeSet<ProtolockField>(lockFields);
        surplusLockFields.removeAll(xsdFields);
        if (newFieldsInXsd.isEmpty() && surplusLockFields.isEmpty()) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("No added or removed fields in proto {} {}", (Object)file.name(), (Object)protoMessage.getName());
            }
        } else if (newFieldsInXsd.isEmpty() && !surplusLockFields.isEmpty()) {
            surplusLockFields.stream().forEach(newField -> this.reserveField(file, protoMessage, (ProtolockField)newField));
        } else if (!newFieldsInXsd.isEmpty() && surplusLockFields.isEmpty()) {
            newFieldsInXsd.stream().forEach(newField -> this.LOGGER.debug("Added field in proto {} {} : {}", file.name(), protoMessage.getName(), newField));
        } else {
            BiMap<String, Integer> xsdFieldsNameToId = ConflictResolverHelper.createBiMap(newFieldsInXsd);
            BiMap<Integer, String> xsdFieldsIdToName = xsdFieldsNameToId.inverse();
            BiMap<String, Integer> newFieldsInLockMapNameToId = ConflictResolverHelper.createBiMap(surplusLockFields);
            BiMap<Integer, String> newFieldsInLockMapIdToName = newFieldsInLockMapNameToId.inverse();
            TreeSet overlappingNames = new TreeSet(xsdFieldsNameToId.keySet());
            overlappingNames.retainAll(newFieldsInLockMapNameToId.keySet());
            TreeSet overlappingIds = new TreeSet(xsdFieldsNameToId.values());
            overlappingIds.retainAll(newFieldsInLockMapNameToId.values());
            if (!overlappingIds.isEmpty() || !overlappingNames.isEmpty()) {
                String overlappingName;
                Integer originalFieldIdForNewName;
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Incompatible changes in proto {} {} , overlapping ids={}, overlapping fieldnames={}", file.name(), protoMessage.getName(), overlappingIds, overlappingNames);
                }
                AtomicInteger nextAvailableFieldNum = this.findNextAvailableFieldNum(protoMessage, xsdFields, lockFields);
                if (!overlappingIds.isEmpty()) {
                    int overlappingId = (Integer)overlappingIds.first();
                    String originalFieldNameUsingThisId = (String)newFieldsInLockMapIdToName.get(overlappingId);
                    if (originalFieldNameUsingThisId != null) {
                        String intrudingFieldName = (String)xsdFieldsIdToName.get(overlappingId);
                        Optional<Field> intrudingField = this.getField(protoMessage, intrudingFieldName);
                        Optional<Field> existingField = this.getField(protoMessage, originalFieldNameUsingThisId);
                        Integer idFromLockFile = (Integer)newFieldsInLockMapNameToId.get(intrudingFieldName);
                        this.updateFieldTag(nextAvailableFieldNum, overlappingId, intrudingField, existingField, idFromLockFile);
                    }
                } else if (!overlappingNames.isEmpty() && (originalFieldIdForNewName = (Integer)newFieldsInLockMapNameToId.get(overlappingName = (String)overlappingNames.first())) != null) {
                    Integer intrudingFieldId = (Integer)xsdFieldsNameToId.get(overlappingName);
                    Optional<Field> intrudingField = this.getField(protoMessage, intrudingFieldId);
                    Optional<Field> existingField = this.getField(protoMessage, originalFieldIdForNewName);
                    Integer idFromLockFile = (Integer)newFieldsInLockMapNameToId.get(overlappingName);
                    this.updateFieldTag(nextAvailableFieldNum, originalFieldIdForNewName, intrudingField, existingField, idFromLockFile);
                }
                this.tryResolveFieldConflicts(file, protoMessage, protolockMessage);
            } else {
                surplusLockFields.stream().forEach(newField -> {
                    this.reserveField(file, protoMessage, (ProtolockField)newField);
                    this.LOGGER.debug("Removed field in proto {}: {}, adding reserved section", (Object)file.name(), newField);
                });
            }
        }
        return this.failIfRemovedFieldsTriggered;
    }

    private void updateFieldTag(AtomicInteger nextAvailableFieldNum, int overlappingId, Optional<Field> intrudingField, Optional<Field> existingField, Integer idFromLockFile) {
        intrudingField.ifPresent(x -> {
            if (idFromLockFile != null) {
                x.updateTag(idFromLockFile);
            } else {
                x.updateTag(nextAvailableFieldNum.get());
            }
        });
        existingField.ifPresent(x -> x.updateTag(overlappingId));
    }

    @NotNull
    private AtomicInteger findNextAvailableFieldNum(MessageType e, SortedSet<ProtolockField> xsdFields, SortedSet<ProtolockField> lockFields) {
        AtomicInteger nextAvailableFieldNum = new AtomicInteger(xsdFields.stream().max(Comparator.comparing(ProtolockField::getId)).orElse(new ProtolockField(0, null)).getId() + 1);
        while (e.getReserveds().stream().anyMatch(s2 -> s2.matchesTag(nextAvailableFieldNum.get())) || lockFields.stream().anyMatch(s2 -> s2.getId() == nextAvailableFieldNum.get())) {
            nextAvailableFieldNum.incrementAndGet();
        }
        return nextAvailableFieldNum;
    }

    private Optional<Field> getField(MessageType e, String intrudingFieldName) {
        return e.fieldsAndOneOfFields().stream().filter(z -> z.name().equals(intrudingFieldName)).findFirst();
    }

    private Optional<Field> getField(MessageType e, Integer intrudingFieldId) {
        return e.fieldsAndOneOfFields().stream().filter(z -> z.tag() == intrudingFieldId.intValue()).findFirst();
    }

    private void reserveField(ProtoFile file, MessageType e, ProtolockField newField) {
        String reservationDoc = "Reservation added by schema2proto";
        Location loc = new Location("", "", 0, 0);
        e.addReserved(reservationDoc, loc, newField.getName());
        e.addReserved(reservationDoc, loc, newField.getId());
        this.LOGGER.warn("Possible backwards incompatibility detected, must be checked manually! Removed field in proto {}, message {}, field {}, blocking field name and id for future use by adding 'reserved' statement", file.name(), e.getName(), newField);
        this.failIfRemovedFieldsTriggered = true;
    }

    public SortedSet<ProtolockField> getFields(ProtolockMessage protolockMessage) {
        if (protolockMessage != null && protolockMessage.getFields() != null) {
            return new TreeSet<ProtolockField>(Arrays.stream(protolockMessage.getFields()).collect(Collectors.toSet()));
        }
        return new TreeSet<ProtolockField>();
    }
}

