/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.OptionReader;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.SyntaxReader;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ProtoParser {
    private final SyntaxReader reader;
    private final Location location;
    private final ImmutableList.Builder<String> publicImports = ImmutableList.builder();
    private final ImmutableList.Builder<String> imports = ImmutableList.builder();
    private final ImmutableList.Builder<TypeElement> nestedTypes = ImmutableList.builder();
    private final ImmutableList.Builder<ServiceElement> services = ImmutableList.builder();
    private final ImmutableList.Builder<ExtendElement> extendsList = ImmutableList.builder();
    private final ImmutableList.Builder<OptionElement> options = ImmutableList.builder();
    private int declarationCount = 0;
    private ProtoFile.Syntax syntax;
    private String packageName;
    private String prefix = "";

    public static ProtoFileElement parse(Location location, String data) {
        return new ProtoParser(location, data.toCharArray()).readProtoFile();
    }

    ProtoParser(Location location, char[] data) {
        this.reader = new SyntaxReader(data, location);
        this.location = location;
    }

    ProtoFileElement readProtoFile() {
        while (true) {
            String documentation = this.reader.readDocumentation();
            if (this.reader.exhausted()) {
                return new ProtoFileElement(this.location, this.packageName, this.syntax, (List<String>)((Object)this.imports.build()), (List<String>)((Object)this.publicImports.build()), (List<? extends TypeElement>)((Object)this.nestedTypes.build()), (List<ServiceElement>)((Object)this.services.build()), (List<ExtendElement>)((Object)this.extendsList.build()), (List<OptionElement>)((Object)this.options.build()));
            }
            Object declaration = this.readDeclaration(documentation, Context.FILE);
            if (declaration instanceof TypeElement) {
                this.nestedTypes.add((Object)((TypeElement)declaration));
                continue;
            }
            if (declaration instanceof ServiceElement) {
                this.services.add((Object)((ServiceElement)declaration));
                continue;
            }
            if (declaration instanceof OptionElement) {
                this.options.add((Object)((OptionElement)declaration));
                continue;
            }
            if (!(declaration instanceof ExtendElement)) continue;
            this.extendsList.add((Object)((ExtendElement)declaration));
        }
    }

    private Object readDeclaration(String documentation, Context context) {
        int index = this.declarationCount++;
        if (this.reader.peekChar(';')) {
            return null;
        }
        Location location = this.reader.location();
        String label = this.reader.readWord();
        if (label.equals("package")) {
            if (!context.permitsPackage()) {
                throw this.reader.unexpected(location, "'package' in " + (Object)((Object)context));
            }
            if (this.packageName != null) {
                throw this.reader.unexpected(location, "too many package names");
            }
            this.packageName = this.reader.readName();
            this.prefix = this.packageName + ".";
            this.reader.require(';');
            return null;
        }
        if (label.equals("import")) {
            if (!context.permitsImport()) {
                throw this.reader.unexpected(location, "'import' in " + (Object)((Object)context));
            }
            String importString = this.reader.readString();
            if ("public".equals(importString)) {
                this.publicImports.add((Object)this.reader.readString());
            } else {
                this.imports.add((Object)importString);
            }
            this.reader.require(';');
            return null;
        }
        if (label.equals("syntax")) {
            if (!context.permitsSyntax()) {
                throw this.reader.unexpected(location, "'syntax' in " + (Object)((Object)context));
            }
            this.reader.require('=');
            if (index != 0) {
                throw this.reader.unexpected(location, "'syntax' element must be the first declaration in a file");
            }
            String syntaxString = this.reader.readQuotedString();
            try {
                this.syntax = ProtoFile.Syntax.get(syntaxString);
            }
            catch (IllegalArgumentException e) {
                throw this.reader.unexpected(location, e.getMessage());
            }
            this.reader.require(';');
            return null;
        }
        if (label.equals("option")) {
            OptionElement result = new OptionReader(this.reader).readOption('=');
            this.reader.require(';');
            return result;
        }
        if (label.equals("reserved")) {
            return this.readReserved(location, documentation);
        }
        if (label.equals("message")) {
            return this.readMessage(location, documentation);
        }
        if (label.equals("enum")) {
            return this.readEnumElement(location, documentation);
        }
        if (label.equals("service")) {
            return this.readService(location, documentation);
        }
        if (label.equals("extend")) {
            return this.readExtend(location, documentation);
        }
        if (label.equals("rpc")) {
            if (!context.permitsRpc()) {
                throw this.reader.unexpected(location, "'rpc' in " + (Object)((Object)context));
            }
            return this.readRpc(location, documentation);
        }
        if (label.equals("oneof")) {
            if (!context.permitsOneOf()) {
                throw this.reader.unexpected(location, "'oneof' must be nested in message");
            }
            return this.readOneOf(documentation);
        }
        if (label.equals("extensions")) {
            if (!context.permitsExtensions()) {
                throw this.reader.unexpected(location, "'extensions' must be nested");
            }
            return this.readExtensions(location, documentation);
        }
        if (context == Context.MESSAGE || context == Context.EXTEND) {
            return this.readField(documentation, location, label);
        }
        if (context == Context.ENUM) {
            return this.readEnumConstant(documentation, location, label);
        }
        throw this.reader.unexpected(location, "unexpected label: " + label);
    }

    private MessageElement readMessage(Location location, String documentation) {
        String name = this.reader.readName();
        String previousPrefix = this.prefix;
        this.prefix = this.prefix + name + ".";
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder oneOfs = ImmutableList.builder();
        ImmutableList.Builder nestedTypes = ImmutableList.builder();
        ImmutableList.Builder extensions = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        ImmutableList.Builder reserveds = ImmutableList.builder();
        ImmutableList.Builder groups2 = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(nestedDocumentation, Context.MESSAGE);
            if (declared instanceof FieldElement) {
                fields.add((FieldElement)declared);
                continue;
            }
            if (declared instanceof OneOfElement) {
                oneOfs.add((OneOfElement)declared);
                continue;
            }
            if (declared instanceof GroupElement) {
                groups2.add((GroupElement)declared);
                continue;
            }
            if (declared instanceof TypeElement) {
                nestedTypes.add((TypeElement)declared);
                continue;
            }
            if (declared instanceof ExtensionsElement) {
                extensions.add((ExtensionsElement)declared);
                continue;
            }
            if (declared instanceof OptionElement) {
                options.add((OptionElement)declared);
                continue;
            }
            if (declared instanceof ExtendElement) {
                this.extendsList.add((Object)((ExtendElement)declared));
                continue;
            }
            if (!(declared instanceof ReservedElement)) continue;
            reserveds.add((ReservedElement)declared);
        }
        this.prefix = previousPrefix;
        return new MessageElement(location, name, documentation, (List<? extends TypeElement>)((Object)nestedTypes.build()), (List<OptionElement>)((Object)options.build()), (List<ReservedElement>)((Object)reserveds.build()), (List<FieldElement>)((Object)fields.build()), (List<OneOfElement>)((Object)oneOfs.build()), (List<ExtensionsElement>)((Object)extensions.build()), (List<GroupElement>)((Object)groups2.build()));
    }

    private ExtendElement readExtend(Location location, String documentation) {
        String name = this.reader.readName();
        this.reader.require('{');
        ImmutableList.Builder fields = ImmutableList.builder();
        while (true) {
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(nestedDocumentation, Context.EXTEND);
            if (!(declared instanceof FieldElement)) continue;
            fields.add((FieldElement)declared);
        }
        return new ExtendElement(location, name, documentation, (List<FieldElement>)((Object)fields.build()));
    }

    private ServiceElement readService(Location location, String documentation) {
        String name = this.reader.readName();
        this.reader.require('{');
        ImmutableList.Builder rpcs = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        while (true) {
            String rpcDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(rpcDocumentation, Context.SERVICE);
            if (declared instanceof RpcElement) {
                rpcs.add((RpcElement)declared);
                continue;
            }
            if (!(declared instanceof OptionElement)) continue;
            options.add((OptionElement)declared);
        }
        return new ServiceElement(location, name, documentation, (List<RpcElement>)((Object)rpcs.build()), (List<OptionElement>)((Object)options.build()));
    }

    private EnumElement readEnumElement(Location location, String documentation) {
        String name = this.reader.readName();
        ImmutableList.Builder constants = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        ImmutableList.Builder reserveds = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String valueDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(valueDocumentation, Context.ENUM);
            if (declared instanceof EnumConstantElement) {
                constants.add((EnumConstantElement)declared);
                continue;
            }
            if (declared instanceof OptionElement) {
                options.add((OptionElement)declared);
                continue;
            }
            if (!(declared instanceof ReservedElement)) continue;
            reserveds.add((ReservedElement)declared);
        }
        return new EnumElement(location, name, documentation, (List<OptionElement>)((Object)options.build()), (List<ReservedElement>)((Object)reserveds.build()), (List<EnumConstantElement>)((Object)constants.build()));
    }

    private Object readField(String documentation, Location location, String word) {
        String type;
        Field.Label label;
        switch (word) {
            case "required": {
                if (this.syntax == ProtoFile.Syntax.PROTO_3) {
                    throw this.reader.unexpected(location, "'required' label forbidden in proto3 field declarations");
                }
                label = Field.Label.REQUIRED;
                type = this.reader.readDataType();
                break;
            }
            case "optional": {
                if (this.syntax == ProtoFile.Syntax.PROTO_3) {
                    throw this.reader.unexpected(location, "'optional' label forbidden in proto3 field declarations");
                }
                label = Field.Label.OPTIONAL;
                type = this.reader.readDataType();
                break;
            }
            case "repeated": {
                label = Field.Label.REPEATED;
                type = this.reader.readDataType();
                break;
            }
            default: {
                if (!(this.syntax == ProtoFile.Syntax.PROTO_3 || word.equals("map") && this.reader.peekChar() == '<')) {
                    throw this.reader.unexpected(location, "unexpected label: " + word);
                }
                label = null;
                type = this.reader.readDataType(word);
            }
        }
        if (type.startsWith("map<") && label != null) {
            throw this.reader.unexpected(location, "'map' type cannot have label");
        }
        if (type.equals("group")) {
            return this.readGroup(location, documentation, label);
        }
        return this.readField(location, documentation, label, type);
    }

    private FieldElement readField(Location location, String documentation, Field.Label label, String type) {
        String name = this.reader.readName();
        this.reader.require('=');
        int tag = this.reader.readInt();
        List<OptionElement> options = new OptionReader(this.reader).readOptions();
        this.reader.require(';');
        options = new ArrayList<OptionElement>(options);
        String defaultValue = this.stripDefault(options);
        documentation = this.reader.tryAppendTrailingDocumentation(documentation);
        return new FieldElement(location, label, type, name, defaultValue, tag, documentation, new ArrayList<OptionElement>(options));
    }

    private String stripDefault(List<OptionElement> options) {
        String result = null;
        Iterator<OptionElement> i = options.iterator();
        while (i.hasNext()) {
            OptionElement option = i.next();
            if (!option.getName().equals("default")) continue;
            i.remove();
            result = String.valueOf(option.getValue());
        }
        return result;
    }

    private OneOfElement readOneOf(String documentation) {
        String name = this.reader.readName();
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder groups2 = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Location location = this.reader.location();
            String type = this.reader.readDataType();
            if (type.equals("group")) {
                groups2.add(this.readGroup(location, nestedDocumentation, null));
                continue;
            }
            fields.add(this.readField(location, nestedDocumentation, null, type));
        }
        return new OneOfElement(name, documentation, (List<FieldElement>)((Object)fields.build()), (List<GroupElement>)((Object)groups2.build()));
    }

    private GroupElement readGroup(Location location, String documentation, Field.Label label) {
        String name = this.reader.readWord();
        this.reader.require('=');
        int tag = this.reader.readInt();
        ImmutableList.Builder fields = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String fieldLabel;
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Location fieldLocation = this.reader.location();
            Object field = this.readField(nestedDocumentation, fieldLocation, fieldLabel = this.reader.readWord());
            if (!(field instanceof FieldElement)) {
                throw this.reader.unexpected("expected field declaration, was " + field);
            }
            fields.add((FieldElement)field);
        }
        return new GroupElement(label, location, name, tag, documentation, (List<FieldElement>)((Object)fields.build()));
    }

    private ReservedElement readReserved(Location location, String documentation) {
        ImmutableList.Builder valuesBuilder;
        block7: {
            char c;
            valuesBuilder = ImmutableList.builder();
            do {
                if ((c = this.reader.peekChar()) == '\"' || c == '\'') {
                    valuesBuilder.add(this.reader.readQuotedString());
                } else {
                    int tagStart = this.reader.readInt();
                    c = this.reader.peekChar();
                    if (c != ',' && c != ';') {
                        if (!this.reader.readWord().equals("to")) {
                            throw this.reader.unexpected("expected ',', ';', or 'to'");
                        }
                        int tagEnd = this.reader.readInt();
                        valuesBuilder.add(Range.closed(tagStart, tagEnd));
                    } else {
                        valuesBuilder.add((Object)tagStart);
                    }
                }
                c = this.reader.readChar();
                if (c == ';') break block7;
            } while (c == ',');
            throw this.reader.unexpected("expected ',' or ';'");
        }
        ImmutableCollection values2 = valuesBuilder.build();
        if (values2.isEmpty()) {
            throw this.reader.unexpected("'reserved' must have at least one field name or tag");
        }
        return new ReservedElement(location, documentation, (List<? extends Object>)((Object)values2));
    }

    private ExtensionsElement readExtensions(Location location, String documentation) {
        int start;
        int end = start = this.reader.readInt();
        if (this.reader.peekChar() != ';') {
            if (!"to".equals(this.reader.readWord())) {
                throw this.reader.unexpected("expected ';' or 'to'");
            }
            String s2 = this.reader.readWord();
            end = s2.equals("max") ? 0x1FFFFFFF : Integer.parseInt(s2);
        }
        this.reader.require(';');
        return new ExtensionsElement(location, documentation, start, end);
    }

    private EnumConstantElement readEnumConstant(String documentation, Location location, String label) {
        this.reader.require('=');
        int tag = this.reader.readInt();
        List<OptionElement> options = new OptionReader(this.reader).readOptions();
        this.reader.require(';');
        documentation = this.reader.tryAppendTrailingDocumentation(documentation);
        return new EnumConstantElement(location, label, tag, documentation, options);
    }

    private RpcElement readRpc(Location location, String documentation) {
        String responseType;
        String requestType;
        String name = this.reader.readName();
        this.reader.require('(');
        boolean requestStreaming = false;
        String word = this.reader.readWord();
        if (word.equals("stream")) {
            requestStreaming = true;
            requestType = this.reader.readDataType();
        } else {
            requestType = this.reader.readDataType(word);
        }
        this.reader.require(')');
        if (!this.reader.readWord().equals("returns")) {
            throw this.reader.unexpected("expected 'returns'");
        }
        this.reader.require('(');
        boolean responseStreaming = false;
        word = this.reader.readWord();
        if (word.equals("stream")) {
            responseStreaming = true;
            responseType = this.reader.readDataType();
        } else {
            responseType = this.reader.readDataType(word);
        }
        this.reader.require(')');
        ImmutableList.Builder options = ImmutableList.builder();
        if (this.reader.peekChar('{')) {
            while (true) {
                String rpcDocumentation = this.reader.readDocumentation();
                if (!this.reader.peekChar('}')) {
                    Object declared = this.readDeclaration(rpcDocumentation, Context.RPC);
                    if (!(declared instanceof OptionElement)) continue;
                    options.add((OptionElement)declared);
                    continue;
                }
                break;
            }
        } else {
            this.reader.require(';');
        }
        return new RpcElement(location, name, documentation, requestType, responseType, requestStreaming, responseStreaming, (List<OptionElement>)((Object)options.build()));
    }

    static enum Context {
        FILE,
        MESSAGE,
        ENUM,
        RPC,
        EXTEND,
        SERVICE;


        public boolean permitsPackage() {
            return this == FILE;
        }

        public boolean permitsSyntax() {
            return this == FILE;
        }

        public boolean permitsImport() {
            return this == FILE;
        }

        public boolean permitsExtensions() {
            return this != FILE;
        }

        public boolean permitsRpc() {
            return this == SERVICE;
        }

        public boolean permitsOneOf() {
            return this == MESSAGE;
        }
    }
}

