/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.NID_RFC2141;
import de.slub.urn.NSS_RFC2141;
import de.slub.urn.NamespaceSpecificString;
import de.slub.urn.RFC;
import de.slub.urn.URNParser;
import de.slub.urn.URNSyntaxError;
import de.slub.urn.URN_2141;
import java.net.URI;

public class RFC2141Parser
implements URNParser<URN_2141> {
    @Override
    public URN_2141 parse(String str) throws URNSyntaxError {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("URN cannot be null or empty");
        }
        String[] parts = str.split(":");
        if (parts.length < 3 || !"urn".equalsIgnoreCase(parts[0])) {
            throw URNSyntaxError.syntaxError(RFC.RFC_2141, String.format("Invalid format `%s` is probably not a URN", str));
        }
        return new URN_2141(new NID_RFC2141(parts[1]), new NSS_RFC2141(str.substring(str.indexOf(parts[1]) + parts[1].length() + 1), NamespaceSpecificString.Encoding.URL_ENCODED));
    }

    @Override
    public URN_2141 parse(URI uri) throws URNSyntaxError {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return this.parse(uri.toASCIIString());
    }
}

