/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.modifyproto;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.OptionReader;
import com.squareup.wire.schema.internal.parser.SyntaxReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import no.entur.schema2proto.InvalidConfigurationException;
import no.entur.schema2proto.compatibility.ProtolockBackwardsCompatibilityChecker;
import no.entur.schema2proto.generateproto.GoPackageNameHelper;
import no.entur.schema2proto.modifyproto.InvalidProtobufException;
import no.entur.schema2proto.modifyproto.ModifyProtoConfigFile;
import no.entur.schema2proto.modifyproto.config.FieldOption;
import no.entur.schema2proto.modifyproto.config.MergeFrom;
import no.entur.schema2proto.modifyproto.config.ModifyProtoConfiguration;
import no.entur.schema2proto.modifyproto.config.NewEnumConstant;
import no.entur.schema2proto.modifyproto.config.NewField;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class ModifyProto {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyProto.class);

    public void modifyProto(File configFile, File basedir) throws IOException, InvalidConfigurationException, InvalidProtobufException {
        ModifyProtoConfiguration configuration = new ModifyProtoConfiguration();
        try (InputStream in = Files.newInputStream(configFile.toPath(), new OpenOption[0]);){
            Constructor constructor = new Constructor(ModifyProtoConfigFile.class);
            TypeDescription customTypeDescription = new TypeDescription(ModifyProtoConfigFile.class);
            customTypeDescription.addPropertyParameters("newFields", NewField.class);
            customTypeDescription.addPropertyParameters("mergeFrom", MergeFrom.class);
            customTypeDescription.addPropertyParameters("valdiationRules", FieldOption.class);
            constructor.addTypeDescription(customTypeDescription);
            Yaml yaml = new Yaml(constructor);
            LOGGER.info("Using configFile {}", (Object)configFile);
            ModifyProtoConfigFile config = (ModifyProtoConfigFile)yaml.load(in);
            if (config.outputDirectory == null) {
                throw new InvalidConfigurationException("No output directory");
            }
            configuration.outputDirectory = new File(basedir, config.outputDirectory);
            configuration.outputDirectory.mkdirs();
            if (config.inputDirectory == null) {
                throw new InvalidConfigurationException("no input directory");
            }
            configuration.inputDirectory = new File(basedir, config.inputDirectory);
            if (config.includes != null) {
                configuration.includes.addAll(config.includes.stream().filter(e -> StringUtils.trimToNull(e) != null).collect(Collectors.toList()));
            }
            if (config.excludes != null) {
                configuration.excludes.addAll(config.excludes.stream().filter(e -> StringUtils.trimToNull(e) != null).collect(Collectors.toList()));
            }
            if (config.mergeFrom != null) {
                configuration.mergeFrom = new ArrayList<MergeFrom>(config.mergeFrom);
            }
            if (config.newFields != null) {
                configuration.newFields = new ArrayList<NewField>(config.newFields);
            }
            if (config.newEnumConstants != null) {
                configuration.newEnumConstants = new ArrayList<NewEnumConstant>(config.newEnumConstants);
            }
            if (config.fieldOptions != null) {
                configuration.fieldOptions = new ArrayList<FieldOption>(config.fieldOptions);
            }
            configuration.includeBaseTypes = config.includeBaseTypes;
            if (config.protoLockFile != null) {
                configuration.protoLockFile = new File(basedir, config.protoLockFile);
            }
            if (config.customImportLocations != null) {
                configuration.customImportLocations = new ArrayList<String>(config.customImportLocations.stream().filter(e -> StringUtils.trimToNull(e) != null).collect(Collectors.toList()));
            }
            configuration.basedir = basedir;
            configuration.includeGoPackageOptions = config.includeGoPackageOptions;
            configuration.goPackageSourcePrefix = config.goPackageSourcePrefix;
            this.modifyProto(configuration);
        }
        catch (Exception e2) {
            LOGGER.error("Error modifying file", e2);
            throw e2;
        }
    }

    public void modifyProto(ModifyProtoConfiguration configuration) throws IOException, InvalidProtobufException, InvalidConfigurationException {
        SchemaLoader schemaLoader = new SchemaLoader();
        Collection<File> protoFiles = FileUtils.listFiles(configuration.inputDirectory, new String[]{"proto"}, true);
        List protosLoaded = protoFiles.stream().map(e -> configuration.inputDirectory.toURI().relativize(e.toURI()).getPath()).collect(Collectors.toList());
        for (String string : configuration.customImportLocations) {
            schemaLoader.addSource(new File(configuration.basedir, string).toPath());
        }
        schemaLoader.addSource(configuration.inputDirectory);
        for (Path path : schemaLoader.sources()) {
            LOGGER.info("Linking proto from path {}", (Object)path);
        }
        for (String string : schemaLoader.protos()) {
            LOGGER.info("Linking proto {}", (Object)string);
        }
        Schema schema = schemaLoader.load();
        IdentifierSet.Builder builder = new IdentifierSet.Builder();
        builder.exclude(configuration.excludes);
        builder.include(configuration.includes);
        IdentifierSet finalIterationIdentifiers = configuration.includeBaseTypes ? this.followOneMoreLevel(builder, schema) : builder.build();
        Schema prunedSchema = schema.prune(finalIterationIdentifiers);
        for (String s3 : finalIterationIdentifiers.unusedExcludes()) {
            LOGGER.warn("Unused exclude: {} (already excluded elsewhere or explicitly included?)", (Object)s3);
        }
        for (String s2 : finalIterationIdentifiers.unusedIncludes()) {
            LOGGER.warn("Unused include: {} (already included elsewhere or explicitly excluded?) ", (Object)s2);
        }
        for (NewField newField : configuration.newFields) {
            this.addField(newField, prunedSchema);
        }
        for (NewEnumConstant newEnumValue : configuration.newEnumConstants) {
            this.addEnumConstant(newEnumValue, prunedSchema);
        }
        for (MergeFrom mergeFrom : configuration.mergeFrom) {
            this.mergeFromFile(mergeFrom, prunedSchema, configuration);
        }
        for (FieldOption fieldOption : configuration.fieldOptions) {
            this.addFieldOption(fieldOption, prunedSchema);
        }
        if (configuration.protoLockFile != null) {
            try {
                ProtolockBackwardsCompatibilityChecker backwardsCompatibilityChecker = new ProtolockBackwardsCompatibilityChecker();
                backwardsCompatibilityChecker.init(configuration.protoLockFile);
                ImmutableList<ProtoFile> files = prunedSchema.protoFiles();
                files.stream().forEach(file -> backwardsCompatibilityChecker.resolveBackwardIncompatibilities((ProtoFile)file));
            }
            catch (FileNotFoundException e2) {
                throw new InvalidConfigurationException("Could not find proto.lock file, check configuration");
            }
        }
        if (configuration.includeGoPackageOptions) {
            this.includeGoPackageNameOptions(prunedSchema.protoFiles(), configuration.goPackageSourcePrefix);
        }
        Set emptyImportLocations = protosLoaded.stream().map(prunedSchema::protoFile).filter(Objects::nonNull).filter(this::isEmptyFile).map(p -> p.location().getPath()).collect(Collectors.toSet());
        protosLoaded.stream().map(prunedSchema::protoFile).filter(Objects::nonNull).filter(p -> !this.isEmptyFile((ProtoFile)p)).forEach(file -> {
            file.imports().removeIf(emptyImportLocations::contains);
            file.publicImports().removeIf(emptyImportLocations::contains);
            File outputFile = new File(configuration.outputDirectory, file.location().getPath());
            outputFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(outputFile);){
                writer.write(file.toSchema());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            LOGGER.info("Wrote file {}", (Object)outputFile.getPath());
        });
    }

    private void includeGoPackageNameOptions(Collection<ProtoFile> protoFiles, String goPackageSourcePrefix) {
        for (ProtoFile protoFile : protoFiles) {
            String optionName = "go_package";
            boolean alreadySet = protoFile.options().getOptionElements().stream().anyMatch(existingOption -> optionName.equals(existingOption.getName()));
            if (alreadySet) continue;
            String goPackageName = GoPackageNameHelper.packageNameToGoPackageName(goPackageSourcePrefix, protoFile.packageName());
            OptionElement optionElement = new OptionElement(optionName, OptionElement.Kind.STRING, goPackageName, false);
            protoFile.options().add(optionElement);
        }
    }

    private boolean isEmptyFile(ProtoFile p) {
        return p.types().isEmpty() && p.getExtendList().isEmpty();
    }

    private IdentifierSet followOneMoreLevel(IdentifierSet.Builder identifierSetBuilder, Schema schema) {
        IdentifierSet identifierSet = identifierSetBuilder.build();
        Schema prunedSchema = schema.prune(identifierSet);
        IdentifierSet.Builder updatedIdentifierSetBuilder = new IdentifierSet.Builder();
        updatedIdentifierSetBuilder.exclude(identifierSet.excludes());
        updatedIdentifierSetBuilder.include(identifierSet.includes());
        for (ProtoFile file : prunedSchema.protoFiles()) {
            for (Type t : file.types()) {
                this.includeBaseType(updatedIdentifierSetBuilder, t, file.packageName());
            }
        }
        IdentifierSet updatedIdentifierSet = updatedIdentifierSetBuilder.build();
        if (!identifierSet.includes().equals(updatedIdentifierSet.includes())) {
            return this.followOneMoreLevel(updatedIdentifierSetBuilder, schema);
        }
        return updatedIdentifierSet;
    }

    private void includeBaseType(IdentifierSet.Builder b, Type type, String enclosingPackage) {
        if (type.options() != null) {
            List baseTypeInherits = type.options().getOptionElements().stream().filter(e -> e.getName().equals("xsd.base_type")).collect(Collectors.toList());
            baseTypeInherits.stream().forEach(e -> {
                String baseTypeValue = (String)e.getValue();
                if (baseTypeValue.contains(".")) {
                    b.include(baseTypeValue);
                } else {
                    String fullType = baseTypeValue;
                    if (enclosingPackage != null) {
                        fullType = enclosingPackage + "." + fullType;
                    }
                    b.include(fullType);
                }
            });
        }
        type.nestedTypes().stream().forEach(e -> this.includeBaseType(b, (Type)e, enclosingPackage));
    }

    private void mergeFromFile(MergeFrom mergeFrom, Schema prunedSchema, ModifyProtoConfiguration configuration) throws IOException {
        SchemaLoader schemaLoader = new SchemaLoader();
        for (String importRootFolder : configuration.customImportLocations) {
            schemaLoader.addSource(new File(configuration.basedir, importRootFolder).toPath());
        }
        if (mergeFrom.sourceFolder.isAbsolute()) {
            schemaLoader.addSource(mergeFrom.sourceFolder);
        } else {
            schemaLoader.addSource(new File(configuration.basedir, mergeFrom.sourceFolder.getPath()));
        }
        if (configuration.inputDirectory.isAbsolute()) {
            schemaLoader.addSource(configuration.inputDirectory);
        } else {
            schemaLoader.addSource(new File(configuration.basedir, configuration.inputDirectory.getPath()));
        }
        schemaLoader.addProto(mergeFrom.protoFile);
        Schema schema = schemaLoader.load();
        ProtoFile source2 = schema.protoFile(mergeFrom.protoFile);
        ProtoFile destination = prunedSchema.protoFileForPackage(source2.packageName());
        if (destination == null) {
            throw new IllegalArgumentException("Destination protofile not found");
        }
        destination.mergeFrom(source2);
    }

    private void addEnumConstant(NewEnumConstant newEnumConstant, Schema prunedSchema) throws InvalidProtobufException {
        EnumType enumType;
        EnumConstant enumConstant;
        Type targetEnumType = prunedSchema.getType(newEnumConstant.targetEnumType);
        if (targetEnumType instanceof EnumType) {
            ArrayList<OptionElement> optionElements = new ArrayList<OptionElement>();
            Options options = new Options(Options.ENUM_VALUE_OPTIONS, optionElements);
            Location location = new Location("", "", -1, -1);
            enumConstant = new EnumConstant(location, newEnumConstant.name, newEnumConstant.fieldNumber, newEnumConstant.documentation, options);
            enumType = (EnumType)targetEnumType;
            Optional<EnumConstant> existing = enumType.constants().stream().filter(e -> e.getName().equals(enumConstant.getName()) || e.getTag() == enumConstant.getTag()).findFirst();
            if (existing.isPresent()) {
                throw new InvalidProtobufException("Enum constant already present: " + newEnumConstant);
            }
        } else {
            throw new InvalidProtobufException("Did not find existing enum " + newEnumConstant.targetEnumType);
        }
        enumType.constants().add(enumConstant);
    }

    private void addField(NewField newField, Schema prunedSchema) throws InvalidProtobufException {
        MessageType type = (MessageType)prunedSchema.getType(newField.targetMessageType);
        if (type == null) {
            throw new InvalidProtobufException("Did not find existing type " + newField.targetMessageType);
        }
        ArrayList<OptionElement> optionElements = new ArrayList<OptionElement>();
        Options options = new Options(Options.FIELD_OPTIONS, optionElements);
        int tag = newField.fieldNumber;
        String fieldPackage = StringUtils.substringBeforeLast(newField.type, ".");
        if (fieldPackage.equals(newField.type)) {
            fieldPackage = null;
        }
        Field.Label label = null;
        if (StringUtils.trimToNull(newField.label) != null) {
            label = Field.Label.valueOf(newField.label.toUpperCase());
        }
        Location location = new Location("", "", -1, -1);
        Field field = new Field(fieldPackage, location, label, newField.name, StringUtils.trimToEmpty(newField.documentation), tag, null, newField.type, options, false, false);
        ArrayList<Field> updatedFields = new ArrayList<Field>(type.fields());
        updatedFields.add(field);
        type.setDeclaredFields(updatedFields);
        String importStatement = StringUtils.trimToNull(newField.importProto);
        if (importStatement != null) {
            String targetPackageName = StringUtils.trimToNull(StringUtils.substringBeforeLast(newField.targetMessageType, "."));
            ProtoFile targetFile = prunedSchema.protoFileForPackage(targetPackageName);
            if (newField.targetMessageType.equals(targetPackageName)) {
                targetFile = prunedSchema.protoFileForPackage(null);
            }
            targetFile.imports().add(importStatement);
        }
    }

    public void addFieldOption(FieldOption fieldOption, Schema prunedSchema) throws InvalidProtobufException {
        MessageType type = (MessageType)prunedSchema.getType(fieldOption.targetMessageType);
        if (type == null) {
            throw new InvalidProtobufException("Did not find existing type " + fieldOption.targetMessageType);
        }
        Field field = type.field(fieldOption.field);
        if (field == null) {
            throw new InvalidProtobufException("Did not find existing field " + fieldOption.field);
        }
        if (StringUtils.isEmpty(fieldOption.option)) {
            throw new InvalidProtobufException("Missing option for field " + fieldOption.field);
        }
        OptionReader reader = new OptionReader(new SyntaxReader(fieldOption.option.toCharArray(), null));
        reader.readOptions().forEach(option -> field.options().add((OptionElement)option));
    }
}

