/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.NID_RFC8141;
import de.slub.urn.NSS_RFC8141;
import de.slub.urn.NamespaceSpecificString;
import de.slub.urn.RFC;
import de.slub.urn.RQF_RFC8141;
import de.slub.urn.URNParser;
import de.slub.urn.URNSyntaxError;
import de.slub.urn.URN_8141;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class RFC8141Parser
implements URNParser<URN_8141> {
    @Override
    public URN_8141 parse(String urnLiteral) throws URNSyntaxError {
        if (urnLiteral == null || urnLiteral.isEmpty()) {
            throw new IllegalArgumentException("URN cannot be null or empty");
        }
        String[] parts = urnLiteral.split(":");
        if (parts.length < 3 || !"urn".equalsIgnoreCase(parts[0])) {
            throw URNSyntaxError.syntaxError(RFC.RFC_8141, String.format("Invalid format `%s` is probably not a URN", urnLiteral));
        }
        NID_RFC8141 nid = new NID_RFC8141(parts[1]);
        String schemeSpecificPart = urnLiteral.substring(urnLiteral.indexOf(parts[1]) + parts[1].length() + 1);
        String nssString = this.substringUntilAny(schemeSpecificPart, "?+", "?=", "#");
        NSS_RFC8141 nss = new NSS_RFC8141(nssString, NamespaceSpecificString.Encoding.URL_ENCODED);
        String rqfComponentsString = schemeSpecificPart.substring(nssString.length());
        RQF_RFC8141 rqfComponents = this.parseRQFComponents(rqfComponentsString);
        return new URN_8141(nid, nss, rqfComponents);
    }

    @Override
    public URN_8141 parse(URI uri) throws URNSyntaxError {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return this.parse(uri.toASCIIString());
    }

    private RQF_RFC8141 parseRQFComponents(String rqfComponents) {
        String rComponent = this.substringUntilAny(this.substringFrom(rqfComponents, "?+"), "?=", "#");
        String qComponent = this.substringUntilAny(this.substringFrom(rqfComponents, "?="), "#");
        String fComponent = this.substringFrom(rqfComponents, "#");
        return new RQF_RFC8141(this.parseParameters(rComponent), this.parseParameters(qComponent), fComponent);
    }

    private String substringFrom(String str, String startDelimiter) {
        int startIndex = str.indexOf(startDelimiter);
        if (startIndex < 0) {
            return "";
        }
        return str.substring(startIndex + startDelimiter.length());
    }

    private String substringUntilAny(String str, String ... endDelimiters) {
        int endIndex = str.length();
        for (String endDelimiter : endDelimiters) {
            int currentEnd = str.indexOf(endDelimiter);
            if (currentEnd < 0 || currentEnd >= endIndex) continue;
            endIndex = currentEnd;
        }
        return str.substring(0, endIndex);
    }

    private Map<String, String> parseParameters(String component) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (!component.isEmpty()) {
            for (String rComponent : component.split("&")) {
                String[] kv = rComponent.split("=");
                String key = kv[0];
                String val = kv.length == 2 ? kv[1] : "";
                parameters.put(key, val);
            }
        }
        return parameters;
    }
}

