/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.SyntaxReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J,\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0014J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/squareup/wire/schema/internal/parser/OptionReader;", "", "reader", "Lcom/squareup/wire/schema/internal/parser/SyntaxReader;", "(Lcom/squareup/wire/schema/internal/parser/SyntaxReader;)V", "getReader$schema2proto_wire", "()Lcom/squareup/wire/schema/internal/parser/SyntaxReader;", "addToList", "", "list", "", "value", "readKindAndValue", "Lcom/squareup/wire/schema/internal/parser/OptionReader$KindAndValue;", "readList", "", "readMap", "", "", "openBrace", "", "closeBrace", "keyValueSeparator", "readOption", "Lcom/squareup/wire/schema/internal/parser/OptionElement;", "readOptions", "KindAndValue", "schema2proto-wire"})
public final class OptionReader {
    @NotNull
    private final SyntaxReader reader;

    public OptionReader(@NotNull SyntaxReader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.reader = reader;
    }

    @NotNull
    public final SyntaxReader getReader$schema2proto_wire() {
        return this.reader;
    }

    @NotNull
    public final List<OptionElement> readOptions() {
        List result;
        block2: {
            Object object;
            if (!this.reader.peekChar('[')) {
                return CollectionsKt.emptyList();
            }
            boolean bl = false;
            result = new ArrayList();
            do {
                object = result;
                OptionElement optionElement = this.readOption('=');
                boolean bl2 = false;
                object.add(optionElement);
                if (this.reader.peekChar(']')) break block2;
            } while (this.reader.peekChar(','));
            object = this.reader.unexpected("Expected ',' or ']");
            Intrinsics.checkNotNullExpressionValue(object, "reader.unexpected(\"Expected ',' or ']\")");
            throw (Throwable)object;
        }
        return result;
    }

    @NotNull
    public final OptionElement readOption(char keyValueSeparator) {
        boolean isExtension = this.reader.peekChar() == '[';
        boolean isParenthesized = this.reader.peekChar() == '(';
        String name = this.reader.readName();
        if (isExtension) {
            name = '[' + name + ']';
        }
        String subName = null;
        char c = this.reader.readChar();
        if (c == '.') {
            subName = this.reader.readName();
            c = this.reader.readChar();
        }
        if (keyValueSeparator == ':' && c == '{') {
            this.reader.pushBack('{');
        } else if (c != keyValueSeparator) {
            RuntimeException runtimeException = this.reader.unexpected("expected '" + keyValueSeparator + "' in option");
            Intrinsics.checkNotNullExpressionValue(runtimeException, "reader.unexpected(\"expected '$keyValueSeparator' in option\")");
            throw (Throwable)runtimeException;
        }
        KindAndValue kindAndValue = this.readKindAndValue();
        OptionElement.Kind kind = kindAndValue.getKind$schema2proto_wire();
        Object value = kindAndValue.getValue$schema2proto_wire();
        if (subName != null) {
            value = OptionElement.Companion.create$default(OptionElement.Companion, subName, kind, value, false, 8, null);
            kind = OptionElement.Kind.OPTION;
        }
        String string = name;
        Intrinsics.checkNotNullExpressionValue(string, "name");
        return OptionElement.Companion.create(string, kind, value, isParenthesized);
    }

    private final KindAndValue readKindAndValue() {
        KindAndValue kindAndValue;
        char peeked = this.reader.peekChar();
        char c = peeked;
        if (c == '{') {
            return new KindAndValue(OptionElement.Kind.MAP, this.readMap('{', '}', ':'));
        }
        if (c == '[') {
            return new KindAndValue(OptionElement.Kind.LIST, this.readList());
        }
        if (c == '\"' ? true : c == '\'') {
            String string = this.reader.readString();
            Intrinsics.checkNotNullExpressionValue(string, "reader.readString()");
            return new KindAndValue(OptionElement.Kind.STRING, string);
        }
        if (Character.isDigit(peeked) || peeked == '-') {
            BigDecimal bigDecimal = this.reader.readBigDecimal();
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "reader.readBigDecimal()");
            return new KindAndValue(OptionElement.Kind.NUMBER, bigDecimal);
        }
        String word = this.reader.readWord();
        String string = word;
        if (Intrinsics.areEqual(string, "true")) {
            kindAndValue = new KindAndValue(OptionElement.Kind.BOOLEAN, true);
        } else if (Intrinsics.areEqual(string, "false")) {
            kindAndValue = new KindAndValue(OptionElement.Kind.BOOLEAN, false);
        } else {
            Intrinsics.checkNotNullExpressionValue(word, "word");
            kindAndValue = new KindAndValue(OptionElement.Kind.ENUM, word);
        }
        return kindAndValue;
    }

    private final Map<String, Object> readMap(char openBrace, char closeBrace, char keyValueSeparator) {
        if (this.reader.readChar() != openBrace) {
            throw new AssertionError();
        }
        boolean bl = false;
        Map result = new LinkedHashMap();
        while (!this.reader.peekChar(closeBrace)) {
            boolean bl2;
            Object object;
            Object object2;
            Object object3;
            OptionElement option = this.readOption(keyValueSeparator);
            String name = option.getName();
            Object value = option.getValue();
            if (value instanceof OptionElement) {
                Map nested;
                object3 = result.get(name);
                Map map = nested = TypeIntrinsics.isMutableMap(object3) ? (Map)object3 : null;
                if (nested == null) {
                    nested = new LinkedHashMap();
                    object3 = result;
                    boolean bl3 = false;
                    object3.put((String)name, (Map)nested);
                }
                object3 = nested;
                object2 = ((OptionElement)value).getName();
                object = ((OptionElement)value).getValue();
                bl2 = false;
                object3.put(object2, object);
            } else {
                Object previous = result.get(name);
                object3 = previous;
                if (object3 == null) {
                    object2 = result;
                    boolean bl4 = false;
                    object2.put(name, value);
                } else if (object3 instanceof List) {
                    if (previous == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
                    }
                    this.addToList(TypeIntrinsics.asMutableList(previous), value);
                } else {
                    ArrayList newList = new ArrayList();
                    newList.add(previous);
                    this.addToList(newList, value);
                    object = result;
                    bl2 = false;
                    object.put(name, newList);
                }
            }
            this.reader.peekChar(',');
        }
        return result;
    }

    private final void addToList(List<Object> list, Object value) {
        if (value instanceof List) {
            list.addAll((Collection)value);
        } else {
            list.add(value);
        }
    }

    private final List<Object> readList() {
        this.reader.require('[');
        boolean bl = false;
        List result = new ArrayList();
        do {
            if (this.reader.peekChar(']')) {
                return result;
            }
            result.add(this.readKindAndValue().getValue$schema2proto_wire());
        } while (this.reader.peekChar(',') || this.reader.peekChar() == ']');
        RuntimeException runtimeException = this.reader.unexpected("expected ',' or ']'");
        Intrinsics.checkNotNullExpressionValue(runtimeException, "reader.unexpected(\"expected ',' or ']'\")");
        throw (Throwable)runtimeException;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000bJ\u000e\u0010\f\u001a\u00020\u0001H\u00c0\u0003\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/squareup/wire/schema/internal/parser/OptionReader$KindAndValue;", "", "kind", "Lcom/squareup/wire/schema/internal/parser/OptionElement$Kind;", "value", "(Lcom/squareup/wire/schema/internal/parser/OptionElement$Kind;Ljava/lang/Object;)V", "getKind$schema2proto_wire", "()Lcom/squareup/wire/schema/internal/parser/OptionElement$Kind;", "getValue$schema2proto_wire", "()Ljava/lang/Object;", "component1", "component1$schema2proto_wire", "component2", "component2$schema2proto_wire", "copy", "equals", "", "other", "hashCode", "", "toString", "", "schema2proto-wire"})
    public static final class KindAndValue {
        @NotNull
        private final OptionElement.Kind kind;
        @NotNull
        private final Object value;

        public KindAndValue(@NotNull OptionElement.Kind kind, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(value, "value");
            this.kind = kind;
            this.value = value;
        }

        @NotNull
        public final OptionElement.Kind getKind$schema2proto_wire() {
            return this.kind;
        }

        @NotNull
        public final Object getValue$schema2proto_wire() {
            return this.value;
        }

        @NotNull
        public final OptionElement.Kind component1$schema2proto_wire() {
            return this.kind;
        }

        @NotNull
        public final Object component2$schema2proto_wire() {
            return this.value;
        }

        @NotNull
        public final KindAndValue copy(@NotNull OptionElement.Kind kind, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(value, "value");
            return new KindAndValue(kind, value);
        }

        public static /* synthetic */ KindAndValue copy$default(KindAndValue kindAndValue, OptionElement.Kind kind, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                kind = kindAndValue.kind;
            }
            if ((n & 2) != 0) {
                object = kindAndValue.value;
            }
            return kindAndValue.copy(kind, object);
        }

        @NotNull
        public String toString() {
            return "KindAndValue(kind=" + (Object)((Object)this.kind) + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result = this.kind.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KindAndValue)) {
                return false;
            }
            KindAndValue kindAndValue = (KindAndValue)other;
            if (this.kind != kindAndValue.kind) {
                return false;
            }
            return Intrinsics.areEqual(this.value, kindAndValue.value);
        }
    }
}

