/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.compatibility;

import com.google.common.collect.BiMap;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import no.entur.schema2proto.compatibility.ConflictResolverHelper;
import no.entur.schema2proto.compatibility.protolock.ProtolockField;
import no.entur.schema2proto.compatibility.protolock.ProtolockMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConflictChecker {
    private final Logger LOGGER = LoggerFactory.getLogger(FieldConflictChecker.class);
    private boolean failIfRemovedFieldsTriggered;

    public boolean tryResolveFieldConflicts(ProtoFile file, MessageType protoMessage, ProtolockMessage protolockMessage) {
        SortedSet<ProtolockField> lockFields = Collections.unmodifiableSortedSet(this.getFields(protolockMessage));
        BiMap<String, Integer> lockFieldsInLockMapNameToId = ConflictResolverHelper.createBiMap(lockFields);
        BiMap<Integer, String> lockFieldsInLockMapIdToName = lockFieldsInLockMapNameToId.inverse();
        boolean allConflictsResolved = false;
        block0: while (!allConflictsResolved) {
            SortedSet<ProtolockField> xsdFields2 = Collections.unmodifiableSortedSet(new TreeSet(protoMessage.fieldsAndOneOfFields().stream().map(f -> new ProtolockField(f.tag(), f.name())).collect(Collectors.toSet())));
            allConflictsResolved = true;
            for (ProtolockField xsdField : xsdFields2) {
                if (lockFields.contains(xsdField) || !lockFieldsInLockMapIdToName.containsKey(xsdField.getId()) && !lockFieldsInLockMapNameToId.containsKey(xsdField.getName()) && !this.isReserved(protolockMessage, xsdField)) continue;
                Integer originalIdForField = (Integer)lockFieldsInLockMapNameToId.get(xsdField.getName());
                if (originalIdForField == null) {
                    originalIdForField = this.findNextAvailableFieldNum(protoMessage, xsdFields2, lockFields).get();
                }
                Optional<Field> intrudingField = this.getField(protoMessage, xsdField.getName());
                intrudingField.get().updateTag(originalIdForField);
                allConflictsResolved = false;
                continue block0;
            }
        }
        SortedSet xsdFields = Collections.unmodifiableSortedSet(new TreeSet(protoMessage.fieldsAndOneOfFields().stream().map(f -> new ProtolockField(f.tag(), f.name())).collect(Collectors.toSet())));
        TreeSet newFieldsInXsd = new TreeSet(xsdFields);
        newFieldsInXsd.removeAll(lockFields);
        TreeSet<ProtolockField> surplusLockFields = new TreeSet<ProtolockField>(lockFields);
        surplusLockFields.removeAll(xsdFields);
        if (!surplusLockFields.isEmpty()) {
            surplusLockFields.stream().forEach(newField -> this.reserveField(file, protoMessage, (ProtolockField)newField));
            this.failIfRemovedFieldsTriggered = true;
        }
        return this.failIfRemovedFieldsTriggered;
    }

    private void updateFieldTag(AtomicInteger nextAvailableFieldNum, int overlappingId, Optional<Field> intrudingField, Optional<Field> existingField, Integer idFromLockFile) {
        intrudingField.ifPresent(x -> {
            if (idFromLockFile != null) {
                x.updateTag(idFromLockFile);
            } else {
                x.updateTag(nextAvailableFieldNum.get());
            }
        });
        existingField.ifPresent(x -> x.updateTag(overlappingId));
    }

    @NotNull
    private AtomicInteger findNextAvailableFieldNum(MessageType e, SortedSet<ProtolockField> xsdFields, SortedSet<ProtolockField> lockFields) {
        AtomicInteger nextAvailableFieldNum = new AtomicInteger(xsdFields.stream().max(Comparator.comparing(ProtolockField::getId)).orElse(new ProtolockField(0, null)).getId() + 1);
        while (e.getReserveds().stream().anyMatch(s2 -> s2.matchesTag(nextAvailableFieldNum.get())) || lockFields.stream().anyMatch(s2 -> s2.getId() == nextAvailableFieldNum.get())) {
            nextAvailableFieldNum.incrementAndGet();
        }
        return nextAvailableFieldNum;
    }

    private boolean isReserved(ProtolockMessage protolockMessage, ProtolockField field) {
        boolean reserved = false;
        if (protolockMessage.getReservedIds() != null) {
            reserved |= Arrays.stream(protolockMessage.getReservedIds()).anyMatch(e -> e.intValue() == field.getId());
        }
        if (protolockMessage.getReservedNames() != null) {
            reserved |= Arrays.stream(protolockMessage.getReservedNames()).anyMatch(e -> e.equals(field.getName()));
        }
        return reserved;
    }

    private Optional<Field> getField(MessageType e, String fieldName) {
        return e.fieldsAndOneOfFields().stream().filter(z -> z.name().equals(fieldName)).findFirst();
    }

    private Optional<Field> getField(MessageType e, Integer fieldId) {
        return e.fieldsAndOneOfFields().stream().filter(z -> z.tag() == fieldId.intValue()).findFirst();
    }

    private void reserveField(ProtoFile file, MessageType e, ProtolockField newField) {
        String reservationDoc = "Reservation added by schema2proto";
        Location loc = new Location("", "", 0, 0);
        e.addReserved(reservationDoc, loc, newField.getName());
        e.addReserved(reservationDoc, loc, newField.getId());
        this.LOGGER.warn("Possible backwards incompatibility detected, must be checked manually! Removed field in proto {}, message {}, field {}, blocking field name and id for future use by adding 'reserved' statement", file.name(), e.getName(), newField);
    }

    public SortedSet<ProtolockField> getFields(ProtolockMessage protolockMessage) {
        if (protolockMessage != null && protolockMessage.getFields() != null) {
            return new TreeSet<ProtolockField>(Arrays.stream(protolockMessage.getFields()).collect(Collectors.toSet()));
        }
        return new TreeSet<ProtolockField>();
    }
}

