/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.NamespaceSpecificString;
import de.slub.urn.RFC;
import de.slub.urn.URNSyntaxError;
import java.util.regex.Pattern;

public final class NSS_RFC8141
extends NamespaceSpecificString {
    private static final String unreserved = "[a-z0-9-._~]";
    private static final String pctencoded = "%[a-f0-9]{2}";
    private static final String subdelims = "[!$&'()*+,;=]";
    private static final String pchar = "[a-z0-9-._~]|%[a-f0-9]{2}|[!$&'()*+,;=]|:|@";
    private static final Pattern allowedCharacters = Pattern.compile(String.format("^(%s)(%s|/|\\?)*$", "[a-z0-9-._~]|%[a-f0-9]{2}|[!$&'()*+,;=]|:|@", "[a-z0-9-._~]|%[a-f0-9]{2}|[!$&'()*+,;=]|:|@"), 2);

    public NSS_RFC8141(String nss, NamespaceSpecificString.Encoding encoding) throws URNSyntaxError {
        super(nss, encoding);
    }

    public NSS_RFC8141(NamespaceSpecificString instanceForCopying) {
        super(instanceForCopying);
    }

    @Override
    protected boolean isValidURLEncodedNamespaceSpecificString(String encoded) {
        return allowedCharacters.matcher(encoded).matches();
    }

    @Override
    public RFC supportedRFC() {
        return RFC.RFC_8141;
    }
}

