/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.SAXParserFactory;
import no.entur.schema2proto.generateproto.ConversionException;
import no.entur.schema2proto.generateproto.LocalType;
import no.entur.schema2proto.generateproto.NamespaceHelper;
import no.entur.schema2proto.generateproto.PGVRuleFactory;
import no.entur.schema2proto.generateproto.Schema2ProtoConfiguration;
import no.entur.schema2proto.generateproto.TypeRegistry;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaParser
implements ErrorHandler {
    public static final String TYPE_SUFFIX = "Type";
    public static final String GENERATED_NAME_PLACEHOLDER = "GeneratedTypePlaceholder";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaParser.class);
    private static final String DEFAULT_PROTO_PRIMITIVE = "string";
    private static final String SIMPLECONTENT_VALUE_DEFAULT_DOCUMENTATION = "SimpleContent value of element";
    public static final String VALUE = "value";
    private final Map<String, ProtoFile> packageToProtoFileMap = new TreeMap<String, ProtoFile>();
    private final Map<MessageType, Set<Object>> elementDeclarationsPerMessageType = new HashMap<MessageType, Set<Object>>();
    private Set<String> basicTypes;
    private int nestingLevel = 0;
    private final List<LocalType> localTypes = new ArrayList<LocalType>();
    private final Schema2ProtoConfiguration configuration;
    private PGVRuleFactory ruleFactory;

    private void init() {
        this.basicTypes = new TreeSet<String>();
        this.basicTypes.addAll(TypeRegistry.getBasicTypes());
        this.ruleFactory = new PGVRuleFactory(this.configuration, this);
    }

    public SchemaParser(Schema2ProtoConfiguration configuration) {
        this.configuration = configuration;
        this.init();
    }

    public Map<String, ProtoFile> parse() throws SAXException, IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        XSOMParser parser = new XSOMParser(saxParserFactory);
        parser.setErrorHandler(this);
        parser.setAnnotationParser(new DomAnnotationParserFactory());
        parser.parse(this.configuration.xsdFile);
        this.processSchemaSet(parser.getResult());
        return this.packageToProtoFileMap;
    }

    private void addType(String namespace, Type type) {
        ProtoFile file = this.getProtoFileForNamespace(namespace);
        file.types().add(type);
    }

    private ProtoFile getProtoFileForPackage(String packageName) {
        if (StringUtils.trimToNull(packageName) == null) {
            packageName = "default";
        }
        if (this.configuration.defaultProtoPackage != null) {
            packageName = this.configuration.defaultProtoPackage;
        }
        return this.packageToProtoFileMap.computeIfAbsent(packageName, k -> new ProtoFile(ProtoFile.Syntax.PROTO_3, (String)k));
    }

    private ProtoFile getProtoFileForNamespace(String namespace) {
        String packageName = NamespaceHelper.xmlNamespaceToProtoPackage(namespace, this.configuration.forceProtoPackage);
        return this.getProtoFileForPackage(packageName);
    }

    private Type getType(String namespace, String typeName) {
        ProtoFile protoFileForNamespace = this.getProtoFileForNamespace(namespace);
        for (Type type : protoFileForNamespace.types()) {
            if (!(type instanceof MessageType ? ((MessageType)type).getName().equals(typeName) : type instanceof EnumType && ((EnumType)type).name().equals(typeName))) continue;
            return type;
        }
        return null;
    }

    private void processSchemaSet(XSSchemaSet schemaSet) {
        Iterator<XSSchema> schemas = schemaSet.iterateSchema();
        while (schemas.hasNext()) {
            XSSchema schema = schemas.next();
            if (schema.getTargetNamespace().endsWith("/XMLSchema")) continue;
            TreeMap<String, XSSimpleType> sortedSimpleTypes = new TreeMap<String, XSSimpleType>(schema.getSimpleTypes());
            sortedSimpleTypes.forEach((name, type) -> this.processSimpleType((XSSimpleType)type, null));
            TreeMap<String, XSComplexType> sortedComplexTypes = new TreeMap<String, XSComplexType>(schema.getComplexTypes());
            sortedComplexTypes.forEach((name, type) -> this.processComplexType((XSComplexType)type, null, schemaSet, null, null));
            TreeMap<String, XSElementDecl> sortedElements = new TreeMap<String, XSElementDecl>(schema.getElementDecls());
            for (XSElementDecl elementDecl : sortedElements.values()) {
                if (elementDecl.getType().isLocal()) {
                    this.processElement(elementDecl, schemaSet);
                    continue;
                }
                LOGGER.debug("Skipping global element {} declaration with global type {}", (Object)elementDecl.getName(), (Object)elementDecl.getType().getName());
            }
        }
    }

    private String processElement(XSElementDecl element, XSSchemaSet schemaSet) {
        if (element.getType() instanceof XSComplexType && element.getType() != schemaSet.getAnyType()) {
            XSComplexType cType = (XSComplexType)element.getType();
            MessageType t = this.processComplexType(cType, element.getName(), schemaSet, null, null);
            if (cType.isGlobal()) {
                this.addType(element.getTargetNamespace(), t);
            }
            return t.getName();
        }
        if (element.getType() instanceof XSSimpleType && element.getType() != schemaSet.getAnySimpleType()) {
            XSSimpleType xs = element.getType().asSimpleType();
            return this.processSimpleType(xs, element.getName());
        }
        LOGGER.info("Unhandled element {} at {} location {}/{}", element, element.getLocator().getSystemId(), element.getLocator().getLineNumber(), element.getLocator().getColumnNumber());
        return null;
    }

    private String processSimpleType(XSSimpleType xs, String elementName) {
        ++this.nestingLevel;
        LOGGER.debug("{} SimpleType {}", (Object)StringUtils.leftPad(" ", this.nestingLevel), (Object)xs);
        String typeName = xs.getName();
        if (typeName == null) {
            typeName = elementName + GENERATED_NAME_PLACEHOLDER;
        }
        if (xs.isRestriction()) {
            if (xs.getFacet("enumeration") != null) {
                this.createEnum(typeName, xs.asRestriction(), null);
            } else if (xs.getFacet("whiteSpace") != null && !this.basicTypes.contains(typeName)) {
                --this.nestingLevel;
                return this.findFieldType(xs.getSimpleBaseType());
            }
        } else if (xs.isList()) {
            --this.nestingLevel;
            return this.processSimpleType(xs.asList().getItemType(), null);
        }
        --this.nestingLevel;
        return typeName;
    }

    private void addField(MessageType message, Field newField) {
        this.addField(message, null, newField);
    }

    private void addField(MessageType message, OneOf oneOf, Field newField) {
        Field existingField = null;
        for (Field f : message.fieldsAndOneOfFields()) {
            if (!newField.name().equals(f.name())) continue;
            existingField = f;
            break;
        }
        if (existingField != null) {
            if (existingField.isFromAttribute() && !newField.isFromAttribute()) {
                existingField.updateName("attr_" + existingField.name());
            } else if (!existingField.isFromAttribute() && newField.isFromAttribute()) {
                newField.updateName("attr_" + newField.name());
            } else {
                message.removeDeclaredField(existingField);
            }
        }
        if (oneOf != null) {
            oneOf.addField(newField);
        } else {
            message.addField(newField);
        }
    }

    private MessageType createWrapper(String typeName, MessageType messageType, String wrapperFieldName, String targetNamespace, XSParticle particle2, String fieldDoc, Location location, XSComplexType parentType, String wrapperDoc) {
        ArrayList<OptionElement> messageOptions = new ArrayList<OptionElement>();
        Options options = new Options(Options.MESSAGE_OPTIONS, messageOptions);
        MessageType wrapperType = new MessageType(ProtoType.get(typeName), location, wrapperDoc, typeName, options);
        wrapperType.setWrapperMessageType(true);
        messageType.nestedTypes().add(wrapperType);
        Options fieldOptions = this.getFieldOptions(particle2);
        String fieldPackagename = NamespaceHelper.xmlNamespaceToProtoFieldPackagename(targetNamespace, this.configuration.forceProtoPackage);
        Field field = new Field(fieldPackagename, location, Field.Label.REPEATED, wrapperFieldName, fieldDoc, messageType.getNextFieldNum(), typeName, fieldOptions, false);
        this.addField(messageType, field);
        this.localTypes.add(new LocalType(particle2, wrapperType, messageType, field, NamespaceHelper.xmlNamespaceToProtoPackage(targetNamespace, this.configuration.forceProtoPackage), parentType));
        return wrapperType;
    }

    private void navigateSubTypes(XSParticle parentParticle, MessageType messageType, Set<Object> processedXmlObjects, XSSchemaSet schemaSet, String enclosingName, String targetNamespace, XSComplexType enclosingType) {
        XSTerm currTerm = parentParticle.getTerm();
        Field.Label label = this.getLabel(parentParticle, currTerm);
        Options fieldOptions = this.getFieldOptions(parentParticle);
        if (currTerm.isElementDecl()) {
            XSElementDecl currElementDecl = currTerm.asElementDecl();
            if (!processedXmlObjects.contains(currElementDecl)) {
                processedXmlObjects.add(currElementDecl);
                XSType type = currElementDecl.getType();
                String fieldDoc = this.resolveDocumentationAnnotation(currElementDecl);
                Location fieldLocation = this.getLocation(currElementDecl);
                String packageName = NamespaceHelper.xmlNamespaceToProtoFieldPackagename(type.getTargetNamespace(), this.configuration.forceProtoPackage);
                if (type.isSimpleType()) {
                    if (type.asSimpleType().isRestriction() && type.asSimpleType().getFacet("enumeration") != null) {
                        String enumName = this.createEnum(currElementDecl.getName(), type.asSimpleType().asRestriction(), type.isGlobal() ? null : messageType);
                        Field field = new Field(packageName, fieldLocation, label, currElementDecl.getName(), fieldDoc, messageType.getNextFieldNum(), enumName, fieldOptions, true);
                        this.addField(messageType, field);
                    } else {
                        String typeName = this.findFieldType(type);
                        Field field = new Field(this.basicTypes.contains(typeName) ? null : packageName, fieldLocation, label, currElementDecl.getName(), fieldDoc, messageType.getNextFieldNum(), typeName, fieldOptions, true);
                        this.addField(messageType, field);
                    }
                } else if (type.isGlobal()) {
                    Set<? extends XSElementDecl> substitutables = currElementDecl.getSubstitutables();
                    LinkedHashSet<XSElementDecl> subsumptionSubstitutables = new LinkedHashSet<XSElementDecl>();
                    if (this.configuration.derivationBySubsumption && type.isComplexType() && type.asComplexType().isAbstract()) {
                        this.findGlobalElementsBySubsumption(schemaSet, subsumptionSubstitutables, (XSComplexType)type);
                    }
                    if (substitutables.size() <= 1 && subsumptionSubstitutables.isEmpty()) {
                        Field field = new Field(packageName, fieldLocation, label, currElementDecl.getName(), fieldDoc, messageType.getNextFieldNum(), type.getName(), fieldOptions, true);
                        this.addField(messageType, field);
                    } else {
                        if (label == Field.Label.REPEATED) {
                            String wrapperName = this.createWrapperName(messageType, XSModelGroup.Compositor.CHOICE, enclosingName, (XSComplexType)type);
                            LOGGER.debug("Repeated element with multiple subs, created wrapper name {} from {}", (Object)wrapperName, (Object)enclosingName);
                            messageType = this.createWrapper(wrapperName, messageType, currElementDecl.getName(), type.getTargetNamespace(), parentParticle, fieldDoc, fieldLocation, (XSComplexType)type, "Generated wrapper for repeated oneOfs");
                        }
                        String oneOfName = currElementDecl.getType().getName();
                        if (substitutables.size() == 1 && substitutables.iterator().next() == currElementDecl && !subsumptionSubstitutables.isEmpty()) {
                            oneOfName = currElementDecl.getName();
                        }
                        ArrayList<Field> fields = new ArrayList<Field>();
                        OneOf oneOf = new OneOf(oneOfName, fieldDoc, fields, null);
                        messageType.oneOfs().add(oneOf);
                        LinkedHashSet<? extends XSElementDecl> allSubtitutables = new LinkedHashSet<XSElementDecl>();
                        allSubtitutables.addAll(substitutables);
                        allSubtitutables.addAll(subsumptionSubstitutables);
                        for (XSElementDecl xSElementDecl : allSubtitutables) {
                            if (xSElementDecl.isAbstract() || xSElementDecl.getType().isComplexType() && xSElementDecl.getType().asComplexType().isAbstract()) continue;
                            this.addOneOfField(messageType, schemaSet, fieldOptions, fieldLocation, oneOf, xSElementDecl);
                        }
                    }
                } else {
                    MessageType referencedMessageType = this.processComplexType(type.asComplexType(), currElementDecl.getName(), schemaSet, null, null);
                    Field field = new Field(packageName, fieldLocation, label, currElementDecl.getName(), fieldDoc, messageType.getNextFieldNum(), referencedMessageType.getName(), fieldOptions, true);
                    this.addField(messageType, field);
                    if (!currElementDecl.isGlobal()) {
                        messageType.nestedTypes().add(referencedMessageType);
                        this.localTypes.add(new LocalType(type, referencedMessageType, messageType, field, NamespaceHelper.xmlNamespaceToProtoPackage(type.getTargetNamespace(), this.configuration.forceProtoPackage), enclosingType));
                    }
                }
            }
        } else if (currTerm.isWildcard()) {
            Location fieldLocation = currTerm.getLocator() != null ? this.getLocation(currTerm.asWildcard()) : messageType.location();
            Field field = new Field(null, fieldLocation, label, "any", this.resolveDocumentationAnnotation(currTerm.asWildcard()), messageType.getNextFieldNum(), "anyType", fieldOptions, true);
            this.addField(messageType, field);
        } else {
            XSModelGroup modelGroup = this.getModelGroup(currTerm);
            if (modelGroup != null) {
                this.processGroup(modelGroup, parentParticle, messageType, processedXmlObjects, schemaSet, enclosingName, targetNamespace, enclosingType);
            }
        }
    }

    private void findGlobalElementsBySubsumption(XSSchemaSet schemaSet, Set<XSElementDecl> existing, XSComplexType type) {
        if (type != schemaSet.getAnyType() && type.getSubtypes() != null) {
            for (XSComplexType subType : type.getSubtypes()) {
                existing.addAll(subType.getElementDecls());
                this.findGlobalElementsBySubsumption(schemaSet, existing, subType);
            }
        }
    }

    private void addOneOfField(MessageType messageType, XSSchemaSet schemaSet, Options fieldOptions, Location fieldLocation, OneOf oneOf, XSElementDecl element) {
        String doc = this.resolveDocumentationAnnotation(element);
        String typeName = element.getType().getName();
        if (typeName == null) {
            typeName = this.processElement(element, schemaSet);
        }
        Field field = new Field(NamespaceHelper.xmlNamespaceToProtoFieldPackagename(element.getType().getTargetNamespace(), this.configuration.forceProtoPackage), fieldLocation, null, element.getName(), doc, messageType.getNextFieldNum(), typeName, fieldOptions, true);
        this.addField(messageType, oneOf, field);
    }

    @NotNull
    private Options getFieldOptions(XSParticle parentParticle) {
        ArrayList<OptionElement> optionElements = new ArrayList<OptionElement>(this.ruleFactory.getValidationRule(parentParticle));
        return new Options(Options.FIELD_OPTIONS, optionElements);
    }

    @NotNull
    private Options getFieldOptions(XSAttributeDecl attributeDecl) {
        ArrayList<OptionElement> optionElements = new ArrayList<OptionElement>();
        List<OptionElement> validationRule = this.ruleFactory.getValidationRule(attributeDecl);
        if (!validationRule.isEmpty()) {
            optionElements.addAll(validationRule);
        } else {
            List<OptionElement> typeRule = this.ruleFactory.getValidationRule(attributeDecl.getType());
            optionElements.addAll(typeRule);
        }
        return new Options(Options.FIELD_OPTIONS, optionElements);
    }

    @NotNull
    private Options getFieldOptions(XSSimpleType attributeDecl) {
        ArrayList<OptionElement> optionElements = new ArrayList<OptionElement>(this.ruleFactory.getValidationRule(attributeDecl));
        return new Options(Options.FIELD_OPTIONS, optionElements);
    }

    public String findFieldType(XSType type) {
        String typeName = type.getName();
        if (typeName == null) {
            if (type.asSimpleType().isRestriction()) {
                try {
                    return this.findFieldType(type.asSimpleType().asRestriction().getBaseType());
                }
                catch (ClassCastException e) {
                    LOGGER.warn("Error getting base type for restriction {}. Appears to be a bug in xsom. Fallback to string field type (best guess)", (Object)type);
                    return DEFAULT_PROTO_PRIMITIVE;
                }
            }
            if (type.asSimpleType().isPrimitive()) {
                typeName = type.asSimpleType().getName();
            } else if (type.asSimpleType().isList()) {
                XSListSimpleType asList2 = type.asSimpleType().asList();
                XSSimpleType itemType = asList2.getItemType();
                typeName = itemType.getName();
            } else {
                typeName = type.asSimpleType().isUnion() ? DEFAULT_PROTO_PRIMITIVE : type.asSimpleType().getBaseType().getName();
            }
        } else if (type.isSimpleType() && type.asSimpleType().isList()) {
            typeName = this.processSimpleType(type.asSimpleType().getBaseListType(), null);
        } else if (!this.basicTypes.contains(typeName)) {
            typeName = type.asSimpleType().getBaseType().getName();
        }
        if ((typeName == null || !this.basicTypes.contains(typeName)) && type.isSimpleType() && type.asSimpleType().isRestriction()) {
            XSType restrictionBase = type.asSimpleType().asRestriction().getBaseType();
            return this.findFieldType(restrictionBase);
        }
        return typeName;
    }

    private Field.Label getLabel(XSParticle parentParticle, XSTerm currTerm) {
        if (this.getLabel(parentParticle) || currTerm instanceof ElementDecl && ((ElementDecl)currTerm).getType() instanceof XSListSimpleType) {
            return Field.Label.REPEATED;
        }
        return null;
    }

    private boolean getLabel(XSParticle part) {
        int max = 1;
        int min2 = 1;
        if (part.getMinOccurs() != null) {
            min2 = part.getMinOccurs().intValue();
        }
        if (part.getMaxOccurs() != null) {
            max = part.getMaxOccurs().intValue();
        }
        return max > 1 || max == -1 || min2 > 1;
    }

    private XSType getBaseType(XSSchemaSet schemaSet, XSType child) {
        XSType parent = child.getBaseType();
        if (parent != schemaSet.getAnyType()) {
            return parent;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private MessageType processComplexType(XSComplexType complexType2, String elementName, XSSchemaSet schemaSet, MessageType messageType, Set<Object> processedXmlObjects) {
        Field field;
        Options fieldOptions;
        XSType parent;
        ++this.nestingLevel;
        LOGGER.debug("{} ComplexType {}, proto {}", StringUtils.leftPad(" ", this.nestingLevel), complexType2, messageType);
        boolean isBaseLevel = messageType == null;
        String typeName = null;
        if (messageType != null) {
            typeName = messageType.getName();
        }
        if (messageType == null) {
            if (this.configuration.skipEmptyTypeInheritance) {
                while (complexType2.getContentType().asParticle() == null && complexType2.getAttributeUses().isEmpty() && complexType2.getBaseType().isComplexType()) {
                    complexType2 = complexType2.getBaseType().asComplexType();
                }
            }
            typeName = complexType2.getName();
            String nameSpace = complexType2.getTargetNamespace();
            if (complexType2.getScope() != null) {
                elementName = complexType2.getScope().getName();
            }
            if (typeName == null) {
                typeName = elementName + GENERATED_NAME_PLACEHOLDER;
            }
            if ((messageType = (MessageType)this.getType(nameSpace, typeName)) == null && !this.basicTypes.contains(typeName)) {
                XSType baseType;
                String doc = this.resolveDocumentationAnnotation(complexType2);
                Location location = this.getLocation(complexType2);
                ArrayList<OptionElement> arrayList = new ArrayList<OptionElement>();
                if (this.configuration.includeXsdOptions && (baseType = this.getBaseType(schemaSet, complexType2)) != null) {
                    String prefix = "";
                    String packageName = NamespaceHelper.xmlNamespaceToProtoPackage(baseType.getTargetNamespace(), this.configuration.defaultProtoPackage);
                    if (StringUtils.trimToNull(packageName) != null && !baseType.getTargetNamespace().equals(nameSpace)) {
                        prefix = packageName + ".";
                    }
                    OptionElement e = new OptionElement("xsd.base_type", OptionElement.Kind.STRING, prefix + baseType.getName(), true);
                    arrayList.add(e);
                }
                Options options = new Options(Options.MESSAGE_OPTIONS, arrayList);
                messageType = new MessageType(ProtoType.get(typeName), location, doc, typeName, options);
                if (complexType2.isGlobal() || complexType2.getScope() != null && complexType2.getScope().isGlobal()) {
                    this.addType(nameSpace, messageType);
                }
                processedXmlObjects = new HashSet<Object>();
                this.elementDeclarationsPerMessageType.put(messageType, processedXmlObjects);
            } else {
                LOGGER.debug("{} Already processed ComplexType {}, ignored", (Object)StringUtils.leftPad(" ", this.nestingLevel), (Object)typeName);
                --this.nestingLevel;
                return messageType;
            }
        }
        if (this.configuration.inheritanceToComposition && complexType2.getContentType().asParticle() != null) {
            ArrayList<Object> parentTypes = new ArrayList<Object>();
            for (parent = complexType2.getBaseType(); parent != schemaSet.getAnyType() && parent.isComplexType(); parent = parent.getBaseType()) {
                MessageType parentType = this.processComplexType(parent.asComplexType(), elementName, schemaSet, null, null);
                processedXmlObjects.addAll((Collection<Object>)this.elementDeclarationsPerMessageType.get(parentType));
                parentTypes.add(parentType);
            }
            if (!this.isAbstract(complexType2)) {
                Collections.reverse(parentTypes);
                for (MessageType messageType2 : parentTypes) {
                    String fieldDoc = messageType2.documentation();
                    ArrayList<OptionElement> optionElements = new ArrayList<OptionElement>();
                    fieldOptions = new Options(Options.FIELD_OPTIONS, optionElements);
                    int tag = messageType.getNextFieldNum();
                    Location fieldLocation = this.getLocation(complexType2);
                    field = new Field(this.findPackageNameForType(messageType2), fieldLocation, null, "_" + messageType2.getName(), fieldDoc, tag, messageType2.getName(), fieldOptions, true);
                    this.addField(messageType, field);
                }
                if (!parentTypes.isEmpty()) {
                    messageType.advanceFieldNum();
                }
            }
        } else if (parent != schemaSet.getAnyType() && parent.isComplexType()) {
            this.processComplexType(parent.asComplexType(), elementName, schemaSet, messageType, processedXmlObjects);
        }
        if (complexType2.getAttributeUses() != null) {
            this.processAttributes(complexType2, messageType, processedXmlObjects);
        }
        if (complexType2.getContentType().asParticle() != null) {
            XSParticle particle2 = complexType2.getContentType().asParticle();
            XSTerm term = particle2.getTerm();
            XSModelGroup xSModelGroup = this.getModelGroup(term);
            if (xSModelGroup != null) {
                String enclosingName = typeName;
                if (xSModelGroup.isModelGroupDecl()) {
                    enclosingName = xSModelGroup.asModelGroupDecl().getName();
                }
                this.processGroup(xSModelGroup, particle2, messageType, processedXmlObjects, schemaSet, enclosingName, complexType2.getTargetNamespace(), complexType2);
            }
        } else if (complexType2.getContentType().asSimpleType() != null) {
            XSSimpleType xsSimpleType = complexType2.getContentType().asSimpleType();
            if (isBaseLevel) {
                void var11_18;
                boolean isList = xsSimpleType.isList();
                if (isList) {
                    xsSimpleType = xsSimpleType.asList().getItemType();
                }
                if (xsSimpleType.isUnion()) {
                    String string = DEFAULT_PROTO_PRIMITIVE;
                } else {
                    String string = xsSimpleType.getName();
                }
                Location fieldLocation = this.getLocation(xsSimpleType);
                Field.Label label = isList || this.isCurrentOrParentList(xsSimpleType) ? Field.Label.REPEATED : null;
                fieldOptions = this.getFieldOptions(xsSimpleType);
                if (var11_18 == null) {
                    String simpleTypeName = this.findFieldType(xsSimpleType);
                    String packageName = NamespaceHelper.xmlNamespaceToProtoFieldPackagename(xsSimpleType.getTargetNamespace(), this.configuration.forceProtoPackage);
                    field = new Field(this.basicTypes.contains(simpleTypeName) ? null : packageName, fieldLocation, label, VALUE, SIMPLECONTENT_VALUE_DEFAULT_DOCUMENTATION, messageType.getNextFieldNum(), simpleTypeName, fieldOptions, true);
                    this.addField(messageType, field);
                } else if (this.basicTypes.contains(var11_18)) {
                    Field field2 = new Field(null, fieldLocation, label, VALUE, SIMPLECONTENT_VALUE_DEFAULT_DOCUMENTATION, messageType.getNextFieldNum(), (String)var11_18, fieldOptions, true);
                    this.addField(messageType, field2);
                } else {
                    XSSimpleType primitiveType = xsSimpleType.getPrimitiveType();
                    if (primitiveType != null) {
                        Field field3 = new Field(null, fieldLocation, label, VALUE, SIMPLECONTENT_VALUE_DEFAULT_DOCUMENTATION, messageType.getNextFieldNum(), primitiveType.getName(), fieldOptions, true);
                        this.addField(messageType, field3);
                    } else {
                        LOGGER.warn("Unhandled simpleType {}", (Object)xsSimpleType);
                    }
                }
            }
        }
        --this.nestingLevel;
        return messageType;
    }

    private boolean isCurrentOrParentList(XSSimpleType xsSimpleType) {
        if (xsSimpleType.isList()) {
            return true;
        }
        if (xsSimpleType.isSimpleType()) {
            try {
                XSType parentSimpleBaseType = xsSimpleType.getBaseType();
                if (parentSimpleBaseType != null && parentSimpleBaseType.isSimpleType()) {
                    return this.isCurrentOrParentList(parentSimpleBaseType.asSimpleType());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isAbstract(XSComplexType complexType2) {
        if (complexType2.isAbstract()) {
            return true;
        }
        if (!complexType2.isGlobal()) {
            return false;
        }
        if (!complexType2.getElementDecls().isEmpty()) {
            long numAbstractElementDecls = complexType2.getElementDecls().stream().map(XSElementDecl::isAbstract).count();
            return (long)complexType2.getElementDecls().size() == numAbstractElementDecls;
        }
        return true;
    }

    private String findPackageNameForType(MessageType parentMessageType) {
        for (Map.Entry<String, ProtoFile> packageAndProtoFile : this.packageToProtoFileMap.entrySet()) {
            ProtoFile file = packageAndProtoFile.getValue();
            for (Type t : file.types()) {
                if (t != parentMessageType) continue;
                return packageAndProtoFile.getKey();
            }
        }
        return null;
    }

    private Location getLocation(XSComponent t) {
        Locator locator = t.getLocator();
        try {
            URI absolute = URI.create(locator.getSystemId());
            URI base = new URI("file", this.configuration.xsdFile.getAbsoluteFile().getParent(), null);
            URI relative = base.relativize(absolute);
            return new Location(base.toString(), relative.toString(), locator.getLineNumber(), locator.getColumnNumber());
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Unable to relativise xsd file path: {}", (Object)e.getMessage());
            return new Location("", locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
        }
    }

    private void processAttributes(XSAttContainer xsAttContainer, MessageType messageType, Set<Object> processedXmlObjects) {
        Iterator<? extends XSAttributeUse> iterator2 = xsAttContainer.iterateDeclaredAttributeUses();
        while (iterator2.hasNext()) {
            XSAttributeUse attr = iterator2.next();
            this.processAttribute(messageType, processedXmlObjects, attr);
        }
        Iterator<? extends XSAttGroupDecl> iterateAttGroups = xsAttContainer.iterateAttGroups();
        while (iterateAttGroups.hasNext()) {
            this.processAttributes(iterateAttGroups.next(), messageType, processedXmlObjects);
        }
    }

    private void processAttribute(MessageType messageType, Set<Object> processedXmlObjects, XSAttributeUse attr) {
        if (!processedXmlObjects.contains(attr)) {
            processedXmlObjects.add(attr);
            XSAttributeDecl decl = attr.getDecl();
            XSSimpleType type = decl.getType();
            if (type.getPrimitiveType() != null || type.isList() || type.isUnion()) {
                Field.Label label;
                String fieldName = decl.getName();
                String doc = this.resolveDocumentationAnnotation(decl);
                int tag = messageType.getNextFieldNum();
                Location fieldLocation = this.getLocation(decl);
                Options fieldOptions = this.getFieldOptions(decl);
                String packageName = NamespaceHelper.xmlNamespaceToProtoFieldPackagename(type.getTargetNamespace(), this.configuration.forceProtoPackage);
                Field.Label label2 = label = type.isList() ? Field.Label.REPEATED : null;
                if (type.isRestriction() && type.getFacet("enumeration") != null) {
                    String enumName = this.createEnum(fieldName, type.asRestriction(), decl.isLocal() ? messageType : null);
                    Field field = new Field(packageName, fieldLocation, label, fieldName, doc, tag, enumName, fieldOptions, false);
                    field.setFromAttribute(true);
                    this.addField(messageType, field);
                } else {
                    String typeName = this.findFieldType(type);
                    Field field = new Field(this.basicTypes.contains(typeName) ? null : packageName, fieldLocation, label, fieldName, doc, tag, typeName, fieldOptions, false);
                    field.setFromAttribute(true);
                    this.addField(messageType, field);
                }
            } else {
                LOGGER.error("Unhandled attribute use {}", (Object)attr.getDecl());
            }
        }
    }

    private XSModelGroup getModelGroup(XSTerm term) {
        XSModelGroupDecl modelGroupDecl = term.asModelGroupDecl();
        if (modelGroupDecl != null) {
            return modelGroupDecl.getModelGroup();
        }
        if (term.isModelGroup()) {
            return term.asModelGroup();
        }
        return null;
    }

    private String createWrapperName(MessageType enclosingType, XSModelGroup.Compositor compositor, String enclosingName, XSComplexType enclosingComplexType) {
        String wrapperPostfix;
        String wrapperPrefix;
        if (XSModelGroup.SEQUENCE.equals((Object)compositor)) {
            wrapperPrefix = "SequenceWrapper";
        } else if (XSModelGroup.CHOICE.equals((Object)compositor)) {
            wrapperPrefix = "ChoiceWrapper";
        } else {
            throw new ConversionException("Cannot wrap message with compositor?" + (Object)((Object)compositor));
        }
        long numExistingWrappers = enclosingType.nestedTypes().stream().filter(MessageType.class::isInstance).map(MessageType.class::cast).filter(e -> e.getName().startsWith(wrapperPrefix)).count();
        String string = wrapperPostfix = enclosingComplexType.isGlobal() ? enclosingComplexType.getName() : enclosingName;
        if (numExistingWrappers == 0L) {
            return StringUtils.join(new Object[]{wrapperPrefix, StringUtils.capitalize(wrapperPostfix)}, "_");
        }
        return StringUtils.join(new Object[]{wrapperPrefix, StringUtils.capitalize(wrapperPostfix), numExistingWrappers + 1L}, "_");
    }

    private void processGroup(XSModelGroup modelGroup, XSParticle particle2, MessageType messageType, Set<Object> processedXmlObjects, XSSchemaSet schemaSet, String enclosingName, String targetNamespace, XSComplexType enclosingType) {
        XSModelGroup.Compositor compositor = modelGroup.getCompositor();
        XSParticle[] children = modelGroup.getChildren();
        if (compositor.equals((Object)XSModelGroup.ALL)) {
            this.processGroupAsSequence(particle2, messageType, processedXmlObjects, schemaSet, children, enclosingName, targetNamespace, enclosingType);
        } else if (compositor.equals((Object)XSModelGroup.SEQUENCE)) {
            boolean repeated = this.getLabel(particle2);
            if (repeated) {
                String typeName = this.createWrapperName(messageType, XSModelGroup.SEQUENCE, enclosingName, enclosingType);
                this.createWrapperAndContinueProcessing(modelGroup, particle2, messageType, processedXmlObjects, schemaSet, children, typeName, targetNamespace, "sequenceWrapper", enclosingType);
            } else {
                this.processGroupAsSequence(particle2, messageType, processedXmlObjects, schemaSet, children, enclosingName, targetNamespace, enclosingType);
            }
        } else if (compositor.equals((Object)XSModelGroup.CHOICE)) {
            boolean repeated = this.getLabel(particle2);
            if (repeated) {
                String typeName = this.createWrapperName(messageType, XSModelGroup.CHOICE, enclosingName, enclosingType);
                this.createWrapperAndContinueProcessing(modelGroup, particle2, messageType, processedXmlObjects, schemaSet, children, typeName, targetNamespace, "choiceWrapper", enclosingType);
            } else {
                this.processGroupAsSequence(particle2, messageType, processedXmlObjects, schemaSet, children, enclosingName, targetNamespace, enclosingType);
            }
        }
        messageType.advanceFieldNum();
    }

    private void createWrapperAndContinueProcessing(XSModelGroup modelGroup, XSParticle particle2, MessageType messageType, Set<Object> processedXmlObjects, XSSchemaSet schemaSet, XSParticle[] children, String typeName, String targetNamespace, String fieldName, XSComplexType enclosingType) {
        if (!processedXmlObjects.contains(particle2)) {
            processedXmlObjects.add(particle2);
            String enclosingName = typeName;
            if (modelGroup.isModelGroupDecl()) {
                enclosingName = modelGroup.asModelGroupDecl().getName();
            }
            String doc = this.resolveDocumentationAnnotation(modelGroup);
            Location location = this.getLocation(modelGroup);
            ArrayList<OptionElement> messageOptions = new ArrayList<OptionElement>();
            Options options = new Options(Options.MESSAGE_OPTIONS, messageOptions);
            MessageType wrapperType = new MessageType(ProtoType.get(typeName), location, doc, typeName, options);
            wrapperType.setWrapperMessageType(true);
            messageType.nestedTypes().add(wrapperType);
            Options fieldOptions = this.getFieldOptions(particle2);
            String fieldPackagename = NamespaceHelper.xmlNamespaceToProtoFieldPackagename(targetNamespace, this.configuration.forceProtoPackage);
            Field field = new Field(fieldPackagename, location, Field.Label.REPEATED, fieldName, doc, messageType.getNextFieldNum(), typeName, fieldOptions, false);
            this.addField(messageType, field);
            this.localTypes.add(new LocalType(particle2, wrapperType, messageType, field, NamespaceHelper.xmlNamespaceToProtoPackage(targetNamespace, this.configuration.forceProtoPackage), enclosingType));
            this.processGroupAsSequence(particle2, wrapperType, processedXmlObjects, schemaSet, children, enclosingName, targetNamespace, enclosingType);
        }
    }

    private void processGroupAsSequence(XSParticle particle2, MessageType messageType, Set<Object> processedXmlObjects, XSSchemaSet schemaSet, XSParticle[] children, String enclosingName, String targetNamespace, XSComplexType enclosingType) {
        for (XSParticle child : children) {
            XSTerm currTerm = child.getTerm();
            if (currTerm.isModelGroup()) {
                if (child.asParticle() != null) {
                    this.processGroup(currTerm.asModelGroup(), child, messageType, processedXmlObjects, schemaSet, enclosingName, targetNamespace, enclosingType);
                    continue;
                }
                this.processGroup(currTerm.asModelGroup(), particle2, messageType, processedXmlObjects, schemaSet, enclosingName, targetNamespace, enclosingType);
                continue;
            }
            this.navigateSubTypes(child, messageType, processedXmlObjects, schemaSet, enclosingName, targetNamespace, enclosingType);
        }
    }

    private String resolveDocumentationAnnotation(XSComponent xsComponent) {
        String doc = "";
        if (xsComponent.getAnnotation() != null && xsComponent.getAnnotation().getAnnotation() instanceof Node) {
            Node annotationEl = (Node)xsComponent.getAnnotation().getAnnotation();
            NodeList annotations = annotationEl.getChildNodes();
            for (int i = 0; i < annotations.getLength(); ++i) {
                Node annotation2 = annotations.item(i);
                if (!"documentation".equals(annotation2.getLocalName())) continue;
                NodeList childNodes = annotation2.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    if (!(childNodes.item(j) instanceof Text)) continue;
                    doc = childNodes.item(j).getNodeValue();
                }
            }
        }
        String[] lines = doc.split("\n");
        StringBuilder b = new StringBuilder();
        for (String line : lines) {
            b.append(StringUtils.trimToEmpty(line));
            b.append(" ");
        }
        if (this.configuration.includeSourceLocationInDoc && xsComponent.getLocator() != null) {
            Location loc = this.getLocation(xsComponent);
            b.append(" [");
            b.append(loc.withoutBase());
            b.append("]");
        }
        return StringUtils.trimToEmpty(b.toString());
    }

    private String createEnum(String elementName, XSRestrictionSimpleType type, MessageType enclosingType) {
        String typeNameToUse;
        if (type.getName() != null) {
            typeNameToUse = type.getName();
            enclosingType = null;
        } else {
            String baseTypeName = type.getBaseType().getName();
            typeNameToUse = baseTypeName != null && !this.basicTypes.contains(baseTypeName) ? baseTypeName : (enclosingType != null ? elementName + TYPE_SUFFIX : elementName + GENERATED_NAME_PLACEHOLDER);
        }
        Type protoType = this.getType(type.getTargetNamespace(), typeNameToUse);
        if (protoType == null) {
            String doc;
            type = type.asRestriction();
            Location location = this.getLocation(type);
            ArrayList<EnumConstant> constants = new ArrayList<EnumConstant>();
            Iterator<? extends XSFacet> it = type.getDeclaredFacets().iterator();
            int counter = 1;
            HashSet<String> addedValues = new HashSet<String>();
            while (it.hasNext()) {
                ArrayList<OptionElement> optionElements = new ArrayList<OptionElement>();
                XSFacet next = it.next();
                doc = this.resolveDocumentationAnnotation(next);
                String enumValue = next.getValue().value;
                if (addedValues.contains(enumValue)) continue;
                addedValues.add(enumValue);
                constants.add(new EnumConstant(location, enumValue, counter++, doc, new Options(Options.ENUM_VALUE_OPTIONS, optionElements)));
            }
            ArrayList<OptionElement> enumOptionElements = new ArrayList<OptionElement>();
            Options enumOptions = new Options(Options.ENUM_OPTIONS, enumOptionElements);
            doc = this.resolveDocumentationAnnotation(type);
            ProtoType definedProtoType = enclosingType == null ? ProtoType.get(typeNameToUse) : ProtoType.get(enclosingType.getName(), typeNameToUse);
            EnumType enumType = new EnumType(definedProtoType, location, doc, typeNameToUse, constants, new ArrayList<Reserved>(), enumOptions);
            if (enclosingType != null) {
                boolean alreadyPresentAsNestedType = false;
                for (Type t : enclosingType.nestedTypes()) {
                    if (!(t instanceof EnumType) || !((EnumType)t).name().equals(typeNameToUse)) continue;
                    alreadyPresentAsNestedType = true;
                    break;
                }
                if (!alreadyPresentAsNestedType) {
                    enclosingType.nestedTypes().add(enumType);
                }
            } else {
                this.addType(type.getTargetNamespace(), enumType);
            }
        }
        return typeNameToUse;
    }

    @Override
    public void error(SAXParseException exception) {
        this.handle(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.handle(exception);
    }

    @Override
    public void warning(SAXParseException exception) {
        this.handle(exception);
    }

    private void handle(SAXParseException exception) {
        LOGGER.error("{} at {}", exception.getMessage(), exception.getSystemId(), exception);
    }

    public List<LocalType> getLocalTypes() {
        return this.localTypes;
    }
}

