/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.CharMatcher;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/squareup/wire/schema/Location;", "", "base", "", "path", "line", "", "column", "(Ljava/lang/String;Ljava/lang/String;II)V", "getBase", "()Ljava/lang/String;", "getColumn", "()I", "getLine", "getPath", "at", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "withPathOnly", "withoutBase", "Companion", "schema2proto-wire"})
public final class Location {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String base;
    @NotNull
    private final String path;
    private final int line;
    private final int column;

    public Location(@NotNull String base, @NotNull String path, int line, int column) {
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(path, "path");
        this.base = base;
        this.path = path;
        this.line = line;
        this.column = column;
    }

    public /* synthetic */ Location(String string, String string2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        this(string, string2, n, n2);
    }

    @NotNull
    public final String getBase() {
        return this.base;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    @NotNull
    public final Location at(int line, int column) {
        return new Location(this.base, this.path, line, column);
    }

    @NotNull
    public final Location withoutBase() {
        return new Location("", this.path, this.line, this.column);
    }

    @NotNull
    public final Location withPathOnly() {
        return new Location("", this.path, -1, -1);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!(((CharSequence)this.base).length() == 0)) {
            $this$toString_u24lambda_u2d0.append(this.base);
            $this$toString_u24lambda_u2d0.append(File.separator);
        }
        $this$toString_u24lambda_u2d0.append(this.path);
        if (this.line != -1) {
            $this$toString_u24lambda_u2d0.append(" at " + this.line);
            if (this.column != -1) {
                $this$toString_u24lambda_u2d0.append("" + ':' + this.column);
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.base;
    }

    @NotNull
    public final String component2() {
        return this.path;
    }

    public final int component3() {
        return this.line;
    }

    public final int component4() {
        return this.column;
    }

    @NotNull
    public final Location copy(@NotNull String base, @NotNull String path, int line, int column) {
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(path, "path");
        return new Location(base, path, line, column);
    }

    public static /* synthetic */ Location copy$default(Location location, String string, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = location.base;
        }
        if ((n3 & 2) != 0) {
            string2 = location.path;
        }
        if ((n3 & 4) != 0) {
            n = location.line;
        }
        if ((n3 & 8) != 0) {
            n2 = location.column;
        }
        return location.copy(string, string2, n, n2);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + Integer.hashCode(this.line);
        result = result * 31 + Integer.hashCode(this.column);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location location = (Location)other;
        if (!Intrinsics.areEqual(this.base, location.base)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.path, location.path)) {
            return false;
        }
        if (this.line != location.line) {
            return false;
        }
        return this.column == location.column;
    }

    @JvmStatic
    @NotNull
    public static final Location get(@NotNull String path) {
        return Companion.get(path);
    }

    @JvmStatic
    @NotNull
    public static final Location get(@NotNull String base, @NotNull String path) {
        return Companion.get(base, path);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/squareup/wire/schema/Location$Companion;", "", "()V", "get", "Lcom/squareup/wire/schema/Location;", "path", "", "base", "schema2proto-wire"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Location get(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            return this.get("", path);
        }

        @JvmStatic
        @NotNull
        public final Location get(@NotNull String base, @NotNull String path) {
            Intrinsics.checkNotNullParameter(base, "base");
            Intrinsics.checkNotNullParameter(path, "path");
            String newBase = CharMatcher.is('/').trimTrailingFrom(base);
            Intrinsics.checkNotNullExpressionValue(newBase, "newBase");
            return new Location(newBase, path, -1, -1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

