/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.NamespaceIdentifier;
import de.slub.urn.RFC;
import de.slub.urn.URNSyntaxError;
import java.util.regex.Pattern;

public final class NID_RFC2141
extends NamespaceIdentifier {
    private static final Pattern allowedNID = Pattern.compile("^[0-9a-zA-Z]?[0-9a-zA-Z-]{0,31}$");

    public NID_RFC2141(String nid) throws URNSyntaxError {
        super(nid);
    }

    public NID_RFC2141(NamespaceIdentifier instanceForCopying) {
        super(instanceForCopying);
    }

    @Override
    public String validateNamespaceIdentifier(String nid) {
        if (!allowedNID.matcher(nid).matches()) {
            return String.format("Not allowed characters in Namespace Identifier '%s'", nid);
        }
        return null;
    }

    @Override
    public RFC supportedRFC() {
        return RFC.RFC_2141;
    }
}

