/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.Message;
import com.squareup.wire.OneOf;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.FieldBinding;
import com.squareup.wire.internal.Internal;
import com.squareup.wire.internal.OneOfBinding;
import com.squareup.wire.internal.RuntimeMessageAdapter;
import com.squareup.wire.internal.RuntimeMessageBinding;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aL\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0014\b\u0000\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004\"\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\u001a^\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0014\b\u0000\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004\"\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001aH\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007\"\u0014\b\u0000\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004\"\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0002\u001aF\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\"\u0014\b\u0000\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004\"\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"createRuntimeMessageAdapter", "Lcom/squareup/wire/internal/RuntimeMessageAdapter;", "M", "B", "Lcom/squareup/wire/Message;", "Lcom/squareup/wire/Message$Builder;", "messageType", "Ljava/lang/Class;", "typeUrl", "", "syntax", "Lcom/squareup/wire/Syntax;", "getBuilderType", "getKeys", "", "Lcom/squareup/wire/OneOf$Key;", "messageField", "Ljava/lang/reflect/Field;", "wire-runtime"})
public final class ReflectionKt {
    @NotNull
    public static final <M extends Message<M, B>, B extends Message.Builder<M, B>> RuntimeMessageAdapter<M, B> createRuntimeMessageAdapter(@NotNull Class<M> messageType, @Nullable String typeUrl, @NotNull Syntax syntax) {
        Intrinsics.checkNotNullParameter(messageType, "messageType");
        Intrinsics.checkNotNullParameter((Object)syntax, "syntax");
        Class<B> builderType = ReflectionKt.getBuilderType(messageType);
        LinkedHashMap fields = new LinkedHashMap();
        for (Field messageField : messageType.getDeclaredFields()) {
            WireField wireField = messageField.getAnnotation(WireField.class);
            if (wireField != null) {
                Map map = fields;
                Integer n = wireField.tag();
                Field field = messageField;
                Intrinsics.checkNotNullExpressionValue(field, "messageField");
                map.put(n, new FieldBinding(wireField, field, builderType));
                continue;
            }
            Field field = messageField;
            Intrinsics.checkNotNullExpressionValue(field, "messageField");
            if (!Intrinsics.areEqual(field.getType(), OneOf.class)) continue;
            for (OneOf.Key<?> key : ReflectionKt.getKeys(messageField)) {
                ((Map)fields).put(key.getTag(), new OneOfBinding(messageField, builderType, key));
            }
        }
        KClass<M> kClass = JvmClassMappingKt.getKotlinClass(messageType);
        Map map = Collections.unmodifiableMap(fields);
        Intrinsics.checkNotNullExpressionValue(map, "Collections.unmodifiableMap(fields)");
        return new RuntimeMessageAdapter(new RuntimeMessageBinding<M, B>(kClass, builderType, map, typeUrl, syntax));
    }

    private static final <M extends Message<M, B>, B extends Message.Builder<M, B>> Set<OneOf.Key<?>> getKeys(Field messageField) {
        Field keysField;
        Class<?> messageClass = messageField.getDeclaringClass();
        String string = messageField.getName();
        Intrinsics.checkNotNullExpressionValue(string, "messageField.name");
        Field field = keysField = messageClass.getDeclaredField(Internal.boxedOneOfKeysFieldName(string));
        Intrinsics.checkNotNullExpressionValue(field, "keysField");
        field.setAccessible(true);
        Object object = keysField.get(null);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Set<com.squareup.wire.OneOf.Key<*>>");
        }
        return (Set)object;
    }

    @NotNull
    public static final <M extends Message<M, B>, B extends Message.Builder<M, B>> RuntimeMessageAdapter<M, B> createRuntimeMessageAdapter(@NotNull Class<M> messageType) {
        Intrinsics.checkNotNullParameter(messageType, "messageType");
        ProtoAdapter<M> defaultAdapter = ProtoAdapter.Companion.get(messageType);
        return ReflectionKt.createRuntimeMessageAdapter(messageType, defaultAdapter.getTypeUrl(), defaultAdapter.getSyntax());
    }

    private static final <M extends Message<M, B>, B extends Message.Builder<M, B>> Class<B> getBuilderType(Class<M> messageType) {
        try {
            Class<?> clazz = Class.forName(messageType.getName() + "$Builder");
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<B>");
            }
            return clazz;
        }
        catch (ClassNotFoundException _) {
            throw (Throwable)new IllegalArgumentException("No builder class found for message type " + messageType.getName());
        }
    }
}

