/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import java.util.Collections;
import java.util.Map;

public final class RQF_RFC8141 {
    public static final RQF_RFC8141 NULL = new RQF_RFC8141(Collections.EMPTY_MAP, Collections.EMPTY_MAP, "");
    private final Map<String, String> resolutionParameters;
    private final Map<String, String> queryParameters;
    private final String fragment;
    private final String stringRepresentation;

    public RQF_RFC8141(Map<String, String> resolutionParameters, Map<String, String> queryParameters, String fragment) {
        if (queryParameters == null) {
            throw new IllegalArgumentException("Resolution parameter map cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Query parameter map cannot be null");
        }
        if (resolutionParameters == null) {
            throw new IllegalArgumentException("Fragment string cannot be null");
        }
        this.resolutionParameters = Collections.unmodifiableMap(resolutionParameters);
        this.queryParameters = Collections.unmodifiableMap(queryParameters);
        this.fragment = fragment;
        this.stringRepresentation = this.initialToString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RQF_RFC8141) {
            RQF_RFC8141 that = (RQF_RFC8141)obj;
            return this.resolutionParameters.equals(that.resolutionParameters) && this.queryParameters.equals(that.queryParameters) && this.fragment.equals(that.fragment);
        }
        return false;
    }

    private String initialToString() {
        StringBuilder sb = new StringBuilder();
        if (!this.resolutionParameters.isEmpty()) {
            sb.append("?+");
            for (Map.Entry<String, String> kv : this.resolutionParameters.entrySet()) {
                sb.append(kv.getKey()).append('=').append(kv.getValue());
            }
        }
        if (!this.queryParameters.isEmpty()) {
            sb.append("?=");
            for (Map.Entry<String, String> kv : this.queryParameters.entrySet()) {
                sb.append(kv.getKey()).append('=').append(kv.getValue());
            }
        }
        if (!this.fragment.isEmpty()) {
            sb.append('#').append(this.fragment);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public Map<String, String> resolutionParameters() {
        return this.resolutionParameters;
    }

    public Map<String, String> queryParameters() {
        return this.queryParameters;
    }

    public String fragment() {
        return this.fragment;
    }
}

