/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.compatibility;

import com.google.common.collect.BiMap;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import no.entur.schema2proto.compatibility.ConflictResolverHelper;
import no.entur.schema2proto.compatibility.protolock.ProtolockEnum;
import no.entur.schema2proto.compatibility.protolock.ProtolockEnumConstant;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumConflictChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumConflictChecker.class);
    private boolean failIfRemovedFieldsTriggered;

    public boolean tryResolveEnumConflicts(ProtoFile file, EnumType enumType, ProtolockEnum protolockEnum) {
        SortedSet<ProtolockEnumConstant> lockEnumConstants = Collections.unmodifiableSortedSet(new TreeSet<ProtolockEnumConstant>(Arrays.asList(protolockEnum.getEnumFields())));
        SortedSet<ProtolockEnumConstant> xsdEnumConstants = Collections.unmodifiableSortedSet(new TreeSet(enumType.constants().stream().map(f -> new ProtolockEnumConstant(f.getTag(), f.getName())).collect(Collectors.toSet())));
        TreeSet newEnumConstantsInXsd = new TreeSet(xsdEnumConstants);
        newEnumConstantsInXsd.removeAll(lockEnumConstants);
        TreeSet<ProtolockEnumConstant> surplusLockEnumConstants = new TreeSet<ProtolockEnumConstant>(lockEnumConstants);
        surplusLockEnumConstants.removeAll(xsdEnumConstants);
        if (newEnumConstantsInXsd.isEmpty() && surplusLockEnumConstants.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No added or removed constants in in proto {} {}", (Object)file.name(), (Object)enumType.name());
            }
        } else if (newEnumConstantsInXsd.isEmpty() && !surplusLockEnumConstants.isEmpty()) {
            surplusLockEnumConstants.stream().forEach(newField -> this.reserveEnumConstant(file, enumType, (ProtolockEnumConstant)newField));
        } else if (!newEnumConstantsInXsd.isEmpty() && surplusLockEnumConstants.isEmpty()) {
            newEnumConstantsInXsd.stream().forEach(newField -> LOGGER.debug("Added field in proto {} {} : {}", file.name(), enumType.name(), newField));
        } else {
            BiMap<String, Integer> xsdConstantsNameToId = ConflictResolverHelper.createBiMap(newEnumConstantsInXsd);
            BiMap<Integer, String> xsdConstantsIdToName = xsdConstantsNameToId.inverse();
            BiMap<String, Integer> newConstantsInLockMapNameToId = ConflictResolverHelper.createBiMap(surplusLockEnumConstants);
            BiMap<Integer, String> newConstantsInLockMapIdToName = newConstantsInLockMapNameToId.inverse();
            TreeSet overlappingNames = new TreeSet(xsdConstantsNameToId.keySet());
            overlappingNames.retainAll(newConstantsInLockMapNameToId.keySet());
            TreeSet overlappingIds = new TreeSet(xsdConstantsNameToId.values());
            overlappingIds.retainAll(newConstantsInLockMapNameToId.values());
            if (!overlappingIds.isEmpty() || !overlappingNames.isEmpty()) {
                String overlappingName;
                Integer originalFieldIdForNewName;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Incompatible changes in proto {} {} , overlapping enum constant ids={}, overlapping enum constant names={}", file.name(), enumType.name(), overlappingIds, overlappingNames);
                }
                AtomicInteger nextAvailableConstantId = this.findNextAvailableFieldNum(enumType, xsdEnumConstants);
                if (!overlappingIds.isEmpty()) {
                    int overlappingId = (Integer)overlappingIds.first();
                    String originalFieldNameUsingThisId = (String)newConstantsInLockMapIdToName.get(overlappingId);
                    if (originalFieldNameUsingThisId != null) {
                        String intrudingFieldName = (String)xsdConstantsIdToName.get(overlappingId);
                        Optional<EnumConstant> intrudingConstant = EnumConflictChecker.getConstant(enumType, intrudingFieldName);
                        Optional<EnumConstant> existingConstant = EnumConflictChecker.getConstant(enumType, originalFieldNameUsingThisId);
                        Integer idFromLockFile = (Integer)newConstantsInLockMapNameToId.get(intrudingFieldName);
                        this.updateEnumConstantId(nextAvailableConstantId, overlappingId, intrudingConstant, existingConstant, idFromLockFile);
                    }
                } else if (!overlappingNames.isEmpty() && (originalFieldIdForNewName = (Integer)newConstantsInLockMapNameToId.get(overlappingName = (String)overlappingNames.first())) != null) {
                    Integer intrudingFieldId = (Integer)xsdConstantsNameToId.get(overlappingName);
                    Optional<EnumConstant> intrudingConstant = this.getConstant(enumType, intrudingFieldId);
                    Optional<EnumConstant> existingConstant = this.getConstant(enumType, originalFieldIdForNewName);
                    Integer idFromLockFile = (Integer)newConstantsInLockMapNameToId.get(overlappingName);
                    this.updateEnumConstantId(nextAvailableConstantId, originalFieldIdForNewName, intrudingConstant, existingConstant, idFromLockFile);
                }
                this.tryResolveEnumConflicts(file, enumType, protolockEnum);
            } else {
                surplusLockEnumConstants.stream().forEach(newConstant -> {
                    this.reserveEnumConstant(file, enumType, (ProtolockEnumConstant)newConstant);
                    LOGGER.debug("Removed constant in proto {}: {}, adding reserved section", (Object)file.name(), newConstant);
                });
            }
        }
        return this.failIfRemovedFieldsTriggered;
    }

    private void updateEnumConstantId(AtomicInteger nextAvailableFieldNum, int overlappingId, Optional<EnumConstant> intrudingField, Optional<EnumConstant> existingField, Integer idFromLockFile) {
        intrudingField.ifPresent(x -> {
            if (idFromLockFile != null) {
                x.updateTag(idFromLockFile);
            } else {
                x.updateTag(nextAvailableFieldNum.get());
            }
        });
        existingField.ifPresent(x -> x.updateTag(overlappingId));
    }

    private Optional<EnumConstant> getConstant(EnumType e, Integer intrudingConstantId) {
        return e.constants().stream().filter(z -> z.getTag() == intrudingConstantId.intValue()).findFirst();
    }

    private void reserveEnumConstant(ProtoFile file, EnumType e, ProtolockEnumConstant newEnumConstant) {
        String reservationDoc = "Reservation added by schema2proto";
        Location loc = new Location("", "", 0, 0);
        e.addReserved(reservationDoc, loc, newEnumConstant.getName());
        e.addReserved(reservationDoc, loc, newEnumConstant.getId());
        LOGGER.warn("Possible backwards incompatibility detected, must be checked manually! Removed enum constant in proto {}, message {}, field {}, blocking enum name and id for future use by adding 'reserved' statement", file.name(), e.name(), newEnumConstant);
        this.failIfRemovedFieldsTriggered = true;
    }

    @NotNull
    private AtomicInteger findNextAvailableFieldNum(EnumType e, SortedSet<ProtolockEnumConstant> xsdFields) {
        AtomicInteger nextAvailableFieldNum = new AtomicInteger(xsdFields.stream().max(Comparator.comparing(ProtolockEnumConstant::getId)).orElse(new ProtolockEnumConstant(0, null)).getId() + 1);
        while (e.reserveds().stream().anyMatch(s2 -> s2.matchesTag(nextAvailableFieldNum.get()))) {
            nextAvailableFieldNum.incrementAndGet();
        }
        return nextAvailableFieldNum;
    }

    private static Optional<EnumConstant> getConstant(EnumType e, String intrudingConstantName) {
        return e.constants().stream().filter(z -> z.getName().equals(intrudingConstantName)).findFirst();
    }
}

