/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.compatibility;

import com.google.gson.Gson;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import no.entur.schema2proto.compatibility.EnumConflictChecker;
import no.entur.schema2proto.compatibility.FieldConflictChecker;
import no.entur.schema2proto.compatibility.protolock.ProtolockDefinition;
import no.entur.schema2proto.compatibility.protolock.ProtolockDefinitions;
import no.entur.schema2proto.compatibility.protolock.ProtolockEnum;
import no.entur.schema2proto.compatibility.protolock.ProtolockFile;
import no.entur.schema2proto.compatibility.protolock.ProtolockMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtolockBackwardsCompatibilityChecker {
    private ProtolockDefinitions definitions = null;
    private EnumConflictChecker enumConflictChecker = new EnumConflictChecker();
    private FieldConflictChecker fieldConflictChecker = new FieldConflictChecker();
    private final String reservationDoc = "Reservation added by schema2proto";
    private final Location reservationLocation = new Location("", "", 0, 0);
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtolockBackwardsCompatibilityChecker.class);

    public void init(File protoLockFile) throws FileNotFoundException {
        Gson gson = new Gson();
        this.definitions = gson.fromJson((Reader)new FileReader(protoLockFile), ProtolockDefinitions.class);
    }

    public ProtolockDefinitions getDefinitions() {
        return this.definitions;
    }

    private void copyReservations(ProtolockMessage protolockMessage, MessageType protoMessage) {
        if (protolockMessage.getReservedIds() != null && protolockMessage.getReservedIds().length > 0) {
            Arrays.stream(protolockMessage.getReservedIds()).forEach(reservedId -> protoMessage.addReserved("Reservation added by schema2proto", this.reservationLocation, (int)reservedId));
        }
        if (protolockMessage.getReservedNames() != null && protolockMessage.getReservedNames().length > 0) {
            Arrays.stream(protolockMessage.getReservedNames()).forEach(reservedName -> protoMessage.addReserved("Reservation added by schema2proto", this.reservationLocation, (String)reservedName));
        }
        protoMessage.nestedTypes().stream().filter(z -> z instanceof MessageType).map(k -> (MessageType)k).forEach(nestedType -> {
            if (protolockMessage.getMessages() != null) {
                Arrays.stream(protolockMessage.getMessages()).forEach(nestedProtolockMessage -> {
                    if (nestedProtolockMessage.getName().equals(nestedType.getName())) {
                        this.copyReservations((ProtolockMessage)nestedProtolockMessage, (MessageType)nestedType);
                    }
                });
            }
        });
    }

    private void copyReservations(ProtolockEnum protolockEnum, EnumType protoEnum) {
        LOGGER.debug("Copying reservations for message {} and enum {}", (Object)protolockEnum, (Object)protoEnum);
        if (protolockEnum.getReservedIds() != null && protolockEnum.getReservedIds().length > 0) {
            Arrays.stream(protolockEnum.getReservedIds()).forEach(reservedId -> protoEnum.addReserved("Reservation added by schema2proto", this.reservationLocation, (int)reservedId));
        }
        if (protolockEnum.getReservedNames() != null && protolockEnum.getReservedNames().length > 0) {
            Arrays.stream(protolockEnum.getReservedNames()).forEach(reservedName -> protoEnum.addReserved("Reservation added by schema2proto", this.reservationLocation, (String)reservedName));
        }
    }

    public boolean resolveBackwardIncompatibilities(ProtoFile protoFile) {
        LOGGER.debug("Trying to resolve backward incompabilities in file {}", (Object)protoFile);
        AtomicBoolean failIfRemovedFieldsTriggered = new AtomicBoolean(false);
        ProtolockFile protolockFile = this.getProtolockFile(protoFile);
        if (protolockFile != null) {
            protoFile.types().stream().filter(type -> type instanceof EnumType).map(enumType -> (EnumType)enumType).forEach(enumType -> {
                if (protolockFile.getEnums() != null) {
                    Arrays.stream(protolockFile.getEnums()).filter(pe -> pe.getName().equals(enumType.name())).findFirst().ifPresent(protolockEnum -> {
                        this.copyReservations((ProtolockEnum)protolockEnum, (EnumType)enumType);
                        if (this.enumConflictChecker.tryResolveEnumConflicts(protoFile, (EnumType)enumType, (ProtolockEnum)protolockEnum)) {
                            failIfRemovedFieldsTriggered.set(true);
                        }
                    });
                }
            });
            protoFile.types().stream().filter(z -> z instanceof MessageType).map(ke -> (MessageType)ke).forEach(e -> {
                ProtolockMessage protolockMessage = this.getProtolockMessage(protolockFile, (MessageType)e);
                if (protolockMessage != null && this.resolveBackwardIncompatibilities(protoFile, protolockMessage, (MessageType)e)) {
                    failIfRemovedFieldsTriggered.set(true);
                }
            });
        }
        return failIfRemovedFieldsTriggered.get();
    }

    private boolean resolveBackwardIncompatibilities(ProtoFile protoFile, ProtolockMessage protolockMessage, MessageType protoMessage) {
        LOGGER.debug("Resolving backward compabilities in file {}, message {}", (Object)protoFile.name(), (Object)protoMessage);
        AtomicBoolean failIfRemovedFieldsTriggered = new AtomicBoolean(false);
        this.copyReservations(protolockMessage, protoMessage);
        if (this.fieldConflictChecker.tryResolveFieldConflicts(protoFile, protoMessage, protolockMessage)) {
            failIfRemovedFieldsTriggered.set(true);
        }
        if (this.tryResolveEnumConflicts(protoFile, protoMessage, protolockMessage)) {
            failIfRemovedFieldsTriggered.set(true);
        }
        protoMessage.nestedTypes().stream().filter(type -> type instanceof MessageType).map(r -> (MessageType)r).forEach(nestedProtoMessage -> {
            ProtolockMessage nestedProtolockMessage = this.getNestedProtolockMessage(protolockMessage, (MessageType)nestedProtoMessage);
            if (nestedProtolockMessage != null && this.resolveBackwardIncompatibilities(protoFile, nestedProtolockMessage, (MessageType)nestedProtoMessage)) {
                failIfRemovedFieldsTriggered.set(true);
            }
        });
        return failIfRemovedFieldsTriggered.get();
    }

    private boolean tryResolveEnumConflicts(ProtoFile protoFile, MessageType protoMessage, ProtolockMessage protolockMessage) {
        LOGGER.debug("Trying to resolve enum conflicts in file {}, message {}", (Object)protoFile.name(), (Object)protoMessage);
        AtomicBoolean failIfRemovedFieldsTriggered = new AtomicBoolean(false);
        protoMessage.nestedTypes().stream().filter(type -> type instanceof EnumType).map(type -> (EnumType)type).forEach(enumType -> {
            if (protolockMessage.getEnums() != null) {
                Arrays.stream(protolockMessage.getEnums()).filter(e -> e.getName().equals(enumType.name())).findFirst().ifPresent(protolockEnum -> {
                    this.copyReservations((ProtolockEnum)protolockEnum, (EnumType)enumType);
                    if (this.enumConflictChecker.tryResolveEnumConflicts(protoFile, (EnumType)enumType, (ProtolockEnum)protolockEnum)) {
                        failIfRemovedFieldsTriggered.set(true);
                    }
                });
            }
        });
        return failIfRemovedFieldsTriggered.get();
    }

    private ProtolockMessage getProtolockMessage(ProtolockFile protolockFile, MessageType protoMessage) {
        if (protolockFile != null && protolockFile.getMessages() != null) {
            return Arrays.stream(protolockFile.getMessages()).filter(message -> message.getName().equals(protoMessage.getName())).findFirst().orElse(null);
        }
        return null;
    }

    private ProtolockMessage getNestedProtolockMessage(ProtolockMessage protolockMessage, MessageType nestedProtoMessage) {
        if (protolockMessage != null && protolockMessage.getMessages() != null) {
            return Arrays.stream(protolockMessage.getMessages()).filter(subMessage -> subMessage.getName().equals(nestedProtoMessage.getName())).findFirst().orElse(null);
        }
        return null;
    }

    private ProtolockFile getProtolockFile(ProtoFile protoFile) {
        String fullPath = protoFile.toString();
        if (!fullPath.contains("/")) {
            fullPath = protoFile.packageName().replace(".", "/") + "/" + protoFile.toString();
        }
        for (ProtolockDefinition def : this.definitions.getDefinitions()) {
            if (!def.getProtopath().replace(":/:", "/").equals(fullPath)) continue;
            return def.getFile();
        }
        LOGGER.warn("Could not find a matching entry in proto.lock for {}", (Object)protoFile.name());
        return null;
    }
}

