/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.internal.JsonFormatter;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0002j\u0002`\u0003H\u0016\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/DurationJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "Ljava/time/Duration;", "Lcom/squareup/wire/Duration;", "()V", "fromString", "value", "", "toStringOrNumber", "wire-runtime"})
public final class DurationJsonFormatter
implements JsonFormatter<Duration> {
    public static final DurationJsonFormatter INSTANCE;

    @NotNull
    public String toStringOrNumber(@NotNull Duration value) {
        String string;
        Intrinsics.checkNotNullParameter(value, "value");
        long seconds = value.getSeconds();
        int nanos = value.getNano();
        String prefix = "";
        if (seconds < 0L) {
            if (seconds == Long.MIN_VALUE) {
                prefix = "-922337203685477580";
                seconds = 8L;
            } else {
                prefix = "-";
                seconds = -seconds;
            }
            if (nanos != 0) {
                --seconds;
                nanos = 1000000000 - nanos;
            }
        }
        if (nanos == 0) {
            String string2 = "%s%ds";
            Object[] objectArray = new Object[]{prefix, seconds};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(this, *args)");
        } else if (nanos % 1000000 == 0) {
            String string4 = "%s%d.%03ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000000L};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "java.lang.String.format(this, *args)");
        } else if (nanos % 1000 == 0) {
            String string6 = "%s%d.%06ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000L};
            boolean bl = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue(string7, "java.lang.String.format(this, *args)");
        } else {
            String string8 = "%s%d.%09ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1L};
            boolean bl = false;
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue(string9, "java.lang.String.format(this, *args)");
        }
        return string;
    }

    @Override
    @NotNull
    public Duration fromString(@NotNull String value) {
        int i;
        int nanosDigits;
        Intrinsics.checkNotNullParameter(value, "value");
        int sIndex = StringsKt.indexOf$default((CharSequence)value, 's', 0, false, 6, null);
        if (sIndex != value.length() - 1) {
            throw (Throwable)new NumberFormatException();
        }
        int dotIndex = StringsKt.indexOf$default((CharSequence)value, '.', 0, false, 6, null);
        if (dotIndex == -1) {
            String string = value;
            int n = 0;
            boolean bl = false;
            String string2 = string.substring(n, sIndex);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string2;
            n = 0;
            long seconds = Long.parseLong(string);
            Duration duration = Duration.ofSeconds(seconds);
            Intrinsics.checkNotNullExpressionValue(duration, "Duration.ofSeconds(seconds)");
            return duration;
        }
        String string = value;
        int n = 0;
        boolean bl = false;
        String string3 = string.substring(n, dotIndex);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        n = 0;
        long seconds = Long.parseLong(string);
        String string4 = value;
        int n2 = dotIndex + 1;
        int n3 = 0;
        String string5 = string4.substring(n2, sIndex);
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string4 = string5;
        n2 = 0;
        long nanos = Long.parseLong(string4);
        if (StringsKt.startsWith$default(value, "-", false, 2, null)) {
            nanos = -nanos;
        }
        n2 = nanosDigits = sIndex - (dotIndex + 1);
        n3 = 9;
        while (n2 < n3) {
            nanos *= (long)10;
            ++i;
        }
        n3 = nanosDigits;
        for (i = 9; i < n3; ++i) {
            nanos /= (long)10;
        }
        Duration duration = Duration.ofSeconds(seconds, nanos);
        Intrinsics.checkNotNullExpressionValue(duration, "Duration.ofSeconds(seconds, nanos)");
        return duration;
    }

    private DurationJsonFormatter() {
    }

    static {
        DurationJsonFormatter durationJsonFormatter;
        INSTANCE = durationJsonFormatter = new DurationJsonFormatter();
    }
}

